/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.platform;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.platform.ConfigurationParameter;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.RelationalDatabaseSupport;

public class DatabaseConfiguration
implements Map<String, ConfigurationParameter> {
    private String description;
    private DatabaseEngine engine;
    private String name;
    private String providerConfigurationId;
    private RelationalDatabaseSupport services;

    public DatabaseConfiguration(RelationalDatabaseSupport services, DatabaseEngine engine, String configurationId, String name, String description) {
        this.services = services;
        this.providerConfigurationId = configurationId;
        this.engine = engine;
        this.name = name;
        this.description = description;
    }

    @Override
    public void clear() {
        try {
            this.services.resetConfiguration(this.providerConfigurationId, new String[0]);
        }
        catch (CloudException e) {
            throw new RuntimeException(e);
        }
        catch (InternalException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (ConfigurationParameter parameter : this.values()) {
            if (value == null && parameter.getValue() == null) {
                return true;
            }
            if (value == null || parameter.getValue() == null || !value.equals(parameter.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, ConfigurationParameter>> entrySet() {
        HashSet<Map.Entry<String, ConfigurationParameter>> set = new HashSet<Map.Entry<String, ConfigurationParameter>>();
        for (ConfigurationParameter cfg : this.values()) {
            set.add(cfg);
        }
        return set;
    }

    @Override
    public ConfigurationParameter get(Object key) {
        for (ConfigurationParameter cfg : this.values()) {
            if (!cfg.getKey().equals(key)) continue;
            return cfg;
        }
        return null;
    }

    public DatabaseEngine getEngine() {
        return this.engine;
    }

    @Override
    public boolean isEmpty() {
        for (ConfigurationParameter cfg : this.values()) {
            if (cfg == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (ConfigurationParameter cfg : this.values()) {
            set.add(cfg.getKey());
        }
        return set;
    }

    @Override
    public ConfigurationParameter put(String key, ConfigurationParameter value) {
        try {
            this.services.updateConfiguration(this.providerConfigurationId, value);
        }
        catch (CloudException e) {
            throw new RuntimeException(e);
        }
        catch (InternalException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends ConfigurationParameter> items) {
        Collection<? extends ConfigurationParameter> values = items.values();
        ConfigurationParameter[] parameters = values.toArray(new ConfigurationParameter[values.size()]);
        try {
            this.services.updateConfiguration(this.providerConfigurationId, parameters);
        }
        catch (CloudException e) {
            throw new RuntimeException(e);
        }
        catch (InternalException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ConfigurationParameter remove(Object key) {
        try {
            this.services.resetConfiguration(this.providerConfigurationId, (String)key);
        }
        catch (CloudException e) {
            throw new RuntimeException(e);
        }
        catch (InternalException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public Collection<ConfigurationParameter> values() {
        try {
            return this.services.listParameters(this.providerConfigurationId);
        }
        catch (CloudException e) {
            throw new RuntimeException(e);
        }
        catch (InternalException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderConfigurationId() {
        return this.providerConfigurationId;
    }
}

