/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.platform;

public enum DatabaseEngine {
    MYSQL,
    MYSQL50,
    MYSQL51,
    MYSQL55,
    ORACLE11G,
    ORACLE11GX,
    ORACLE11GEX;


    public String getVersion() {
        switch (this) {
            case MYSQL: {
                return "5.5";
            }
            case MYSQL50: {
                return "5.0";
            }
            case MYSQL51: {
                return "5.1";
            }
            case MYSQL55: {
                return "5.5";
            }
            case ORACLE11G: {
                return "11g (standard)";
            }
            case ORACLE11GX: {
                return "11g (standard, byol)";
            }
            case ORACLE11GEX: {
                return "11g (enterprise, byol)";
            }
        }
        return null;
    }

    public boolean isMySQL() {
        return this.equals((Object)MYSQL) || this.equals((Object)MYSQL50) || this.equals((Object)MYSQL51) || this.equals((Object)MYSQL55);
    }

    public String toString() {
        switch (this) {
            case MYSQL: {
                return "MySQL (Any)";
            }
            case MYSQL50: {
                return "MySQL 5.0";
            }
            case MYSQL51: {
                return "MySQL 5.1";
            }
            case MYSQL55: {
                return "MySQL 5.5";
            }
            case ORACLE11G: {
                return "Oracle 11g Standard";
            }
            case ORACLE11GX: {
                return "Oracle 11g Standard (BYOL)";
            }
            case ORACLE11GEX: {
                return "Oracle 11g Enterprise";
            }
        }
        return super.toString();
    }
}

