/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.platform;

import java.util.Collection;
import java.util.Locale;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.TimeWindow;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.ConfigurationParameter;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseConfiguration;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.DatabaseSnapshot;

public interface RelationalDatabaseSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("RDBMS:ANY");
    public static final ServiceAction ALTER_DB = new ServiceAction("RDBMS:ALTER_DB");
    public static final ServiceAction CREATE_RDBMS = new ServiceAction("RDBMS:CREATE_RDBMS");
    public static final ServiceAction CREATE_RDBMS_SNAP = new ServiceAction("RDBMS:CREATE_RDBMS_SNAP");
    public static final ServiceAction CREATE_RDBMS_FROM_SNAP = new ServiceAction("RDBMS:CREATE_RDBMS_FROM_SNAP");
    public static final ServiceAction GET_RDBMS = new ServiceAction("RDBMS:GET_RDBMS");
    public static final ServiceAction GET_RDBMS_SNAP = new ServiceAction("RDBMS:GET_RDBMS_SNAP");
    public static final ServiceAction LIST_RDBMS = new ServiceAction("RDBMS:LIST_RDBMS");
    public static final ServiceAction LIST_RDBMS_SNAP = new ServiceAction("RDBMS:LIST_RDBMS_SNAP");
    public static final ServiceAction REMOVE_RDBMS = new ServiceAction("RDBMS:REMOVE_RDBMS");
    public static final ServiceAction REMOVE_RDBMS_SNAP = new ServiceAction("RDBMS:REMOVE_RDBMS_SNAP");
    public static final ServiceAction RESTART = new ServiceAction("RDBMS:RESTART");
    public static final ServiceAction UPDATE_RDBMS_FIREWALL = new ServiceAction("RDBMS:UPDATE_FIREWALL");

    public void addAccess(String var1, String var2) throws CloudException, InternalException;

    public void alterDatabase(String var1, boolean var2, String var3, int var4, String var5, String var6, String var7, int var8, int var9, TimeWindow var10, TimeWindow var11) throws CloudException, InternalException;

    public String createFromScratch(String var1, DatabaseProduct var2, String var3, String var4, String var5, int var6) throws CloudException, InternalException;

    public String createFromLatest(String var1, String var2, String var3, String var4, int var5) throws InternalException, CloudException;

    public String createFromSnapshot(String var1, String var2, String var3, String var4, String var5, int var6) throws CloudException, InternalException;

    public String createFromTimestamp(String var1, String var2, long var3, String var5, String var6, int var7) throws InternalException, CloudException;

    public DatabaseConfiguration getConfiguration(String var1) throws CloudException, InternalException;

    public Database getDatabase(String var1) throws CloudException, InternalException;

    public Iterable<DatabaseEngine> getDatabaseEngines() throws CloudException, InternalException;

    public String getDefaultVersion(DatabaseEngine var1) throws CloudException, InternalException;

    public Iterable<String> getSupportedVersions(DatabaseEngine var1) throws CloudException, InternalException;

    public Iterable<DatabaseProduct> getDatabaseProducts(DatabaseEngine var1) throws CloudException, InternalException;

    public String getProviderTermForDatabase(Locale var1);

    public String getProviderTermForSnapshot(Locale var1);

    public DatabaseSnapshot getSnapshot(String var1) throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;

    public boolean isSupportsFirewallRules();

    public boolean isSupportsHighAvailability() throws CloudException, InterruptedException;

    public boolean isSupportsLowAvailability() throws CloudException, InterruptedException;

    public boolean isSupportsMaintenanceWindows();

    public boolean isSupportsSnapshots();

    public Iterable<String> listAccess(String var1) throws CloudException, InternalException;

    public Iterable<DatabaseConfiguration> listConfigurations() throws CloudException, InternalException;

    public Iterable<Database> listDatabases() throws CloudException, InternalException;

    public Collection<ConfigurationParameter> listParameters(String var1) throws CloudException, InternalException;

    public Iterable<DatabaseSnapshot> listSnapshots(String var1) throws CloudException, InternalException;

    public void removeConfiguration(String var1) throws CloudException, InternalException;

    public void removeDatabase(String var1) throws CloudException, InternalException;

    public void removeSnapshot(String var1) throws CloudException, InternalException;

    public void resetConfiguration(String var1, String ... var2) throws CloudException, InternalException;

    public void restart(String var1, boolean var2) throws CloudException, InternalException;

    public void revokeAccess(String var1, String var2) throws CloudException, InternalException;

    public void updateConfiguration(String var1, ConfigurationParameter ... var2) throws CloudException, InternalException;

    public DatabaseSnapshot snapshot(String var1, String var2) throws CloudException, InternalException;
}

