/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.storage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.util.Retry;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;

public abstract class AbstractBlobStoreSupport
implements BlobStoreSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int bytesRead;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close input stream of hash candidate: " + e);
            }
        }
    }

    @Override
    public void clearBucket(@Nonnull String bucket) throws CloudException, InternalException {
        for (Blob file : this.list(bucket)) {
            String name;
            if (file.isContainer()) {
                name = file.getBucketName();
                if (name == null) continue;
                this.clearBucket(name);
                continue;
            }
            name = file.getObjectName();
            if (name == null) continue;
            this.removeObject(file.getBucketName(), name);
        }
        this.removeBucket(bucket);
    }

    protected void copy(@Nullable String sourceBucket, @Nullable String sourceObject, @Nullable String targetBucket, @Nullable String targetObject) throws InternalException, CloudException {
        if (sourceObject == null) {
            if (targetBucket == null && !this.allowsRootObjects()) {
                throw new CloudException("Cannot place objects in the root");
            }
            if (targetBucket != null && targetBucket.equalsIgnoreCase(sourceBucket)) {
                throw new CloudException("Cannot copy in place");
            }
            if (targetBucket != null && !this.exists(targetBucket)) {
                this.createBucket(targetBucket, false);
            }
            for (Blob blob : this.list(sourceBucket)) {
                this.copy(blob.getBucketName(), blob.getObjectName(), targetBucket, null);
            }
        } else {
            if (targetObject == null) {
                targetObject = sourceObject;
            }
            this.copyFile(sourceBucket, sourceObject, targetBucket, targetObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(@Nonnull InputStream input, @Nonnull OutputStream output, @Nullable FileTransfer xfer) throws IOException {
        try {
            int count;
            byte[] bytes = new byte[10240];
            long total = 0L;
            if (xfer != null) {
                xfer.setBytesTransferred(0L);
            }
            while ((count = input.read(bytes, 0, 10240)) != -1) {
                if (count <= 0) continue;
                output.write(bytes, 0, count);
                total += (long)count;
                if (xfer == null) continue;
                xfer.setBytesTransferred(total);
            }
            output.flush();
        }
        finally {
            input.close();
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(@Nullable String sourceBucket, @Nonnull String sourceObject, @Nullable String targetBucket, @Nonnull String targetObject) throws InternalException, CloudException {
        File tmp = null;
        try {
            try {
                tmp = File.createTempFile("file", ".tmp");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InternalException(e);
            }
            this.get(sourceBucket, sourceObject, tmp, null);
            this.put(targetBucket, targetObject, tmp);
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    @Override
    public FileTransfer download(final @Nullable String bucketName, final @Nonnull String objectName, final @Nonnull File diskFile) throws CloudException, InternalException {
        final FileTransfer transfer = new FileTransfer();
        Storage<Byte> bytes = this.getObjectSize(bucketName, objectName);
        if (bytes == null) {
            throw new CloudException("File does not exist");
        }
        transfer.setBytesToTransfer(bytes.getQuantity().intValue());
        if (transfer.getBytesToTransfer() == -1L) {
            throw new CloudException("No such file: " + (bucketName == null ? "/" : "/" + bucketName) + "/" + objectName);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                Callable<Object> operation = new Callable<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object call() throws Exception {
                        boolean success = false;
                        try {
                            AbstractBlobStoreSupport.this.get(bucketName, objectName, diskFile, transfer);
                            success = true;
                            Object var2_2 = null;
                            return var2_2;
                        }
                        finally {
                            if (!success && diskFile.exists()) {
                                diskFile.delete();
                            }
                        }
                    }
                };
                try {
                    new Retry().retry(5, (Callable)operation);
                    transfer.complete(null);
                }
                catch (CloudException e) {
                    transfer.complete(e);
                }
                catch (InternalException e) {
                    transfer.complete(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    transfer.complete(t);
                }
            }
        };
        t.setDaemon(true);
        t.start();
        return transfer;
    }

    protected abstract void get(@Nullable String var1, @Nonnull String var2, @Nonnull File var3, @Nullable FileTransfer var4) throws InternalException, CloudException;

    @Nonnull
    protected String getChecksum(@Nonnull InputStream input) throws NoSuchAlgorithmException, IOException {
        return this.toBase64(this.computeMD5Hash(input));
    }

    protected abstract void put(@Nullable String var1, @Nonnull String var2, @Nonnull File var3) throws InternalException, CloudException;

    protected abstract void put(@Nullable String var1, @Nonnull String var2, @Nonnull String var3) throws InternalException, CloudException;

    @Nonnull
    private String toBase64(@Nonnull byte[] data) {
        byte[] b64 = Base64.encodeBase64((byte[])data);
        return new String(b64);
    }
}

