/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.storage;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;

public class Blob
implements Comparable<Blob> {
    private long creationTimestamp;
    private String bucketName;
    private String location;
    private String objectName;
    private String providerRegionId;
    private Storage<Byte> size;

    @Nonnull
    public static Blob getInstance(@Nonnull String providerRegionId, @Nonnull String location, @Nonnull String bucketName, @Nonnegative long creationTimestamp) {
        Blob blob = new Blob();
        blob.creationTimestamp = creationTimestamp;
        blob.providerRegionId = providerRegionId;
        blob.bucketName = bucketName;
        blob.objectName = null;
        blob.location = location;
        blob.size = null;
        return blob;
    }

    @Nonnull
    public static Blob getInstance(@Nonnull String providerRegionId, @Nonnull String location, @Nullable String bucketName, @Nonnull String objectName, @Nonnegative long creationTimestamp, @Nonnull Storage<?> size) {
        Blob blob = new Blob();
        blob.creationTimestamp = creationTimestamp;
        blob.providerRegionId = providerRegionId;
        blob.bucketName = bucketName;
        blob.objectName = objectName;
        blob.location = location;
        blob.size = (Storage)size.convertTo((UnitOfMeasure)Storage.BYTE);
        return blob;
    }

    private Blob() {
    }

    @Override
    public int compareTo(@Nullable Blob other) {
        if (other == null) {
            return 1;
        }
        if (other == this) {
            return 0;
        }
        if (this.bucketName != null && other.bucketName == null) {
            return 1;
        }
        if (this.bucketName == null && other.bucketName != null) {
            return -1;
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        Blob file = (Blob)other;
        if (this.bucketName == null) {
            if (file.bucketName != null) {
                return false;
            }
            if (this.objectName == null) {
                return file.objectName == null;
            }
            return this.objectName.equals(file.objectName);
        }
        return this.bucketName.equals(file.bucketName) && (this.objectName == null && file.objectName == null || this.objectName != null && this.objectName.equals(file.objectName));
    }

    @Nullable
    public String getBucketName() {
        return this.bucketName;
    }

    public boolean isContainer() {
        return this.objectName == null;
    }

    @Nonnegative
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Nonnull
    public String getLocation() {
        return this.location;
    }

    @Nullable
    public String getObjectName() {
        return this.objectName;
    }

    @Nonnull
    public String getProviderRegionId() {
        return this.providerRegionId;
    }

    @Nullable
    public Storage<Byte> getSize() {
        return this.size;
    }

    @Nonnull
    public String toString() {
        return (this.bucketName == null ? "/" : "/" + this.bucketName) + (this.objectName == null ? "" : "/" + this.objectName);
    }
}

