/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.storage;

import java.io.File;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.NameRules;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;

public interface BlobStoreSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("BLOB:ANY");
    public static final ServiceAction CREATE_BUCKET = new ServiceAction("BLOB:CREATE_BUCKET");
    public static final ServiceAction DOWNLOAD = new ServiceAction("BLOB:DOWNLOAD");
    public static final ServiceAction GET_BUCKET = new ServiceAction("BLOB:GET_BUCKET");
    public static final ServiceAction LIST_BUCKET = new ServiceAction("BLOB:LIST_BUCKET");
    public static final ServiceAction LIST_BUCKET_CONTENTS = new ServiceAction("BLOB:LIST_BUCKET_CONTENTS");
    public static final ServiceAction MAKE_PUBLIC = new ServiceAction("BLOB:MAKE_PUBLIC");
    public static final ServiceAction REMOVE_BUCKET = new ServiceAction("BLOB:REMOVE_BUCKET");
    public static final ServiceAction UPLOAD = new ServiceAction("BLOB:UPLOAD");

    public boolean allowsNestedBuckets() throws CloudException, InternalException;

    public boolean allowsRootObjects() throws CloudException, InternalException;

    public boolean allowsPublicSharing() throws CloudException, InternalException;

    public void clearBucket(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Blob createBucket(@Nonnull String var1, boolean var2) throws InternalException, CloudException;

    public FileTransfer download(@Nullable String var1, @Nonnull String var2, @Nonnull File var3) throws InternalException, CloudException;

    public boolean exists(@Nonnull String var1) throws InternalException, CloudException;

    public Blob getBucket(@Nonnull String var1) throws InternalException, CloudException;

    public Blob getObject(@Nullable String var1, @Nonnull String var2) throws InternalException, CloudException;

    @Nullable
    public Storage<Byte> getObjectSize(@Nullable String var1, @Nullable String var2) throws InternalException, CloudException;

    public int getMaxBuckets() throws CloudException, InternalException;

    public Storage<Byte> getMaxObjectSize() throws InternalException, CloudException;

    public int getMaxObjectsPerBucket() throws CloudException, InternalException;

    @Nonnull
    public NameRules getBucketNameRules() throws CloudException, InternalException;

    @Nonnull
    public NameRules getObjectNameRules() throws CloudException, InternalException;

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale var1);

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale var1);

    public boolean isPublic(@Nullable String var1, @Nullable String var2) throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;

    @Nonnull
    public Iterable<Blob> list(@Nullable String var1) throws CloudException, InternalException;

    public void makePublic(@Nonnull String var1) throws InternalException, CloudException;

    public void makePublic(@Nullable String var1, @Nonnull String var2) throws InternalException, CloudException;

    public void move(@Nullable String var1, @Nullable String var2, @Nullable String var3) throws InternalException, CloudException;

    public void removeBucket(@Nonnull String var1) throws CloudException, InternalException;

    public void removeObject(@Nullable String var1, @Nonnull String var2) throws CloudException, InternalException;

    @Nonnull
    public String renameBucket(@Nonnull String var1, @Nonnull String var2, boolean var3) throws CloudException, InternalException;

    public void renameObject(@Nullable String var1, @Nonnull String var2, @Nonnull String var3) throws CloudException, InternalException;

    @Nonnull
    public Blob upload(@Nonnull File var1, @Nullable String var2, @Nonnull String var3) throws CloudException, InternalException;
}

