/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DOProvider
implements Comparable<DOProvider> {
    private static final String AWS_NAME = "AWS";
    private static final String ENSTRATUS_NAME = "Enstratius";
    private static final String EUCALYPTUS_NAME = "Eucalyptus";
    private static final String OPENSTACK_NAME = "OpenStack";
    private static final String OTHER_NAME = "Other";
    private static final String STORAGE_NAME = "Storage";
    private static final String[] OPENSTACK_PROVIDERS = new String[]{"CloudScaling "};
    private static final String[] STORAGE_PROVIDERS = new String[]{"Google", "Riak"};
    public static final DOProvider AWS = new DOProvider("AWS");
    public static final DOProvider ENSTRATUS = new DOProvider("Enstratius");
    public static final DOProvider OPENSTACK = new DOProvider("OpenStack");
    public static final DOProvider EUCALYPTUS = new DOProvider("Eucalyptus");
    public static final DOProvider OTHER = new DOProvider("Other");
    public static final DOProvider STORAGE = new DOProvider("Storage");
    private static Set<DOProvider> providers;
    private String providerName;

    @Nonnull
    public static DOProvider valueOf(@Nonnull String providerName) {
        if (providerName.equalsIgnoreCase("Amazon")) {
            return AWS;
        }
        if (providers == null) {
            TreeSet tmp = new TreeSet();
            Collections.addAll(tmp, AWS, ENSTRATUS, EUCALYPTUS, OPENSTACK, STORAGE);
            providers = Collections.unmodifiableSet(tmp);
        }
        for (DOProvider provider : providers) {
            if (!provider.providerName.equalsIgnoreCase(providerName)) continue;
            return provider;
        }
        for (String name : OPENSTACK_PROVIDERS) {
            if (!name.equalsIgnoreCase(providerName)) continue;
            return OPENSTACK;
        }
        for (String name : STORAGE_PROVIDERS) {
            if (!name.equalsIgnoreCase(providerName)) continue;
            return STORAGE;
        }
        return OTHER;
    }

    @Nonnull
    public static Set<DOProvider> values() {
        return providers;
    }

    private DOProvider(String provider) {
        this.providerName = provider;
    }

    @Override
    public int compareTo(@Nullable DOProvider other) {
        if (other == null) {
            return -1;
        }
        return this.providerName.compareTo(other.providerName);
    }

    public boolean equals(@Nullable Object ob) {
        return ob != null && (ob == this || this.getClass().getName().equals(ob.getClass().getName()) && this.providerName.equals(((DOProvider)ob).providerName));
    }

    @Nonnull
    public String getName() {
        return this.providerName;
    }

    @Nonnull
    public String toString() {
        return this.providerName;
    }

    public boolean isAWS() {
        return this.providerName.equals(AWS_NAME);
    }

    public boolean isEnStratus() {
        return this.providerName.equals(ENSTRATUS_NAME);
    }

    public boolean isEucalyptus() {
        return this.providerName.equals(EUCALYPTUS_NAME);
    }

    public boolean isOpenStack() {
        return this.providerName.equals(OPENSTACK_NAME);
    }

    public boolean isOther() {
        return this.providerName.equals(OTHER_NAME);
    }

    public boolean isStorage() {
        return this.providerName.equals(STORAGE_NAME);
    }
}

