/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.digitalocean.DOProvider;
import org.dasein.cloud.digitalocean.compute.DOComputeServices;
import org.dasein.cloud.digitalocean.dc.DOLocation;
import org.dasein.cloud.digitalocean.identity.IdentityServices;

public class DigitalOcean
extends AbstractCloud {
    private static final Logger logger = DigitalOcean.getLogger(DigitalOcean.class);
    private volatile transient DOProvider provider;

    @Nullable
    public String getDOUrl() throws InternalException, CloudException {
        String url = this.getUrl();
        return url;
    }

    @Nullable
    public String getUrl() throws InternalException, CloudException {
        String url;
        ProviderContext ctx = this.getContext();
        String string = url = ctx == null ? null : ctx.getCloud().getEndpoint();
        if (url == null) {
            return "https://api.digitalocean.com/";
        }
        if (url.endsWith("//")) {
            url = url.substring(0, url.length() - 1);
        } else if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!url.startsWith("http")) {
            String cloudUrl = ctx.getCloud().getEndpoint();
            if (cloudUrl != null && cloudUrl.startsWith("http:")) {
                return "http://" + url;
            }
            return "https://" + url;
        }
        return url;
    }

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        String pkg = DigitalOcean.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("digitalocean") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.digitalocean.std." + pkg + DigitalOcean.getLastItem(cls.getName())));
    }

    @Nonnull
    public static Logger getWireLogger(@Nonnull Class<?> cls) {
        return Logger.getLogger((String)("dasein.cloud.digitalocean.wire." + DigitalOcean.getLastItem(cls.getPackage().getName()) + "." + DigitalOcean.getLastItem(cls.getName())));
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloud().getCloudName();
        return name == null ? "DigitalOcean" : name;
    }

    @Nonnull
    public ContextRequirements getContextRequirements() {
        return new ContextRequirements(new ContextRequirements.Field[]{new ContextRequirements.Field("token", "The Token key used to connect to this cloud", ContextRequirements.FieldType.TOKEN, true)});
    }

    @Nonnull
    public DOLocation getDataCenterServices() {
        return new DOLocation(this);
    }

    @Nonnull
    public DOComputeServices getComputeServices() {
        return new DOComputeServices(this);
    }

    @Nonnull
    public IdentityServices getIdentityServices() {
        return new IdentityServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloud().getProviderName();
        return name == null ? "DigitalOcean" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOcean.class.getName() + ".testContext()"));
        }
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                logger.warn((Object)"No context was provided for testing");
                String string = null;
                return string;
            }
            if (this.getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                String string = ctx.getAccountNumber();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOcean.class.getName() + ".textContext()"));
            }
        }
    }

    @Nonnull
    public HttpClient getClient() throws InternalException {
        return this.getClient(false);
    }

    @Nonnull
    public HttpClient getClient(boolean multipart) throws InternalException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        BasicHttpParams params = new BasicHttpParams();
        int timeout = 15000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        if (!multipart) {
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)Consts.UTF_8.toString());
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPortStr = p.getProperty("proxyPort");
            int proxyPort = 0;
            if (proxyPortStr != null) {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, proxyPort));
            }
        }
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        client.addRequestInterceptor(new HttpRequestInterceptor((HttpParams)params){
            final /* synthetic */ HttpParams val$params;
            {
                this.val$params = httpParams;
            }

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
                request.setParams(this.val$params);
            }
        });
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header header;
                HttpEntity entity = response.getEntity();
                if (entity != null && (header = entity.getContentEncoding()) != null) {
                    for (HeaderElement codec : header.getElements()) {
                        if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        break;
                    }
                }
            }
        });
        return client;
    }
}

