/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.compute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.digitalocean.DigitalOcean;
import org.dasein.cloud.digitalocean.compute.DOImageCapabilities;
import org.dasein.cloud.digitalocean.models.Action;
import org.dasein.cloud.digitalocean.models.Droplet;
import org.dasein.cloud.digitalocean.models.Image;
import org.dasein.cloud.digitalocean.models.Images;
import org.dasein.cloud.digitalocean.models.actions.droplet.Snapshot;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanAction;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanModelFactory;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class DOImage
extends AbstractImageSupport<DigitalOcean> {
    private static final Logger logger = Logger.getLogger(DOImage.class);
    private DigitalOcean provider = null;
    private volatile transient ImageCapabilities capabilities;

    public DOImage(DigitalOcean provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public void addImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not supported by " + ((DigitalOcean)this.getProvider()).getCloudName());
    }

    public void addPublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not supported by " + ((DigitalOcean)this.getProvider()).getCloudName());
    }

    public ImageCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new DOImageCapabilities(this.provider);
        }
        return this.capabilities;
    }

    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.capture");
        try {
            Droplet droplet = DigitalOceanModelFactory.getDropletByInstance((DigitalOcean)this.getProvider(), options.getVirtualMachineId());
            if (droplet == null) {
                throw new InternalException("Virtual machine " + options.getVirtualMachineId() + " does not exist, unable to capture");
            }
            ((DigitalOcean)this.getProvider()).getComputeServices().getVirtualMachineSupport().waitForAllDropletEventsToComplete(options.getVirtualMachineId(), 5);
            List<String> previousSnapshotIds = Arrays.asList(droplet.getSnapshotIds());
            Action action = DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)new Snapshot(options.getName()), options.getVirtualMachineId());
            while (!action.isComplete()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (action.isError()) {
                    throw new CloudException(action.getStatus());
                }
                action = DigitalOceanModelFactory.getEventById((DigitalOcean)this.getProvider(), action.getId());
            }
            droplet = DigitalOceanModelFactory.getDropletByInstance((DigitalOcean)this.getProvider(), options.getVirtualMachineId());
            ArrayList<String> newSnapshotIds = new ArrayList<String>();
            newSnapshotIds.addAll(Arrays.asList(droplet.getSnapshotIds()));
            newSnapshotIds.removeAll(previousSnapshotIds);
            for (String snapshotId : newSnapshotIds) {
                Image image = (Image)DigitalOceanModelFactory.getModelById((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.IMAGE, snapshotId);
                if (!options.getName().equalsIgnoreCase(image.getName())) continue;
                MachineImage machineImage = this.toImage(image);
                return machineImage;
            }
            throw new CloudException("Unable to create or find the captured image for VM " + options.getVirtualMachineId());
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchImages(String accountNumber, String keyword, Platform platform, Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.searchImages");
        try {
            ArrayList<MachineImage> results = new ArrayList<MachineImage>();
            ArrayList images = new ArrayList();
            if (accountNumber == null) {
                images.addAll((Collection)this.searchPublicImages(ImageFilterOptions.getInstance()));
            }
            images.addAll((Collection)this.listImages(ImageFilterOptions.getInstance()));
            for (MachineImage image : images) {
                Platform p;
                if (image == null || keyword != null && !image.getProviderMachineImageId().contains(keyword) && !image.getName().contains(keyword) && !image.getDescription().contains(keyword) || platform != null && !platform.equals((Object)(p = image.getPlatform())) && (!platform.isWindows() ? !platform.equals((Object)Platform.UNIX) || !p.isUnix() : !p.isWindows())) continue;
                if (architecture != null && architecture != image.getArchitecture()) continue;
                results.add(image);
            }
            ArrayList<MachineImage> arrayList = results;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private Iterable<MachineImage> executeImageSearch(boolean publicImagesOnly, @Nonnull ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Image.executeImageSearch");
        try {
            String regionId = this.getContext().getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            Architecture architecture = options.getArchitecture();
            if (!(architecture == null || architecture.equals((Object)Architecture.I32) || architecture.equals((Object)Architecture.I64) || options.isMatchesAny())) {
                List<MachineImage> list = Collections.emptyList();
                return list;
            }
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)("images" + (publicImagesOnly ? "pub" : "prv") + "-" + regionId), MachineImage.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)5, (TimePeriodUnit)TimePeriod.MINUTE));
            Collection cachedImages = (Collection)cache.get(this.getContext());
            if (cachedImages != null) {
                Collection collection = cachedImages;
                return collection;
            }
            ArrayList<MachineImage> results = new ArrayList<MachineImage>();
            org.dasein.cloud.digitalocean.models.rest.DigitalOcean cmd = publicImagesOnly ? org.dasein.cloud.digitalocean.models.rest.DigitalOcean.IMAGES_PUBLIC : org.dasein.cloud.digitalocean.models.rest.DigitalOcean.IMAGES;
            Images images = (Images)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), cmd);
            int total = images.getTotal();
            int page = 1;
            while (true) {
                for (Image image : images.getImages()) {
                    MachineImage machineImage = this.toImage(image);
                    if (machineImage != null && options.matches(machineImage) && publicImagesOnly == machineImage.isPublic()) {
                        int regions = image.getRegions().length;
                        total += regions - 1;
                        for (String region : image.getRegions()) {
                            machineImage.setProviderRegionId(regionId);
                            results.add(machineImage);
                        }
                        continue;
                    }
                    --total;
                }
                if (total <= 0 || total == results.size()) break;
                images = (Images)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), cmd, ++page);
            }
            ArrayList<MachineImage> arrayList = results;
            return arrayList;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage());
            throw new CloudException(e);
        }
        finally {
            APITrace.end();
        }
    }

    private MachineImage toImage(Image image) throws InternalException {
        Platform platform;
        if (image == null) {
            return null;
        }
        if (image.getRegions().length > 0 && !Arrays.asList(image.getRegions()).contains(this.getContext().getRegionId())) {
            return null;
        }
        MachineImageState mis = MachineImageState.ACTIVE;
        if (image.getRegions().length == 0) {
            mis = MachineImageState.DELETED;
        }
        Architecture arch = Architecture.I64;
        if (image.getName().contains("x32")) {
            arch = Architecture.I32;
        }
        if ((platform = Platform.guess((String)image.getDistribution())).equals((Object)Platform.UNKNOWN)) {
            platform = Platform.guess((String)image.getName());
        }
        MachineImage machineImage = MachineImage.getInstance((String)this.getContext().getAccountNumber(), (String)this.getContext().getRegionId(), (String)image.getId(), (ImageClass)ImageClass.MACHINE, (MachineImageState)mis, (String)image.getName(), (String)image.getDistribution(), (Architecture)arch, (Platform)platform);
        String software = null;
        int pos = image.getName().indexOf(" on ");
        if (pos >= 1) {
            software = image.getName().substring(0, pos);
        }
        if (software != null) {
            machineImage.withSoftware(software);
        }
        if (image.getPublic()) {
            machineImage.sharedWithPublic();
        }
        return machineImage;
    }

    private ResourceStatus toStatus(Image image) throws InternalException {
        if (image == null) {
            return null;
        }
        if (image.getRegions().length > 0 && !Arrays.asList(image.getRegions()).contains(this.getContext().getRegionId())) {
            return null;
        }
        MachineImageState state = MachineImageState.DELETED;
        String vmId = String.valueOf(image.getId());
        if (image.getRegions().length > 0) {
            state = MachineImageState.ACTIVE;
        }
        return new ResourceStatus(vmId, (Object)state);
    }

    @Nullable
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Image.getImage");
        try {
            Image image = (Image)DigitalOceanModelFactory.getModelById((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.IMAGE, providerImageId);
            MachineImage machineImage = this.toImage(image);
            return machineImage;
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 404) {
                MachineImage machineImage = null;
                return machineImage;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Image.isImageSharedWithPublic");
        try {
            MachineImage image = this.getImage(machineImageId);
            if (image == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = image.isPublic();
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(final @Nonnull ImageClass cls) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<ResourceStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<ResourceStatus> iterator) throws Exception {
                APITrace.begin((CloudProvider)DOImage.this.provider, (String)"Image.listImageStatus");
                try {
                    for (ResourceStatus status : DOImage.this.executeStatusList(cls)) {
                        iterator.push((Object)status);
                    }
                }
                finally {
                    DOImage.this.provider.release();
                    APITrace.end();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nonnull
    private Iterable<ResourceStatus> executeStatusList(@Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.executeStatusList");
        try {
            ArrayList<ResourceStatus> results = new ArrayList<ResourceStatus>();
            Images images = (Images)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.IMAGES);
            int total = images.getTotal();
            int page = 1;
            while (true) {
                for (Image image : images.getImages()) {
                    ResourceStatus status = this.toStatus(image);
                    if (status != null) {
                        results.add(status);
                        continue;
                    }
                    --total;
                }
                if (total <= 0 || total == results.size()) break;
                images = (Images)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.IMAGES, ++page);
            }
            ArrayList<ResourceStatus> arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image removal not supported by " + ((DigitalOcean)this.getProvider()).getCloudName());
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        final ImageFilterOptions opts = options == null ? ImageFilterOptions.getInstance() : options;
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<MachineImage> iterator) throws Exception {
                APITrace.begin((CloudProvider)DOImage.this.getProvider(), (String)"Image.listImages");
                try {
                    for (MachineImage img : DOImage.this.executeImageSearch(false, opts)) {
                        iterator.push((Object)img);
                    }
                }
                finally {
                    DOImage.this.provider.release();
                    APITrace.end();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(final @Nonnull ImageFilterOptions options) throws CloudException, InternalException {
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<MachineImage> iterator) throws Exception {
                APITrace.begin((CloudProvider)DOImage.this.getProvider(), (String)"searchPublicImages");
                try {
                    try {
                        for (MachineImage img : DOImage.this.executeImageSearch(true, options)) {
                            iterator.push((Object)img);
                        }
                    }
                    finally {
                        DOImage.this.provider.release();
                    }
                }
                finally {
                    APITrace.end();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    public void updateTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
        this.updateTags(new String[]{imageId}, tags);
    }

    public void updateTags(@Nonnull String[] imageIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image tagging not supported by " + ((DigitalOcean)this.getProvider()).getCloudName());
    }

    public void removeTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
        this.removeTags(new String[]{imageId}, tags);
    }

    public void removeTags(@Nonnull String[] imageIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image tagging not supported by " + ((DigitalOcean)this.getProvider()).getCloudName());
    }
}

