/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.compute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.digitalocean.DigitalOcean;
import org.dasein.cloud.util.NamingConstraints;

public class DOImageCapabilities
extends AbstractCapabilities<DigitalOcean>
implements ImageCapabilities {
    private static final transient List<MachineImageType> imageTypes = Arrays.asList(MachineImageType.VOLUME);

    public DOImageCapabilities(DigitalOcean cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canBundle(@Nonnull VmState vmState) throws CloudException, InternalException {
        return false;
    }

    public boolean canImage(@Nonnull VmState vmState) throws CloudException, InternalException {
        return VmState.STOPPED.equals((Object)vmState);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass imageClass) {
        return "image";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass imageClass) {
        return this.getProviderTermForImage(locale, imageClass);
    }

    @Nullable
    public VisibleScope getImageVisibleScope() {
        return VisibleScope.ACCOUNT_REGION;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Arrays.asList(MachineImageFormat.RAW);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Arrays.asList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return imageTypes;
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType machineImageType) {
        return imageTypes.contains(machineImageType);
    }

    public boolean supportsImageCopy() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageSharing() {
        return false;
    }

    public boolean supportsImageSharingWithPublic() {
        return false;
    }

    public boolean supportsListingAllRegions() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass imageClass) {
        return true;
    }

    public boolean imageCaptureDestroysVM() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public NamingConstraints getImageNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).constrainedBy(new char[]{'_', '-', '(', ')', '+', ',', '.'});
    }
}

