/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.compute;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMFilterOptions;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.digitalocean.DigitalOcean;
import org.dasein.cloud.digitalocean.compute.DOInstanceCapabilities;
import org.dasein.cloud.digitalocean.models.Action;
import org.dasein.cloud.digitalocean.models.Actions;
import org.dasein.cloud.digitalocean.models.Droplet;
import org.dasein.cloud.digitalocean.models.Droplets;
import org.dasein.cloud.digitalocean.models.Network;
import org.dasein.cloud.digitalocean.models.Size;
import org.dasein.cloud.digitalocean.models.Sizes;
import org.dasein.cloud.digitalocean.models.actions.droplet.Destroy;
import org.dasein.cloud.digitalocean.models.actions.droplet.Reboot;
import org.dasein.cloud.digitalocean.models.actions.droplet.Resize;
import org.dasein.cloud.digitalocean.models.actions.droplet.Start;
import org.dasein.cloud.digitalocean.models.actions.droplet.Stop;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanAction;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanModelFactory;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class DOInstance
extends AbstractVMSupport<DigitalOcean> {
    private static final Logger logger = Logger.getLogger(DOInstance.class);
    private volatile transient DOInstanceCapabilities capabilities;

    public DOInstance(DigitalOcean provider) {
        super((CloudProvider)provider);
    }

    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"alterVirtualMachine");
        try {
            String newProductId = options.getProviderProductId();
            if (newProductId == null) {
                throw new CloudException("Product Id must not be empty");
            }
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (!this.getCapabilities().canAlter(vm.getCurrentState())) {
                throw new CloudException("Droplet is currently " + vm.getCurrentState() + ". Please power it off to run this event.");
            }
            if (vm.getProductId().compareTo(newProductId) == 0) {
                throw new CloudException("Product Id must differ from current vm product id");
            }
            Resize action = new Resize(newProductId);
            DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)action, vmId);
            VirtualMachine virtualMachine = vm = this.getVirtualMachine(vmId);
            return virtualMachine;
        }
        catch (CloudException e) {
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForAllDropletEventsToComplete(@Nonnull String instanceId, int timeout) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"listVirtualMachineStatus");
        try {
            long wait = System.currentTimeMillis() + (long)(timeout * 60 * 1000);
            boolean eventsPending = false;
            while (System.currentTimeMillis() < wait) {
                Actions actions = DigitalOceanModelFactory.getDropletEvents((DigitalOcean)this.getProvider(), instanceId);
                for (Action action : actions.getActions()) {
                    if (!"in-progress".equalsIgnoreCase(action.getStatus())) continue;
                    eventsPending = true;
                }
                if (!eventsPending) {
                    break;
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void start(@Nonnull String instanceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"startVM");
        try {
            this.waitForAllDropletEventsToComplete(instanceId, 5);
            VirtualMachine vm = this.getVirtualMachine(instanceId);
            if (vm == null) {
                throw new CloudException("No such instance: " + instanceId);
            }
            if (VmState.STOPPED.equals((Object)vm.getCurrentState())) {
                DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)new Start(), instanceId);
            }
        }
        catch (CloudException e) {
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String vmId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("DigitalOcean instances cannot be cloned.");
    }

    @Nonnull
    public DOInstanceCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new DOInstanceCapabilities((DigitalOcean)this.getProvider());
        }
        return this.capabilities;
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String instanceId) throws InternalException, CloudException {
        VirtualMachine virtualMachine;
        APITrace.begin((CloudProvider)this.getProvider(), (String)"getVirtualMachine");
        try {
            VirtualMachine server;
            Droplet d = (Droplet)DigitalOceanModelFactory.getModelById((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.DROPLET, instanceId);
            if (d != null && (server = this.toVirtualMachine(this.getContext(), d)) != null && server.getProviderVirtualMachineId().equals(instanceId)) {
                VirtualMachine virtualMachine2 = server;
                return virtualMachine2;
            }
            virtualMachine = null;
            return virtualMachine;
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 404) {
                virtualMachine = null;
                return virtualMachine;
            }
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String sizeId) throws CloudException, InternalException {
        for (Architecture a : this.getCapabilities().listSupportedArchitectures()) {
            for (VirtualMachineProduct prd : this.listProducts(a)) {
                if (!prd.getProviderProductId().equals(sizeId)) continue;
                return prd;
            }
        }
        return null;
    }

    public boolean isSubscribed() throws InternalException, CloudException {
        try {
            DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.SIZES);
            return true;
        }
        catch (CloudException e) {
            return false;
        }
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(String machineImageId, VirtualMachineProductFilterOptions options) throws InternalException, CloudException {
        Cache cache;
        Iterable products;
        String cacheName = "ALL";
        MachineImage image = ((DigitalOcean)this.getProvider()).getComputeServices().getImageSupport().getImage(machineImageId);
        if (image != null) {
            cacheName = image.getArchitecture().name();
        }
        if ((products = (cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)("products" + cacheName), VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY))).get(this.getContext())) != null && products.iterator().hasNext()) {
            return products;
        }
        ArrayList<VirtualMachineProduct> list = new ArrayList<VirtualMachineProduct>();
        Sizes availableSizes = (Sizes)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.SIZES);
        if (availableSizes != null) {
            Set<Size> sizes = availableSizes.getSizes();
            for (Size s : sizes) {
                VirtualMachineProduct product = this.toProduct(s);
                if (product == null) continue;
                list.add(product);
            }
        } else {
            logger.error((Object)("No product could be found, " + ((DigitalOcean)this.getProvider()).getCloudName() + " provided no data for their sizes API."));
            throw new CloudException("No product could be found.");
        }
        cache.put(this.getContext(), list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions cfg) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"launchVM");
        try {
            ProviderContext ctx = ((DigitalOcean)this.getProvider()).getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            MachineImage img = ((DigitalOcean)this.getProvider()).getComputeServices().getImageSupport().getMachineImage(cfg.getMachineImageId());
            if (img == null) {
                throw new InternalException("No such machine image: " + cfg.getMachineImageId());
            }
            String hostname = cfg.getHostName();
            if (hostname == null) {
                throw new InternalException("No hostname defined  as part of launch options.");
            }
            String product = cfg.getStandardProductId();
            if (product == null) {
                throw new InternalException("No product defined as part of launch options.");
            }
            String regionId = cfg.getDataCenterId();
            if (regionId == null) {
                if (ctx.getRegionId() != null) {
                    regionId = ctx.getRegionId();
                } else {
                    throw new InternalException("No region defined as part of launch options.");
                }
            }
            Droplet droplet = DigitalOceanModelFactory.createInstance((DigitalOcean)this.getProvider(), hostname, product, cfg.getMachineImageId(), regionId, cfg.getBootstrapKey(), null);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            VirtualMachine virtualMachine = this.getVirtualMachine(droplet.getId());
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"listVirtualMachineStatus");
        try {
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            Droplets droplets = (Droplets)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.DROPLETS);
            if (droplets != null) {
                List<Droplet> dropletList = droplets.getDroplets();
                for (Droplet d : dropletList) {
                    ResourceStatus status = this.toStatus(d);
                    if (status == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        return this.listVirtualMachines(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines(@Nullable VMFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"listVirtualMachines");
        try {
            ArrayList<VirtualMachine> list = new ArrayList<VirtualMachine>();
            Droplets droplets = (Droplets)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.DROPLETS);
            if (droplets != null) {
                List<Droplet> dropletList = droplets.getDroplets();
                for (Droplet d : dropletList) {
                    VirtualMachine vm = this.toVirtualMachine(this.getContext(), d);
                    if (options != null && !options.matches(vm)) continue;
                    list.add(vm);
                }
            }
            ArrayList<VirtualMachine> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String instanceId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"stopVM");
        try {
            this.waitForAllDropletEventsToComplete(instanceId, 5);
            VirtualMachine vm = this.getVirtualMachine(instanceId);
            if (vm == null) {
                throw new CloudException("No such instance: " + instanceId);
            }
            if (VmState.RUNNING.equals((Object)vm.getCurrentState())) {
                DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)new Stop(), instanceId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String instanceId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"rebootVM");
        try {
            VirtualMachine vm = this.getVirtualMachine(instanceId);
            if (vm == null) {
                throw new CloudException("No such instance: " + instanceId);
            }
            if (VmState.RUNNING.equals((Object)vm.getCurrentState())) {
                DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)new Reboot(), instanceId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String instanceId, @Nullable String explanation) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"terminateVM");
        try {
            if (this.getVirtualMachine(instanceId) == null) {
                throw new CloudException("No such instance found: " + instanceId);
            }
            DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)new Destroy(), instanceId);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Droplet instance) throws CloudException {
        if (instance == null) {
            return null;
        }
        return new ResourceStatus(instance.getId(), (Object)instance.getStatus());
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nonnull ProviderContext ctx, @Nullable Droplet instance) throws CloudException {
        if (instance == null) {
            return null;
        }
        VirtualMachine server = new VirtualMachine();
        server.setPersistent(false);
        server.setProviderOwnerId(ctx.getAccountNumber());
        server.setCurrentState(instance.getStatus());
        server.setName(instance.getName());
        if (instance.getSize() != null && instance.getSize().getSlug() != null) {
            server.setProductId(instance.getSize().getSlug());
        } else {
            server.setProductId(instance.getSizeSlug());
        }
        String description = server.getName();
        if (instance.getImage().getName() != null) {
            description = description + " (" + instance.getImage().getName() + ")";
        }
        server.setDescription(description);
        server.setProviderVirtualMachineId(instance.getId());
        server.setProviderMachineImageId(instance.getImage().getId());
        server.setProviderRegionId(ctx.getRegionId());
        server.setProviderDataCenterId(ctx.getRegionId());
        if (instance.getRegion() != null) {
            server.setProviderRegionId(instance.getRegion().getSlug());
            server.setProviderDataCenterId(instance.getRegion().getSlug());
        }
        if (instance.getName().contains("64")) {
            server.setArchitecture(Architecture.I64);
        } else if (instance.getName().contains("32") || instance.getName().contains("386")) {
            server.setArchitecture(Architecture.I32);
        } else {
            server.setArchitecture(Architecture.I64);
        }
        server.setPlatform(Platform.guess((String)instance.getName()));
        if (Platform.UNKNOWN.equals((Object)server.getPlatform())) {
            server.setPlatform(Platform.guess((String)instance.getImage().getName()));
        }
        if (Platform.UNKNOWN.equals((Object)server.getPlatform())) {
            server.setPlatform(Platform.guess((String)instance.getImage().getDistribution()));
        }
        if (instance.getNetworks() != null) {
            RawAddress address;
            ArrayList<RawAddress> privateAddresses = new ArrayList<RawAddress>();
            ArrayList<RawAddress> publicAddresses = new ArrayList<RawAddress>();
            if (instance.getNetworks().getV4() != null) {
                for (Network network : instance.getNetworks().getV4()) {
                    address = new RawAddress(network.getIpAddress(), IPVersion.IPV4);
                    if ("public".equalsIgnoreCase(network.getType())) {
                        publicAddresses.add(address);
                        continue;
                    }
                    privateAddresses.add(address);
                }
            }
            if (instance.getNetworks().getV6() != null) {
                for (Network network : instance.getNetworks().getV6()) {
                    address = new RawAddress(network.getIpAddress(), IPVersion.IPV6);
                    if ("public".equalsIgnoreCase(network.getType())) {
                        publicAddresses.add(address);
                        continue;
                    }
                    privateAddresses.add(address);
                }
            }
            server.setPrivateAddresses(privateAddresses.toArray(new RawAddress[privateAddresses.size()]));
            server.setPublicAddresses(publicAddresses.toArray(new RawAddress[publicAddresses.size()]));
        }
        return server;
    }

    @Nullable
    private VirtualMachineProduct toProduct(@Nonnull Size s) throws InternalException {
        VirtualMachineProduct prd = new VirtualMachineProduct();
        prd.setProviderProductId(s.getId());
        prd.setName(s.getSlug());
        prd.setDescription(s.getSlug());
        prd.setCpuCount(s.getCpus().intValue());
        prd.setRootVolumeSize(new Storage((Number)s.getDisk(), (StorageUnit)Storage.GIGABYTE));
        prd.setRamSize(new Storage((Number)s.getMemory(), (StorageUnit)Storage.MEGABYTE));
        prd.setStandardHourlyRate(s.getHourlyPrice().floatValue());
        return prd;
    }
}

