/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.compute;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.digitalocean.DigitalOcean;
import org.dasein.cloud.util.NamingConstraints;

public class DOInstanceCapabilities
extends AbstractCapabilities<DigitalOcean>
implements VirtualMachineCapabilities {
    private static volatile Collection<Architecture> architectures;

    public DOInstanceCapabilities(@Nonnull DigitalOcean cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.STOPPED);
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !VmState.PENDING.equals((Object)fromState) && !VmState.TERMINATED.equals((Object)fromState);
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    public int getCostFactor(@Nonnull VmState vmState) throws CloudException, InternalException {
        return 100;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "droplet";
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() {
        return NamingConstraints.getAlphaNumeric((int)1, (int)100).withNoSpaces().constrainedBy(new char[]{'.', '-'});
    }

    @Nullable
    public VisibleScope getVirtualMachineVisibleScope() {
        return null;
    }

    @Nullable
    public VisibleScope getVirtualMachineProductVisibleScope() {
        return null;
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)true, (Requirement)Requirement.NONE, (Requirement)Requirement.NONE);
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDefinedPrivateIPSupported() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        if (architectures == null) {
            architectures = Arrays.asList(Architecture.I32, Architecture.I64);
        }
        return architectures;
    }

    public boolean supportsSpotVirtualMachines() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsAlterVM() {
        return true;
    }

    public boolean supportsClone() {
        return false;
    }

    public boolean supportsPause() {
        return false;
    }

    public boolean supportsReboot() {
        return true;
    }

    public boolean supportsResume() {
        return false;
    }

    public boolean supportsStart() {
        return true;
    }

    public boolean supportsStop() {
        return true;
    }

    public boolean supportsSuspend() {
        return false;
    }

    public boolean supportsTerminate() {
        return false;
    }

    public boolean supportsUnPause() {
        return false;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform arg0) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isVMProductDCConstrained() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsCloudStoredShellKey() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsClientRequestToken() throws CloudException, InternalException {
        return false;
    }
}

