/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.compute;

import org.dasein.cloud.CloudErrorType;

public class DigitalOceanException
extends Exception {
    private String code = null;
    private CloudErrorType errorType = null;
    private String requestId = null;
    private int status = 0;

    public DigitalOceanException(int status, String requestId, String code, String message) {
        super(message);
        this.requestId = requestId;
        this.code = code;
        this.status = status;
        if (code.equals("Throttling")) {
            this.errorType = CloudErrorType.THROTTLING;
        } else if (code.equals("TooManyBuckets")) {
            this.errorType = CloudErrorType.QUOTA;
        }
    }

    public String getCode() {
        return this.code;
    }

    public CloudErrorType getErrorType() {
        return this.errorType == null ? CloudErrorType.GENERAL : this.errorType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getSummary() {
        return this.status + "/" + this.requestId + "/" + this.code + ": " + this.getMessage();
    }
}

