/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.dc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Folder;
import org.dasein.cloud.dc.Jurisdiction;
import org.dasein.cloud.dc.ResourcePool;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.digitalocean.DigitalOcean;
import org.dasein.cloud.digitalocean.NoContextException;
import org.dasein.cloud.digitalocean.dc.DODataCenterCapabilities;
import org.dasein.cloud.digitalocean.models.Region;
import org.dasein.cloud.digitalocean.models.Regions;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanModelFactory;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class DOLocation
implements DataCenterServices {
    private static final Logger logger = DigitalOcean.getLogger(DOLocation.class);
    private DigitalOcean provider;
    private volatile transient DODataCenterCapabilities capabilities;

    public DOLocation(@Nonnull DigitalOcean provider) {
        this.provider = provider;
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new DODataCenterCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String dataCenterId) throws InternalException, CloudException {
        org.dasein.cloud.dc.Region region = this.getRegion(dataCenterId);
        if (region == null) {
            return null;
        }
        return new DataCenter(dataCenterId, region.getName(), dataCenterId, region.isActive(), region.isAvailable());
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "data center";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    @Nullable
    public org.dasein.cloud.dc.Region getRegion(@Nonnull String providerRegionId) throws InternalException, CloudException {
        for (org.dasein.cloud.dc.Region r : this.listRegions()) {
            if (!providerRegionId.equals(r.getProviderRegionId())) continue;
            return r;
        }
        return null;
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String providerRegionId) throws InternalException, CloudException {
        return Arrays.asList(this.getDataCenter(providerRegionId));
    }

    public Collection<org.dasein.cloud.dc.Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listRegions");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new NoContextException();
            }
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"regions", org.dasein.cloud.dc.Region.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)10, (TimePeriodUnit)TimePeriod.HOUR));
            ArrayList<org.dasein.cloud.dc.Region> regions = (ArrayList<org.dasein.cloud.dc.Region>)cache.get(ctx);
            if (regions != null) {
                ArrayList<org.dasein.cloud.dc.Region> arrayList = regions;
                return arrayList;
            }
            regions = new ArrayList<org.dasein.cloud.dc.Region>();
            try {
                Regions availableregions = (Regions)DigitalOceanModelFactory.getModel(this.provider, org.dasein.cloud.digitalocean.models.rest.DigitalOcean.REGIONS);
                Set<Region> regionsQuery = availableregions.getRegions();
                for (Region s : regionsQuery) {
                    org.dasein.cloud.dc.Region vmp = this.toRegion(s);
                    regions.add(vmp);
                }
                cache.put(ctx, regions);
                ArrayList<org.dasein.cloud.dc.Region> arrayList = regions;
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<ResourcePool> listResourcePools(String providerDataCenterId) throws InternalException, CloudException {
        throw new CloudException(this.provider.getCloudName() + " does not support resource pools");
    }

    @Nullable
    public ResourcePool getResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        throw new CloudException(this.provider.getCloudName() + " does not support resource pools");
    }

    @Nonnull
    public Collection<StoragePool> listStoragePools() throws InternalException, CloudException {
        throw new CloudException(this.provider.getCloudName() + " does not support storage pools");
    }

    @Nonnull
    public StoragePool getStoragePool(String providerStoragePoolId) throws InternalException, CloudException {
        throw new CloudException(this.provider.getCloudName() + " does not support storage pools");
    }

    @Nonnull
    public Collection<Folder> listVMFolders() throws InternalException, CloudException {
        throw new CloudException(this.provider.getCloudName() + " does not support vm folders");
    }

    @Nonnull
    public Folder getVMFolder(String providerVMFolderId) throws InternalException, CloudException {
        throw new CloudException(this.provider.getCloudName() + " does not support vm folders");
    }

    public DataCenter toDatacenter(Region r) {
        DataCenter dc = new DataCenter();
        dc.setRegionId(r.getSlug());
        dc.setProviderDataCenterId(r.getSlug());
        dc.setName(r.getName());
        dc.setActive(r.getActive().booleanValue());
        dc.setAvailable(r.getActive().booleanValue());
        return dc;
    }

    public org.dasein.cloud.dc.Region toRegion(Region region) {
        org.dasein.cloud.dc.Region r = new org.dasein.cloud.dc.Region();
        r.setProviderRegionId(region.getSlug());
        r.setName(region.getName());
        r.setActive(region.getActive().booleanValue());
        String slugName = region.getSlug().substring(0, 2).toUpperCase();
        String jurisdiction = Jurisdiction.US.name();
        if (!slugName.equals("NYC") && !slugName.equals("SFO")) {
            if (slugName.equals("AMS") || slugName.equals("LON")) {
                jurisdiction = Jurisdiction.EU.name();
            } else if (slugName.equals("SGP")) {
                jurisdiction = Jurisdiction.SG.name();
            }
        }
        r.setJurisdiction(jurisdiction);
        r.setAvailable(region.getActive().booleanValue());
        return r;
    }
}

