/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.identity;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.digitalocean.DigitalOcean;
import org.dasein.cloud.digitalocean.identity.KeyPairCapabilities;
import org.dasein.cloud.digitalocean.models.Key;
import org.dasein.cloud.digitalocean.models.Keys;
import org.dasein.cloud.digitalocean.models.actions.sshkey.Create;
import org.dasein.cloud.digitalocean.models.actions.sshkey.Destroy;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanAction;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanModelFactory;
import org.dasein.cloud.identity.AbstractShellKeySupport;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.identity.ShellKeyCapabilities;
import org.dasein.cloud.util.APITrace;

public class Keypairs
extends AbstractShellKeySupport<DigitalOcean> {
    private static final Logger logger = DigitalOcean.getLogger(Keypairs.class);
    private volatile transient KeyPairCapabilities capabilities;

    public Keypairs(@Nonnull DigitalOcean provider) {
        super((CloudProvider)provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKeypair(@Nonnull String providerId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Keypair.deleteKeypair");
        try {
            DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)new Destroy(), providerId);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getFingerprint(@Nonnull String providerId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Keypair.getFingerprint");
        try {
            SSHKeypair kp = this.getKeypair(providerId);
            if (kp != null) {
                String string = kp.getFingerprint();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public SSHKeypair getKeypair(@Nonnull String providerId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Keypair.getKeypair");
        try {
            Key key = (Key)DigitalOceanModelFactory.getModelById((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.KEY, providerId);
            SSHKeypair sSHKeypair = this.toSSHKeypair(key);
            return sSHKeypair;
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 404) {
                SSHKeypair sSHKeypair = null;
                return sSHKeypair;
            }
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public ShellKeyCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new KeyPairCapabilities((DigitalOcean)this.getProvider());
        }
        return this.capabilities;
    }

    @Nonnull
    public SSHKeypair importKeypair(@Nonnull String name, @Nonnull String publicKey) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Keypair.importKeypair");
        try {
            String regionId = this.getContext().getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request.");
            }
            Create action = new Create(name, publicKey);
            Key k = (Key)DigitalOceanModelFactory.performAction((DigitalOcean)this.getProvider(), (DigitalOceanAction)action, org.dasein.cloud.digitalocean.models.rest.DigitalOcean.KEY);
            SSHKeypair kp = this.toSSHKeypair(k);
            if (kp != null) {
                SSHKeypair sSHKeypair = kp;
                return sSHKeypair;
            }
            throw new CloudException("Unable to import keypair " + name);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private SSHKeypair toSSHKeypair(@Nullable Key key) throws InternalException {
        if (key == null || key.getName() == null || key.getFingerprint() == null) {
            return null;
        }
        SSHKeypair kp = new SSHKeypair();
        kp.setFingerprint(key.getFingerprint());
        kp.setName(key.getName());
        kp.setPrivateKey(null);
        kp.setPublicKey(key.getPublicKey());
        kp.setProviderKeypairId(key.getId());
        kp.setProviderOwnerId(this.getContext().getAccountNumber());
        kp.setProviderRegionId(this.getContext().getRegionId());
        return kp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<SSHKeypair> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Keypair.list");
        ArrayList<SSHKeypair> keypairs = new ArrayList<SSHKeypair>();
        try {
            Keys keys = (Keys)DigitalOceanModelFactory.getModel((DigitalOcean)this.getProvider(), org.dasein.cloud.digitalocean.models.rest.DigitalOcean.KEYS);
            if (keys == null) {
                Iterable<SSHKeypair> iterable = null;
                return iterable;
            }
            for (Key k : keys.getKeys()) {
                SSHKeypair kp = this.toSSHKeypair(k);
                if (kp == null) continue;
                keypairs.add(kp);
            }
        }
        finally {
            APITrace.end();
        }
        return keypairs;
    }

    @Nonnull
    public SSHKeypair createKeypair(@Nonnull String keyName) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Provider " + ((DigitalOcean)this.getProvider()).getCloudName() + " does not support key generation, it only supports key import");
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        try {
            this.list();
            return true;
        }
        catch (CloudException e) {
            return false;
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction arg0) {
        return new String[0];
    }
}

