/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.models.actions.droplet;

import java.util.ArrayList;
import java.util.List;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanPostAction;
import org.json.JSONException;
import org.json.JSONObject;

public class Create
extends DigitalOceanPostAction {
    String name = "";
    String size = null;
    String image = null;
    String region = null;
    boolean ipv6 = false;
    List<String> ssh_key_ids = new ArrayList<String>();
    boolean private_networking = true;
    boolean backups_enabled = false;

    public Create(String name, String size, String image_or_imageId, String region_slug_or_id) {
        this.name = name;
        this.image = image_or_imageId;
        this.size = size;
        this.region = region_slug_or_id;
    }

    public Create(String dropletName, Integer sizeId, int theImageId, Long regionId) {
        this.name = dropletName;
        this.image = String.valueOf(theImageId);
        this.size = String.valueOf(sizeId);
        this.region = String.valueOf(regionId);
    }

    public void setSshKeyIds(List<String> keyIds) {
        this.ssh_key_ids.clear();
        this.ssh_key_ids.addAll(keyIds);
    }

    public void setPrivateNetworking(boolean b) {
        this.private_networking = b;
    }

    public boolean getPrivateNetworking() {
        return this.private_networking;
    }

    public void setBackups(boolean enabled) {
        this.backups_enabled = enabled;
    }

    public boolean getBackupsEnabled() {
        return this.backups_enabled;
    }

    @Override
    public JSONObject getParameters() throws CloudException, JSONException {
        JSONObject postData = new JSONObject();
        if (this.name == null) {
            throw new CloudException("Missing required parameter 'name'");
        }
        postData.put("name", (Object)this.name);
        if (this.size == null) {
            throw new CloudException("Missing required parameter 'size' for 'id' or 'slug' value");
        }
        postData.put("size", (Object)this.size);
        if (this.image == null) {
            throw new CloudException("Missing required parameter image for 'id' or 'slug' value");
        }
        postData.put("image", (Object)this.image);
        if (this.region == null) {
            throw new CloudException("Missing required parameter 'region' for 'id' or 'slug' value");
        }
        postData.put("region", (Object)this.region);
        if (this.ssh_key_ids != null && !this.ssh_key_ids.isEmpty()) {
            postData.put("ssh_keys", this.ssh_key_ids);
        }
        postData.put("private_networking", this.private_networking);
        postData.put("backups", this.backups_enabled);
        postData.put("ipv6", this.ipv6);
        return postData;
    }

    @Override
    public String toString() {
        return "v2/droplets";
    }
}

