/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.models.rest;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.digitalocean.models.Action;
import org.dasein.cloud.digitalocean.models.Actions;
import org.dasein.cloud.digitalocean.models.Droplet;
import org.dasein.cloud.digitalocean.models.Droplets;
import org.dasein.cloud.digitalocean.models.IDigitalOcean;
import org.dasein.cloud.digitalocean.models.Image;
import org.dasein.cloud.digitalocean.models.Images;
import org.dasein.cloud.digitalocean.models.Key;
import org.dasein.cloud.digitalocean.models.Keys;
import org.dasein.cloud.digitalocean.models.Region;
import org.dasein.cloud.digitalocean.models.Regions;
import org.dasein.cloud.digitalocean.models.Size;
import org.dasein.cloud.digitalocean.models.Sizes;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanRestModel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public enum DigitalOcean implements IDigitalOcean
{
    REGIONS,
    REGION,
    DROPLETS,
    DROPLET,
    DROPLET_ACTIONS,
    SIZES,
    SIZE,
    IMAGES_PUBLIC,
    IMAGES,
    IMAGE,
    IMAGE_ACTIONS,
    ACTIONS,
    ACTION,
    KEYS,
    KEY;

    static Gson gson;

    @Override
    public String toString() {
        switch (this) {
            case REGIONS: {
                return "v2/regions";
            }
            case REGION: {
                return "v2/regions/%s";
            }
            case DROPLETS: {
                return "v2/droplets";
            }
            case DROPLET: {
                return "v2/droplets/%s";
            }
            case DROPLET_ACTIONS: {
                return DROPLET + "/actions";
            }
            case IMAGES_PUBLIC: {
                return "v2/images/?public=true";
            }
            case IMAGES: {
                return "v2/images/?private=true";
            }
            case IMAGE: {
                return "v2/images/%s";
            }
            case IMAGE_ACTIONS: {
                return IMAGE + "/actions";
            }
            case SIZES: {
                return "v2/sizes";
            }
            case SIZE: {
                return "v2/size/%s";
            }
            case KEYS: {
                return "v2/account/keys";
            }
            case KEY: {
                return "v2/account/keys/%s";
            }
            case ACTIONS: {
                return "v2/actions";
            }
            case ACTION: {
                return "v2/actions/%s";
            }
        }
        throw new IllegalArgumentException("DigitalOcean endpoint not configured.");
    }

    @Override
    public DigitalOceanRestModel fromJson(JSONObject jso) throws JsonSyntaxException, JSONException, CloudException {
        if (jso.has("id")) {
            throw new CloudException(jso.getString("message"));
        }
        switch (this) {
            case DROPLET: {
                return (DigitalOceanRestModel)gson.fromJson(jso.getJSONObject("droplet").toString(), Droplet.class);
            }
            case DROPLETS: {
                JSONArray jsArray = jso.getJSONArray("droplets");
                Droplets droplets = new Droplets();
                for (int i = 0; i < jsArray.length(); ++i) {
                    Object u = gson.fromJson(jsArray.getJSONObject(i).toString(), Droplet.class);
                    droplets.addDroplet((Droplet)u);
                }
                return droplets;
            }
            case SIZE: {
                return (DigitalOceanRestModel)gson.fromJson(jso.getJSONObject("size").toString(), Size.class);
            }
            case SIZES: {
                JSONArray jsArray = jso.getJSONArray("sizes");
                Sizes sizes = new Sizes();
                for (int i = 0; i < jsArray.length(); ++i) {
                    Object u = gson.fromJson(jsArray.getJSONObject(i).toString(), Size.class);
                    sizes.addSize((Size)u);
                }
                return sizes;
            }
            case REGIONS: {
                JSONArray jsArray = jso.getJSONArray("regions");
                Regions regions = new Regions();
                for (int i = 0; i < jsArray.length(); ++i) {
                    try {
                        regions.addRegion((Region)gson.fromJson(jsArray.getJSONObject(i).toString(), Region.class));
                        continue;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                return regions;
            }
            case REGION: {
                return (DigitalOceanRestModel)gson.fromJson(jso.getJSONObject("region").toString(), Region.class);
            }
            case DROPLET_ACTIONS: 
            case IMAGE_ACTIONS: 
            case ACTIONS: {
                JSONArray jsArray = jso.getJSONArray("actions");
                Actions actions = new Actions();
                for (int i = 0; i < jsArray.length(); ++i) {
                    Object u = gson.fromJson(jsArray.getJSONObject(i).toString(), Action.class);
                    actions.addAction((Action)u);
                }
                return actions;
            }
            case ACTION: {
                return (DigitalOceanRestModel)gson.fromJson(jso.getJSONObject("action").toString(), Action.class);
            }
            case KEY: {
                return (DigitalOceanRestModel)gson.fromJson(jso.getJSONObject("ssh_key").toString(), Key.class);
            }
            case KEYS: {
                JSONArray jsArray = jso.getJSONArray("ssh_keys");
                Keys keys = new Keys();
                for (int i = 0; i < jsArray.length(); ++i) {
                    Object u = gson.fromJson(jsArray.getJSONObject(i).toString(), Key.class);
                    keys.addKey((Key)u);
                }
                return keys;
            }
            case IMAGE: {
                return (DigitalOceanRestModel)gson.fromJson(jso.getJSONObject("image").toString(), Image.class);
            }
            case IMAGES_PUBLIC: 
            case IMAGES: {
                JSONArray jsArray = jso.getJSONArray("images");
                Images images = new Images();
                for (int i = 0; i < jsArray.length(); ++i) {
                    Object u = gson.fromJson(jsArray.getJSONObject(i).toString(), Image.class);
                    images.addImage((Image)u);
                }
                JSONObject meta = jso.getJSONObject("meta");
                if (meta.has("total")) {
                    images.setTotal(meta.getInt("total"));
                }
                return images;
            }
        }
        throw new IllegalArgumentException("DigitalOcean JSON to Object not implemented");
    }

    static {
        gson = new Gson();
    }
}

