/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.digitalocean.models.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.digitalocean.models.Action;
import org.dasein.cloud.digitalocean.models.Actions;
import org.dasein.cloud.digitalocean.models.Droplet;
import org.dasein.cloud.digitalocean.models.IDigitalOcean;
import org.dasein.cloud.digitalocean.models.actions.droplet.Create;
import org.dasein.cloud.digitalocean.models.rest.DigitalOcean;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanAction;
import org.dasein.cloud.digitalocean.models.rest.DigitalOceanRestModel;
import org.dasein.cloud.digitalocean.models.rest.RESTMethod;
import org.json.JSONException;
import org.json.JSONObject;

public class DigitalOceanModelFactory {
    private static final Logger wire = org.dasein.cloud.digitalocean.DigitalOcean.getWireLogger(DigitalOceanModelFactory.class);
    private static final Logger logger = org.dasein.cloud.digitalocean.DigitalOcean.getLogger(DigitalOceanModelFactory.class);

    private static String performHttpRequest(org.dasein.cloud.digitalocean.DigitalOcean provider, RESTMethod method, String token, String endpoint) throws CloudException, InternalException {
        return DigitalOceanModelFactory.performHttpRequest(provider, method, token, endpoint, null);
    }

    private static String performHttpRequest(org.dasein.cloud.digitalocean.DigitalOcean provider, RESTMethod method, String token, String endpoint, DigitalOceanAction action) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".performHttpRequest(" + (Object)((Object)method) + "," + token + "," + endpoint + ")"));
            logger.trace((Object)("CALLING - " + (Object)((Object)method) + " " + endpoint));
        }
        String responseBody = null;
        try {
            HttpResponse response = DigitalOceanModelFactory.sendRequest(provider, method, token, endpoint, action);
            if (response.getEntity() != null) {
                responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)responseBody);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("RECEIVED - [" + response.getStatusLine().getStatusCode() + "] " + responseBody));
            }
            if (response.getStatusLine().getStatusCode() >= 300) {
                JSONObject ob = new JSONObject(responseBody);
                String message = null;
                String code = null;
                if (ob != null) {
                    code = ob.getString("id");
                    message = ob.getString("message");
                }
                logger.error((Object)("Status:" + response.getStatusLine().getStatusCode() + " - " + responseBody));
                throw new CloudException(CloudErrorType.GENERAL, response.getStatusLine().getStatusCode(), code, message);
            }
            String ob = responseBody;
            return ob;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".performHttpRequest(" + (Object)((Object)method) + "," + token + "," + endpoint + ")"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"--------------------------------------------------------------------------------------");
                wire.debug((Object)"");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpResponse sendRequest(org.dasein.cloud.digitalocean.DigitalOcean provider, RESTMethod method, String token, String strUrl, DigitalOceanAction action) throws CloudException, InternalException {
        HttpGet req = null;
        if (method == RESTMethod.GET) {
            req = new HttpGet(strUrl);
        } else if (method == RESTMethod.POST) {
            req = new HttpPost(strUrl);
        } else if (method == RESTMethod.PUT) {
            req = new HttpPut(strUrl);
        } else if (method == RESTMethod.DELETE) {
            req = new HttpDelete(strUrl);
        } else if (method == RESTMethod.HEAD) {
            req = new HttpHead(strUrl);
        }
        try {
            JSONObject jsonToPost;
            req.setHeader("Authorization", "Bearer " + token);
            req.setHeader("Accept", "application/json");
            req.setHeader("Content-Type", "application/json;charset=UTF-8");
            StringEntity requestEntity = null;
            if (req instanceof HttpEntityEnclosingRequestBase && action != null && (jsonToPost = action.getParameters()) != null) {
                requestEntity = new StringEntity(jsonToPost.toString(), ContentType.APPLICATION_JSON);
                ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)requestEntity);
            }
            HttpClient httpClient = provider.getClient();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)"--------------------------------------------------------------------------------------");
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)req.getRequestLine().toString());
                for (Header header : req.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                if (requestEntity != null) {
                    try {
                        wire.debug((Object)EntityUtils.toString((HttpEntity)requestEntity));
                        wire.debug((Object)"");
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            HttpResponse response = null;
            for (int retryCount = 0; retryCount < 6; ++retryCount) {
                response = httpClient.execute((HttpUriRequest)req);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                }
                if (method != RESTMethod.DELETE || response.getStatusLine().getStatusCode() == 204) break;
                Thread.sleep(5000L);
            }
            if (method != RESTMethod.DELETE) return response;
            if (response.getStatusLine().getStatusCode() == 204) return response;
            throw new CloudException("Delete method returned unexpected code, despite retrying.");
        }
        catch (JSONException e) {
            throw new CloudException("Problem sending request.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new CloudException("Problem sending request.", (Throwable)e);
        }
        catch (ClientProtocolException e) {
            throw new CloudException("Problem sending request.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException("Problem sending request.", (Throwable)e);
        }
    }

    public static DigitalOceanRestModel getModel(org.dasein.cloud.digitalocean.DigitalOcean provider, DigitalOcean model) throws CloudException, InternalException {
        return DigitalOceanModelFactory.getModel(provider, model, 0);
    }

    public static DigitalOceanRestModel getModel(org.dasein.cloud.digitalocean.DigitalOcean provider, DigitalOcean model, int page) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".getModel(" + (Object)((Object)provider) + "," + model + ")"));
        }
        String token = (String)provider.getContext().getConfigurationValue("token");
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(DigitalOceanModelFactory.getApiUrl(provider)).append(DigitalOceanModelFactory.getEndpoint(model));
            if (page > 0) {
                if (urlBuilder.indexOf("?") > 0) {
                    urlBuilder.append('&');
                } else {
                    urlBuilder.append('?');
                }
                urlBuilder.append("page=").append(page);
            }
            String responseText = DigitalOceanModelFactory.performHttpRequest(provider, RESTMethod.GET, token, urlBuilder.toString());
            JSONObject jso = new JSONObject(responseText);
            DigitalOceanRestModel digitalOceanRestModel = model.fromJson(jso);
            return digitalOceanRestModel;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".getModel(" + (Object)((Object)provider) + "," + model + ")"));
            }
        }
    }

    public static DigitalOceanRestModel getModelById(org.dasein.cloud.digitalocean.DigitalOcean provider, DigitalOcean model, String id) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".getModel(" + (Object)((Object)provider) + "," + model + "," + id + ")"));
        }
        String token = (String)provider.getContext().getConfigurationValue("token");
        try {
            String s = DigitalOceanModelFactory.performHttpRequest(provider, RESTMethod.GET, token, DigitalOceanModelFactory.getApiUrl(provider) + DigitalOceanModelFactory.getEndpoint(model, id));
            JSONObject jso = new JSONObject(s);
            DigitalOceanRestModel digitalOceanRestModel = model.fromJson(jso);
            return digitalOceanRestModel;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".getModel(" + (Object)((Object)provider) + "," + model + ")"));
            }
        }
    }

    private static String getEndpoint(IDigitalOcean d) {
        return ((Object)d).toString();
    }

    private static String getEndpoint(IDigitalOcean d, String id) {
        if (id == null) {
            return DigitalOceanModelFactory.getEndpoint(d);
        }
        return String.format(((Object)d).toString(), id);
    }

    private static String getApiUrl(org.dasein.cloud.digitalocean.DigitalOcean provider) {
        String url = provider.getContext().getCloud().getEndpoint();
        if (url == null) {
            url = "https://api.digitalocean.com/";
        } else if (url.endsWith("//")) {
            url = url.substring(0, url.length() - 1);
        } else if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static Action performAction(org.dasein.cloud.digitalocean.DigitalOcean provider, DigitalOceanAction doa, String id) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".destroyDroplet(" + (Object)((Object)provider) + "," + id + ")"));
        }
        String token = (String)provider.getContext().getConfigurationValue("token");
        String s = DigitalOceanModelFactory.performHttpRequest(provider, doa.getRestMethod(), token, DigitalOceanModelFactory.getApiUrl(provider) + DigitalOceanModelFactory.getEndpoint(doa, id), doa);
        try {
            if (doa.getRestMethod() == RESTMethod.DELETE) {
                Action action = null;
                return action;
            }
            JSONObject jso = new JSONObject(s);
            Action result = (Action)DigitalOcean.ACTION.fromJson(jso);
            if (!result.isError()) {
                Action action = (Action)DigitalOcean.ACTION.fromJson(jso);
                return action;
            }
            try {
                throw new CloudException("An error occured while performing " + doa + " with parameters : " + doa.getParameters());
            }
            catch (JSONException e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".destroyDroplet(" + (Object)((Object)provider) + "," + id + ")"));
            }
        }
    }

    public static DigitalOceanRestModel performAction(@Nonnull org.dasein.cloud.digitalocean.DigitalOcean provider, DigitalOceanAction doa, IDigitalOcean returnObject) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".performAction(" + provider.getCloudName() + ", " + returnObject + ")"));
        }
        String token = (String)provider.getContext().getConfigurationValue("token");
        String s = DigitalOceanModelFactory.performHttpRequest(provider, doa.getRestMethod(), token, DigitalOceanModelFactory.getApiUrl(provider) + DigitalOceanModelFactory.getEndpoint(doa), doa);
        try {
            JSONObject jso = new JSONObject(s);
            DigitalOceanRestModel digitalOceanRestModel = returnObject.fromJson(jso);
            return digitalOceanRestModel;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".performAction(" + provider.getCloudName() + "," + returnObject + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkAction(@Nonnull org.dasein.cloud.digitalocean.DigitalOcean provider, String actionUrl) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".checkAction(" + provider.getCloudName() + ")"));
        }
        String token = (String)provider.getContext().getConfigurationValue("token");
        try {
            int n = DigitalOceanModelFactory.sendRequest(provider, RESTMethod.HEAD, token, DigitalOceanModelFactory.getApiUrl(provider) + "v2/" + actionUrl, null).getStatusLine().getStatusCode();
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".checkAction(" + provider.getCloudName() + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Droplet createInstance(org.dasein.cloud.digitalocean.DigitalOcean provider, String dropletName, String sizeId, String theImageId, String regionId, String bootstrapKey, Map<String, Object> extraParameters) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + DigitalOceanModelFactory.class.getName() + ".createInstance(" + dropletName + "," + sizeId + "," + theImageId + "," + regionId + "," + extraParameters + ")"));
        }
        try {
            Create action = new Create(dropletName, sizeId, theImageId, regionId);
            ArrayList<String> ssh_key_ids = new ArrayList<String>();
            if (extraParameters != null) {
                if (extraParameters.containsKey("backup_enabled")) {
                    try {
                        action.setBackups((Boolean)extraParameters.get("backup_enabled"));
                    }
                    catch (Exception ee) {
                        throw new CloudException("Parameter 'backup_enabled' must be of type Boolean");
                    }
                }
                if (extraParameters.containsKey("private_networking")) {
                    try {
                        action.setPrivateNetworking((Boolean)extraParameters.get("private_networking"));
                    }
                    catch (Exception ee) {
                        throw new CloudException("Parameter 'private_networking' must be of type Boolean");
                    }
                }
            }
            if (bootstrapKey != null) {
                ssh_key_ids.add(bootstrapKey);
            }
            action.setSshKeyIds(ssh_key_ids);
            Droplet droplet = (Droplet)DigitalOceanModelFactory.performAction(provider, (DigitalOceanAction)action, DigitalOcean.DROPLET);
            return droplet;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + DigitalOceanModelFactory.class.getName() + ".createInstance(" + dropletName + "," + sizeId + "," + theImageId + "," + regionId + "," + extraParameters + ")"));
            }
        }
    }

    public static Droplet getDropletByInstance(org.dasein.cloud.digitalocean.DigitalOcean provider, String dropletInstanceId) throws CloudException, InternalException {
        return (Droplet)DigitalOceanModelFactory.getModelById(provider, DigitalOcean.DROPLET, dropletInstanceId);
    }

    public static Action getEventById(org.dasein.cloud.digitalocean.DigitalOcean provider, String id) throws CloudException, InternalException {
        return (Action)DigitalOceanModelFactory.getModelById(provider, DigitalOcean.ACTION, id);
    }

    public static Actions getDropletEvents(org.dasein.cloud.digitalocean.DigitalOcean provider, String dropletId) throws CloudException, InternalException {
        return (Actions)DigitalOceanModelFactory.getModelById(provider, DigitalOcean.DROPLET_ACTIONS, dropletId);
    }
}

