/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.ci;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.InstanceProperties;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstanceTemplateList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ci.AbstractTopologySupport;
import org.dasein.cloud.ci.GCETopologyCapabilities;
import org.dasein.cloud.ci.Topology;
import org.dasein.cloud.ci.TopologyFilterOptions;
import org.dasein.cloud.ci.TopologyProvisionOptions;
import org.dasein.cloud.ci.TopologyState;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.compute.server.ServerSupport;
import org.dasein.util.uom.storage.Storage;

public class GoogleTopologySupport
extends AbstractTopologySupport<Google> {
    private Compute.InstanceTemplates instanceTemplates = null;
    private volatile transient GCETopologyCapabilities capabilities;

    public GoogleTopologySupport(Google provider) {
        super((CloudProvider)provider);
        try {
            this.instanceTemplates = ((Google)this.getProvider()).getGoogleCompute().instanceTemplates();
        }
        catch (CloudException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
    }

    public String getProviderTermForTopology(Locale locale) {
        return "Instance Template";
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    public Iterable<Topology> listTopologies(TopologyFilterOptions options) throws CloudException, InternalException {
        ArrayList<Topology> topologies = new ArrayList<Topology>();
        try {
            InstanceTemplateList templateList = (InstanceTemplateList)this.instanceTemplates.list(this.getContext().getAccountNumber()).execute();
            for (InstanceTemplate template : templateList.getItems()) {
                InstanceProperties templateProperties = template.getProperties();
                Topology.VMDevice vmDevices = null;
                String machineType = templateProperties.getMachineType();
                ServerSupport server = new ServerSupport((Google)this.getProvider());
                Iterable<VirtualMachineProduct> vmProducts = server.listProducts(Architecture.I64, "us-central1-f");
                for (VirtualMachineProduct vmProduct : vmProducts) {
                    if (!vmProduct.getName().equals(machineType)) continue;
                    vmDevices = Topology.VMDevice.getInstance((String)machineType, (String)machineType, (int)vmProduct.getCpuCount(), (Storage)vmProduct.getRamSize(), (String[])new String[]{null});
                }
                List networkInterfaces = templateProperties.getNetworkInterfaces();
                String name = null;
                String deviceId = null;
                for (NetworkInterface networkInterface : networkInterfaces) {
                    deviceId = networkInterface.getNetwork();
                    name = deviceId.replaceAll(".*/", "");
                }
                Topology topology = Topology.getInstance((String)this.getContext().getAccountNumber(), null, (String)template.getName(), (TopologyState)TopologyState.ACTIVE, (String)template.getName(), (String)template.getDescription());
                if (null != vmDevices) {
                    topology = topology.withVirtualMachines(new Topology.VMDevice[]{vmDevices});
                }
                if (null != name && null != deviceId) {
                    topology = topology.withVLANs(new Topology.VLANDevice[]{Topology.VLANDevice.getInstance((String)deviceId, (String)name)});
                }
                if (null != options && !options.matches(topology)) continue;
                topologies.add(topology);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return topologies;
    }

    public boolean createTopology(@Nonnull TopologyProvisionOptions withTopologyOptions) throws CloudException, InternalException {
        InstanceTemplate newInstanceTemplate = new InstanceTemplate();
        newInstanceTemplate.setName(this.getCapabilities().getTopologyNamingConstraints().convertToValidName(withTopologyOptions.getProductName(), Locale.US));
        newInstanceTemplate.setDescription(withTopologyOptions.getProductDescription());
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setCanIpForward(Boolean.valueOf(withTopologyOptions.getCanIpForward()));
        instanceProperties.setDescription(withTopologyOptions.getProductDescription());
        instanceProperties.setMachineType(withTopologyOptions.getMachineType());
        List disks = withTopologyOptions.getDiskArray();
        ArrayList<AttachedDisk> attachedDisks = new ArrayList<AttachedDisk>();
        for (TopologyProvisionOptions.Disk topologyDisk : disks) {
            AttachedDisk disk = new AttachedDisk();
            disk.setAutoDelete(Boolean.valueOf(topologyDisk.getAutoDelete()));
            disk.setBoot(Boolean.valueOf(topologyDisk.getBootable()));
            disk.setDeviceName(withTopologyOptions.getProductName());
            AttachedDiskInitializeParams attachedDiskInitializeParams = new AttachedDiskInitializeParams();
            attachedDiskInitializeParams.setSourceImage(topologyDisk.getDeviceSource());
            attachedDiskInitializeParams.setDiskType(topologyDisk.getDeviceType().toString());
            disk.setInitializeParams(attachedDiskInitializeParams);
            attachedDisks.add(disk);
        }
        instanceProperties.setDisks(attachedDisks);
        List topologyNetworksList = withTopologyOptions.getNetworkArray();
        ArrayList<NetworkInterface> networks = new ArrayList<NetworkInterface>();
        for (TopologyProvisionOptions.Network topologyNetwork : topologyNetworksList) {
            NetworkInterface networkInterface = new NetworkInterface();
            networkInterface.setName(topologyNetwork.getNetworkName());
            networkInterface.setNetwork(topologyNetwork.getNetworkSelfUrl());
            List topologyNetworksAccessConfig = topologyNetwork.getAccessConfig();
            ArrayList<AccessConfig> accessConfig = new ArrayList<AccessConfig>();
            for (TopologyProvisionOptions.AccessConfig topologyAccessConfig : topologyNetworksAccessConfig) {
                AccessConfig cfg = new AccessConfig();
                cfg.setName(topologyAccessConfig.getName());
                cfg.setKind(topologyAccessConfig.getKind());
                cfg.setType(topologyAccessConfig.getType());
                accessConfig.add(cfg);
            }
            networkInterface.setAccessConfigs(accessConfig);
            networks.add(networkInterface);
        }
        instanceProperties.setNetworkInterfaces(networks);
        Tags tags = new Tags();
        tags.setItems(withTopologyOptions.getTags());
        instanceProperties.setTags(tags);
        String[] sshKeys = withTopologyOptions.getSshKeys();
        Metadata metadata = new Metadata();
        ArrayList<Metadata.Items> metadataItems = new ArrayList<Metadata.Items>();
        for (String sshKey : sshKeys) {
            Metadata.Items item = new Metadata.Items();
            item.setKey("sshKeys");
            item.setValue(sshKey);
            metadataItems.add(item);
        }
        Map metaDataItems = withTopologyOptions.getMetadata();
        for (String itemKey : metaDataItems.keySet()) {
            Metadata.Items item = new Metadata.Items();
            item.setKey(itemKey);
            item.setValue((String)metaDataItems.get(itemKey));
            metadataItems.add(item);
        }
        metadata.setItems(metadataItems);
        instanceProperties.setMetadata(metadata);
        Scheduling scheduling = new Scheduling();
        scheduling.setAutomaticRestart(Boolean.valueOf(withTopologyOptions.getAutomaticRestart()));
        scheduling.setOnHostMaintenance(withTopologyOptions.getMaintenenceAction().toString());
        instanceProperties.setScheduling(scheduling);
        newInstanceTemplate.setProperties(instanceProperties);
        try {
            Operation job = (Operation)this.instanceTemplates.insert(this.getContext().getAccountNumber(), newInstanceTemplate).execute();
            GoogleMethod method = new GoogleMethod((Google)this.getProvider());
            method.getOperationComplete(this.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "");
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException(ex.getMessage());
        }
        return true;
    }

    public boolean removeTopologies(@Nonnull String[] topologyIds) throws CloudException, InternalException {
        for (String topologyName : topologyIds) {
            try {
                Operation job = (Operation)this.instanceTemplates.delete(this.getContext().getAccountNumber(), topologyName).execute();
                GoogleMethod method = new GoogleMethod((Google)this.getProvider());
                method.getOperationComplete(this.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "");
            }
            catch (IOException ex) {
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException(ex.getMessage());
            }
        }
        return true;
    }

    @Nonnull
    public GCETopologyCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new GCETopologyCapabilities((Google)this.getProvider());
        }
        return this.capabilities;
    }
}

