/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.IOException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.RequestTrackingStrategy;

public class CustomHttpRequestInitializer
implements HttpRequestInitializer {
    private InheritableThreadLocal<ProviderContext> context = new InheritableThreadLocal();
    private InheritableThreadLocal<GoogleCredential> credentials = new InheritableThreadLocal();

    CustomHttpRequestInitializer() {
    }

    public void initialize(HttpRequest request) throws IOException {
        HttpHeaders headers = request.getHeaders();
        ((GoogleCredential)this.credentials.get()).initialize(request);
        RequestTrackingStrategy strategy = ((ProviderContext)this.context.get()).getRequestTrackingStrategy();
        if (strategy != null && strategy.getSendAsHeader()) {
            headers.put(strategy.getHeaderName(), (Object)strategy.getRequestId());
            request.setHeaders(headers);
        }
    }

    public void setStackedRequestInitializer(ProviderContext ctx, GoogleCredential cred) {
        this.context.set(ctx);
        this.credentials.set(cred);
    }
}

