/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Folder;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.dc.ResourcePool;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleDataCenterCapabilities;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.NoContextException;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class DataCenters
implements DataCenterServices {
    private static final Logger logger = Google.getLogger(DataCenters.class);
    private static HashMap<String, String> zone2Region = new HashMap();
    private Google provider;
    private volatile transient GoogleDataCenterCapabilities capabilities;

    DataCenters(@Nonnull Google provider) {
        this.provider = provider;
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new GoogleDataCenterCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String dataCenterId) throws InternalException, CloudException {
        Compute gce = this.provider.getGoogleCompute();
        try {
            Zone dataCenter = (Zone)gce.zones().get(this.provider.getContext().getAccountNumber(), dataCenterId).execute();
            return this.toDataCenter(dataCenter);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred retrieving the dataCenter: " + dataCenterId + ": " + ex.getMessage());
        }
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "zone";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    @Nullable
    public Region getRegion(@Nonnull String providerRegionId) throws InternalException, CloudException {
        Compute gce = this.provider.getGoogleCompute();
        try {
            com.google.api.services.compute.model.Region r = (com.google.api.services.compute.model.Region)gce.regions().get(this.provider.getContext().getAccountNumber(), providerRegionId).execute();
            return this.toRegion(r);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred retrieving the region: " + providerRegionId + ": " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String providerRegionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listDataCenters");
        try {
            ArrayList<DataCenter> dataCenters;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new NoContextException();
            }
            Cache cache = null;
            String originalRegionId = ctx.getRegionId();
            if (providerRegionId.equals(originalRegionId) && (dataCenters = (Collection)(cache = Cache.getInstance((CloudProvider)this.provider, (String)"datacenters", DataCenter.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)10, (TimePeriodUnit)TimePeriod.HOUR))).get(ctx)) != null) {
                ArrayList<DataCenter> arrayList = dataCenters;
                return arrayList;
            }
            dataCenters = new ArrayList();
            Compute gce = this.provider.getGoogleCompute();
            Object gceDataCenters = null;
            try {
                ZoneList zoneList = (ZoneList)gce.zones().list(ctx.getAccountNumber()).execute();
                if (null != zoneList) {
                    List dataCenterList = zoneList.getItems();
                    for (int i = 0; i < dataCenterList.size(); ++i) {
                        Zone current = (Zone)dataCenterList.get(i);
                        String region = current.getRegion().substring(current.getRegion().lastIndexOf("/") + 1);
                        if (region.equals(providerRegionId)) {
                            dataCenters.add(this.toDataCenter(current, null != current.getDeprecated()));
                        }
                        zone2Region.put(current.getName(), region);
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)("Failed to listDataCenters: " + ex.getMessage()));
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException(CloudErrorType.COMMUNICATION, gceDataCenters.getLastStatusCode(), gceDataCenters.getLastStatusMessage(), "An error occurred while listing DataCenters");
            }
            if (cache != null) {
                cache.put(ctx, dataCenters);
            }
            ArrayList<DataCenter> arrayList = dataCenters;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listRegions");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new NoContextException();
            }
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"regions", Region.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)10, (TimePeriodUnit)TimePeriod.HOUR));
            ArrayList<Region> regions = (ArrayList<Region>)cache.get(ctx);
            if (regions != null) {
                ArrayList<Region> arrayList = regions;
                return arrayList;
            }
            regions = new ArrayList<Region>();
            Compute gce = this.provider.getGoogleCompute();
            Compute.Regions.List gceRegions = null;
            try {
                gceRegions = gce.regions().list(ctx.getAccountNumber());
                RegionList regionList = (RegionList)gceRegions.execute();
                if (null != regionList && null != regionList.getItems()) {
                    List regionListItems = regionList.getItems();
                    for (int i = 0; i < regionListItems.size(); ++i) {
                        com.google.api.services.compute.model.Region current = (com.google.api.services.compute.model.Region)regionListItems.get(i);
                        regions.add(this.toRegion(current));
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)("Failed to listRegions: " + ex.getMessage()));
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException(CloudErrorType.COMMUNICATION, gceRegions.getLastStatusCode(), gceRegions.getLastStatusMessage(), "An error occurred while listing regions");
            }
            cache.put(ctx, regions);
            ArrayList<Region> arrayList = regions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getRegionFromZone(@Nonnull String zoneName) throws CloudException, InternalException {
        if (zoneName.contains("zones/")) {
            zoneName = zoneName.replace("zones/", "");
        }
        if (zone2Region == null || !zone2Region.containsKey(zoneName)) {
            for (Region r : this.listRegions()) {
                this.listDataCenters(r.getProviderRegionId());
            }
        }
        return zone2Region.get(zoneName);
    }

    private Region toRegion(com.google.api.services.compute.model.Region googleRegion) {
        Region region = new Region();
        region.setName(googleRegion.getName());
        region.setProviderRegionId(googleRegion.getName());
        region.setActive(true);
        region.setAvailable(true);
        if (googleRegion.getName().startsWith("eu")) {
            region.setJurisdiction("EU");
        } else {
            region.setJurisdiction("US");
        }
        return region;
    }

    private DataCenter toDataCenter(Zone zone) {
        return this.toDataCenter(zone, false);
    }

    private DataCenter toDataCenter(Zone zone, Boolean deprecated) {
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        if (deprecated.booleanValue()) {
            dc.setAvailable(false);
        } else if (zone.getStatus().equals("UP")) {
            dc.setAvailable(true);
        } else {
            dc.setAvailable(false);
        }
        dc.setProviderDataCenterId(zone.getName());
        dc.setRegionId(zone.getRegion().substring(zone.getRegion().lastIndexOf("/") + 1));
        dc.setName(zone.getName());
        return dc;
    }

    public Collection<ResourcePool> listResourcePools(String providerDataCenterId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    public ResourcePool getResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        return null;
    }

    public Collection<StoragePool> listStoragePools() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public StoragePool getStoragePool(String providerStoragePoolId) throws InternalException, CloudException {
        return null;
    }

    public Collection<Folder> listVMFolders() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    public Folder getVMFolder(String providerVMFolderId) throws InternalException, CloudException {
        return null;
    }
}

