/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.ComputeScopes;
import com.google.api.services.replicapool.Replicapool;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.api.services.storage.Storage;
import java.io.ByteArrayInputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ci.CIServices;
import org.dasein.cloud.ci.GoogleCIServices;
import org.dasein.cloud.google.CustomHttpRequestInitializer;
import org.dasein.cloud.google.DataCenters;
import org.dasein.cloud.google.LogHandler;
import org.dasein.cloud.google.compute.GoogleCompute;
import org.dasein.cloud.google.network.GoogleNetwork;
import org.dasein.cloud.google.platform.GooglePlatform;
import org.dasein.cloud.google.storage.GoogleDrive;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class Google
extends AbstractCloud {
    private static final Logger logger = Google.getLogger(Google.class);
    private static final String DSN_P12_CERT = "p12Certificate";
    private static final String DSN_SERVICE_ACCOUNT = "serviceAccount";
    public static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String ISO8601_NO_MS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final Set<String> sqlScope = new HashSet<String>(Arrays.asList("https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/sqlservice.admin"));
    private static final CustomHttpRequestInitializer initializer = new CustomHttpRequestInitializer();
    private JsonFactory jsonFactory = new JacksonFactory();
    private Cache<GoogleCredential> cachedCredentials = Cache.getInstance((CloudProvider)this, (String)"Credentials", GoogleCredential.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));
    private Cache<Compute> computeCache = Cache.getInstance((CloudProvider)this, (String)"ComputeAccess", Compute.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));
    private Cache<Storage> storageCache = Cache.getInstance((CloudProvider)this, (String)"DriveAccess", Storage.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));
    private Cache<Replicapool> replicapoolCache = Cache.getInstance((CloudProvider)this, (String)"ReplicapoolAccess", Replicapool.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));
    private Cache<GoogleCredential> cachedSqlCredentials = Cache.getInstance((CloudProvider)this, (String)"SqlCredentials", GoogleCredential.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));
    private Cache<SQLAdmin> sqlCache = Cache.getInstance((CloudProvider)this, (String)"SqlAccess", SQLAdmin.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        String pkg = Google.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("google") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.google.std." + pkg + Google.getLastItem(cls.getName())));
    }

    @Nonnull
    public static Logger getWireLogger(@Nonnull Class<?> cls) {
        return Logger.getLogger((String)("dasein.cloud.google.wire." + Google.getLastItem(cls.getPackage().getName()) + "." + Google.getLastItem(cls.getName())));
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloudName();
        return name == null ? "GCE" : name;
    }

    @Nonnull
    public ContextRequirements getContextRequirements() {
        return new ContextRequirements(new ContextRequirements.Field[]{new ContextRequirements.Field(DSN_P12_CERT, "The p12 file for the account", ContextRequirements.FieldType.KEYPAIR, "x509", true), new ContextRequirements.Field(DSN_SERVICE_ACCOUNT, "The service account email registered to the account", ContextRequirements.FieldType.TEXT, "accessKeys", true), new ContextRequirements.Field("proxyHost", "Proxy host", ContextRequirements.FieldType.TEXT, null, false), new ContextRequirements.Field("proxyPort", "Proxy port", ContextRequirements.FieldType.TEXT, null, false)});
    }

    @Nonnull
    public DataCenters getDataCenterServices() {
        return new DataCenters(this);
    }

    @Nonnull
    public GoogleCompute getComputeServices() {
        return new GoogleCompute(this);
    }

    @Nonnull
    public GoogleNetwork getNetworkServices() {
        return new GoogleNetwork(this);
    }

    @Nullable
    public GooglePlatform getPlatformServices() {
        return new GooglePlatform(this);
    }

    @Nullable
    public String getProxyHost() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return null;
        }
        Properties props = ctx.getCustomProperties();
        return props == null ? null : props.getProperty("proxyHost");
    }

    public int getProxyPort() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return -1;
        }
        Properties props = ctx.getCustomProperties();
        if (props == null) {
            return -1;
        }
        String port = props.getProperty("proxyPort");
        if (port != null) {
            return Integer.parseInt(port);
        }
        return -1;
    }

    @Nonnull
    public GoogleDrive getStorageServices() {
        return new GoogleDrive(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloud().getCloudName();
        return name == null ? "Google" : name;
    }

    private HttpTransport getTransport() {
        NetHttpTransport transport = null;
        int proxyPort = -1;
        String proxyHost = null;
        List fields = this.getContextRequirements().getConfigurableValues();
        for (ContextRequirements.Field f : fields) {
            if (f.compatName == null && f.name.equals("proxyHost")) {
                proxyHost = this.getProxyHost();
                continue;
            }
            if (f.compatName != null || !f.name.equals("proxyPort")) continue;
            proxyPort = this.getProxyPort();
        }
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            transport = new NetHttpTransport.Builder().setProxy(proxy).build();
        } else {
            transport = new NetHttpTransport();
        }
        return transport;
    }

    private GoogleCredential getCreds(HttpTransport transport, JsonFactory jsonFactory, Collection<String> scopes) throws Exception {
        byte[] p12Bytes = null;
        String p12Password = "";
        String serviceAccountId = "";
        List fields = this.getContextRequirements().getConfigurableValues();
        try {
            for (ContextRequirements.Field f : fields) {
                if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                    byte[][] keyPair = (byte[][])this.getContext().getConfigurationValue(f);
                    p12Bytes = keyPair[0];
                    p12Password = new String(keyPair[1], "utf-8");
                    continue;
                }
                if (f.compatName == null || !f.compatName.equals("accessKeys")) continue;
                serviceAccountId = (String)this.getContext().getConfigurationValue(f);
            }
        }
        catch (Exception ex) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 400, "Bad Credentials", "An authentication error has occurred: Bad Credentials");
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream p12AsStream = new ByteArrayInputStream(p12Bytes);
        keyStore.load(p12AsStream, p12Password.toCharArray());
        GoogleCredential creds = new GoogleCredential.Builder().setTransport(transport).setJsonFactory(jsonFactory).setServiceAccountId(serviceAccountId).setServiceAccountScopes(scopes).setServiceAccountPrivateKey((PrivateKey)keyStore.getKey("privateKey", p12Password.toCharArray())).build();
        return creds;
    }

    public Compute getGoogleCompute() throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        ArrayList<GoogleCredential> cachedCredential = (ArrayList<GoogleCredential>)this.cachedCredentials.get(ctx);
        ArrayList<Compute> googleCompute = (ArrayList<Compute>)this.computeCache.get(ctx);
        try {
            HttpTransport transport = this.getTransport();
            if (cachedCredential == null || googleCompute == null) {
                cachedCredential = new ArrayList<GoogleCredential>();
                cachedCredential.add(this.getCreds(transport, this.jsonFactory, ComputeScopes.all()));
                this.cachedCredentials.put(ctx, cachedCredential);
            }
            if (googleCompute == null) {
                googleCompute = new ArrayList<Compute>();
                googleCompute.add(new Compute.Builder(transport, this.jsonFactory, (HttpRequestInitializer)cachedCredential.iterator().next()).setApplicationName(ctx.getAccountNumber()).setHttpRequestInitializer((HttpRequestInitializer)initializer).build());
                this.computeCache.put(ctx, googleCompute);
            }
        }
        catch (Exception ex) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 400, "Bad Credentials", "An authentication error has occurred: Bad Credentials");
        }
        initializer.setStackedRequestInitializer(ctx, (GoogleCredential)cachedCredential.iterator().next());
        LogHandler.verifyInitialized();
        return (Compute)googleCompute.iterator().next();
    }

    public Storage getGoogleStorage() throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        ArrayList<GoogleCredential> cachedCredential = (ArrayList<GoogleCredential>)this.cachedCredentials.get(ctx);
        ArrayList<Storage> googleDrive = (ArrayList<Storage>)this.storageCache.get(ctx);
        try {
            HttpTransport transport = this.getTransport();
            if (cachedCredential == null || googleDrive == null) {
                cachedCredential = new ArrayList<GoogleCredential>();
                cachedCredential.add(this.getCreds(transport, this.jsonFactory, ComputeScopes.all()));
                this.cachedCredentials.put(ctx, cachedCredential);
            }
            if (googleDrive == null) {
                googleDrive = new ArrayList<Storage>();
                googleDrive.add(new Storage.Builder(transport, this.jsonFactory, (HttpRequestInitializer)cachedCredential.iterator().next()).setApplicationName(ctx.getAccountNumber()).setHttpRequestInitializer((HttpRequestInitializer)initializer).build());
                this.storageCache.put(ctx, googleDrive);
            }
        }
        catch (Exception ex) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 400, "Bad Credentials", "An authentication error has occurred: Bad Credentials");
        }
        initializer.setStackedRequestInitializer(ctx, (GoogleCredential)cachedCredential.iterator().next());
        LogHandler.verifyInitialized();
        return (Storage)googleDrive.iterator().next();
    }

    public SQLAdmin getGoogleSQLAdmin() throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        ArrayList<GoogleCredential> cachedSqlCredential = (ArrayList<GoogleCredential>)this.cachedSqlCredentials.get(ctx);
        ArrayList<SQLAdmin> googleSql = (ArrayList<SQLAdmin>)this.sqlCache.get(ctx);
        try {
            HttpTransport transport = this.getTransport();
            if (cachedSqlCredential == null) {
                cachedSqlCredential = new ArrayList<GoogleCredential>();
                cachedSqlCredential.add(this.getCreds(transport, this.jsonFactory, sqlScope));
                this.cachedSqlCredentials.put(ctx, cachedSqlCredential);
            }
            if (googleSql == null) {
                googleSql = new ArrayList<SQLAdmin>();
                googleSql.add(new SQLAdmin.Builder(transport, this.jsonFactory, (HttpRequestInitializer)cachedSqlCredential.iterator().next()).setApplicationName(ctx.getAccountNumber()).setHttpRequestInitializer((HttpRequestInitializer)initializer).build());
                this.sqlCache.put(ctx, googleSql);
            }
        }
        catch (Exception ex) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 400, "Bad Credentials", "An authentication error has occurred: Bad Credentials");
        }
        initializer.setStackedRequestInitializer(ctx, (GoogleCredential)cachedSqlCredential.iterator().next());
        LogHandler.verifyInitialized();
        return (SQLAdmin)googleSql.iterator().next();
    }

    @Nullable
    public CIServices getCIServices() {
        return new GoogleCIServices(this);
    }

    public Replicapool getGoogleReplicapool() throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        ArrayList<GoogleCredential> cachedCredential = (ArrayList<GoogleCredential>)this.cachedCredentials.get(ctx);
        ArrayList<Replicapool> replicaPool = (ArrayList<Replicapool>)this.replicapoolCache.get(ctx);
        try {
            HttpTransport transport = this.getTransport();
            if (cachedCredential == null) {
                cachedCredential = new ArrayList<GoogleCredential>();
                cachedCredential.add(this.getCreds(transport, this.jsonFactory, sqlScope));
                this.cachedCredentials.put(ctx, cachedCredential);
            }
            if (replicaPool == null) {
                replicaPool = new ArrayList<Replicapool>();
                replicaPool.add(new Replicapool.Builder(transport, this.jsonFactory, (HttpRequestInitializer)cachedCredential.iterator().next()).setApplicationName(ctx.getAccountNumber()).setHttpRequestInitializer((HttpRequestInitializer)initializer).build());
                this.replicapoolCache.put(ctx, replicaPool);
            }
        }
        catch (Exception ex) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 400, "Bad Credentials", "An authentication error has occurred: Bad Credentials");
        }
        initializer.setStackedRequestInitializer(ctx, (GoogleCredential)cachedCredential.iterator().next());
        LogHandler.verifyInitialized();
        return (Replicapool)replicaPool.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + Google.class.getName() + ".testContext()"));
        }
        NetHttpTransport httpTransport2 = new NetHttpTransport();
        JacksonFactory jsonFactory2 = new JacksonFactory();
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return null;
        }
        try {
            GoogleCredential creds = null;
            Compute googleCompute = null;
            try {
                creds = this.getCreds((HttpTransport)httpTransport2, (JsonFactory)jsonFactory2, ComputeScopes.all());
                googleCompute = new Compute.Builder((HttpTransport)httpTransport2, (JsonFactory)jsonFactory2, (HttpRequestInitializer)creds).setApplicationName(ctx.getAccountNumber()).build();
                googleCompute.networks().list(ctx.getAccountNumber()).execute();
                String string = ctx.getAccountNumber();
                return string;
            }
            catch (Exception e) {
                logger.error((Object)"Error list firewalls failed: ");
                String string = null;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("EXIT - " + Google.class.getName() + ".textContext()"));
                }
                return string;
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + Google.class.getName() + ".textContext()"));
            }
        }
    }

    public long parseTime(@Nullable String time) throws CloudException {
        if (time == null) {
            return 0L;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        if (time.length() > 0) {
            try {
                return fmt.parse(time).getTime();
            }
            catch (ParseException e) {
                fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                try {
                    return fmt.parse(time).getTime();
                }
                catch (ParseException encore) {
                    throw new CloudException("Could not parse date: " + time);
                }
            }
        }
        return 0L;
    }
}

