/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.google.Google;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleException
extends CloudException {
    private static final Logger wire = Google.getWireLogger(GoogleException.class);
    private static final Logger logger = Google.getLogger(GoogleException.class);

    public GoogleException(@Nonnull Throwable cause) {
        super(cause);
    }

    public GoogleException(@Nonnull CloudErrorType type, @Nonnegative int httpCode, @Nonnull String providerCode, @Nonnull String message) {
        super(type, httpCode, providerCode, message);
    }

    public GoogleException(ParsedException exception) {
        super(exception.type, exception.code, exception.providerCode, exception.message);
    }

    public static class ParsedException {
        public int code;
        public String message;
        public String providerCode;
        public CloudErrorType type;

        public ParsedException(@Nonnull HttpResponse response) {
            block8: {
                this.code = response.getStatusLine().getStatusCode();
                this.providerCode = this.toCode(this.code);
                this.message = "";
                this.type = CloudErrorType.GENERAL;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block8;
                    String json = EntityUtils.toString((HttpEntity)entity);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)json);
                    }
                    this.message = json;
                    try {
                        JSONArray list;
                        JSONObject ob = new JSONObject(json);
                        if (ob.has("list") && (list = ob.getJSONArray("list")) != null && list.length() > 0) {
                            JSONObject error = list.getJSONObject(0);
                            if (error.has("message")) {
                                this.message = error.getString("message");
                            }
                            if (error.has("errorcode")) {
                                this.providerCode = error.getString("errorcode");
                            }
                        }
                    }
                    catch (JSONException ignore) {}
                }
                catch (Throwable e) {
                    logger.error((Object)("Failed to parse error from GoGrid: " + e.getMessage()));
                }
            }
        }

        @Nonnull
        private String toCode(int code) {
            switch (code) {
                case 400: {
                    return "IllegalArgument";
                }
                case 401: {
                    return "Unauthorized";
                }
                case 403: {
                    return "AuthenticationFailed";
                }
                case 404: {
                    return "NotFound";
                }
                case 500: {
                    return "UnexpectedError";
                }
            }
            return String.valueOf(code);
        }
    }
}

