/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.replicapool.Replicapool;
import com.google.api.services.replicapool.model.Operation;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.api.services.sqladmin.model.OperationError;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleOperationType;

public class GoogleMethod {
    private static final Logger logger = Google.getLogger(GoogleMethod.class);
    private static final Logger wire = Google.getWireLogger(GoogleMethod.class);
    private Google provider;

    public GoogleMethod(@Nonnull Google provider) {
        this.provider = provider;
    }

    @Nonnull
    public String getOperationTarget(@Nonnull ProviderContext ctx, @Nonnull com.google.api.services.compute.model.Operation job, @Nonnull GoogleOperationType operationType, String regionId, String dataCenterId, boolean getLink) throws CloudException, InternalException {
        long timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            if (job.getError() != null) {
                Iterator i$ = job.getError().getErrors().iterator();
                if (i$.hasNext()) {
                    Operation.Error.Errors error = (Operation.Error.Errors)i$.next();
                    throw new CloudException("An error occurred: " + error.getMessage());
                }
            } else if (job.getStatus().equals("DONE")) {
                if (getLink) {
                    return job.getTargetLink();
                }
                return job.getTargetLink().substring(job.getTargetLink().lastIndexOf("/") + 1);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                Compute gce = this.provider.getGoogleCompute();
                switch (operationType) {
                    case GLOBAL_OPERATION: {
                        job = (com.google.api.services.compute.model.Operation)gce.globalOperations().get(ctx.getAccountNumber(), job.getName()).execute();
                        break;
                    }
                    case REGION_OPERATION: {
                        job = (com.google.api.services.compute.model.Operation)gce.regionOperations().get(ctx.getAccountNumber(), regionId, job.getName()).execute();
                        break;
                    }
                    case ZONE_OPERATION: {
                        job = (com.google.api.services.compute.model.Operation)gce.zoneOperations().get(ctx.getAccountNumber(), dataCenterId, job.getName()).execute();
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        throw new CloudException(CloudErrorType.COMMUNICATION, 408, "", "System timed out waiting for Operation to complete");
    }

    @Nonnull
    public boolean getOperationComplete(ProviderContext ctx, com.google.api.services.compute.model.Operation job, GoogleOperationType operationType, String regionId, String dataCenterId) throws CloudException, InternalException {
        long timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            if (job.getError() != null) {
                Iterator i$ = job.getError().getErrors().iterator();
                if (i$.hasNext()) {
                    Operation.Error.Errors error = (Operation.Error.Errors)i$.next();
                    throw new CloudException("An error occurred: " + error.getMessage());
                }
            } else if (job.getStatus().equals("DONE")) {
                return true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                Compute gce = this.provider.getGoogleCompute();
                switch (operationType) {
                    case GLOBAL_OPERATION: {
                        job = (com.google.api.services.compute.model.Operation)gce.globalOperations().get(ctx.getAccountNumber(), job.getName()).execute();
                        break;
                    }
                    case REGION_OPERATION: {
                        job = (com.google.api.services.compute.model.Operation)gce.regionOperations().get(ctx.getAccountNumber(), regionId, job.getName()).execute();
                        break;
                    }
                    case ZONE_OPERATION: {
                        job = (com.google.api.services.compute.model.Operation)gce.zoneOperations().get(ctx.getAccountNumber(), dataCenterId, job.getName()).execute();
                    }
                }
            }
            catch (IOException ex) {}
        }
        throw new CloudException(CloudErrorType.COMMUNICATION, 408, "", "System timed out waiting for Operation to complete");
    }

    public void getRDSOperationComplete(ProviderContext ctx, String operation) throws CloudException, InternalException {
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        long timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            com.google.api.services.sqladmin.model.Operation instanceOperation = null;
            try {
                instanceOperation = (com.google.api.services.sqladmin.model.Operation)sqlAdmin.operations().get(ctx.getAccountNumber(), operation).execute();
            }
            catch (IOException e) {
                logger.warn((Object)("getRDSOperationComplete Ignoring " + e.getMessage()));
            }
            if (instanceOperation.getError() != null) {
                Iterator i$ = instanceOperation.getError().getErrors().iterator();
                if (i$.hasNext()) {
                    OperationError error = (OperationError)i$.next();
                    throw new CloudException("An error occurred: " + error.getCode() + " : " + error.getKind());
                }
            } else if (instanceOperation.getStatus().equals("DONE")) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {}
        }
        throw new CloudException(CloudErrorType.COMMUNICATION, 408, "", "System timed out waiting for Operation to complete");
    }

    public void getRDSOperationCompleteLong(ProviderContext ctx, String operation) throws CloudException, InternalException {
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        if (null == ctx) {
            throw new InternalException("ctx cannot be null");
        }
        if (null == operation) {
            throw new InternalException("operation cannot be null");
        }
        long timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            com.google.api.services.sqladmin.model.Operation instanceOperation = null;
            try {
                instanceOperation = (com.google.api.services.sqladmin.model.Operation)sqlAdmin.operations().get(ctx.getAccountNumber(), operation).execute();
            }
            catch (IOException e) {
                logger.warn((Object)("Ignoring sqlAdmin.operations().get() exception: " + e.getMessage()));
            }
            if (null != instanceOperation) {
                if (null != instanceOperation.getError()) {
                    Iterator i$ = instanceOperation.getError().getErrors().iterator();
                    if (i$.hasNext()) {
                        OperationError error = (OperationError)i$.next();
                        throw new CloudException("An error occurred: " + error.getCode() + " : " + error.getKind());
                    }
                } else if (instanceOperation.getStatus().equals("DONE")) {
                    return;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ignore) {}
        }
        throw new CloudException(CloudErrorType.COMMUNICATION, 408, "", "System timed out waiting for Operation to complete");
    }

    @Nonnull
    public boolean getCIOperationComplete(ProviderContext ctx, Operation job, GoogleOperationType operationType, String regionId, String dataCenterId) throws CloudException, InternalException {
        Replicapool rp;
        long timeout = System.currentTimeMillis() + 1200000L;
        try {
            rp = this.provider.getGoogleReplicapool();
        }
        catch (InternalException e) {
            throw new InternalException("Cannot get Compute(google)");
        }
        while (timeout > System.currentTimeMillis()) {
            try {
                job = (Operation)rp.zoneOperations().get(ctx.getAccountNumber(), dataCenterId, job.getName()).execute();
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
            if (job.getError() != null) {
                Iterator i$ = job.getError().getErrors().iterator();
                if (i$.hasNext()) {
                    Operation.Error.Errors error = (Operation.Error.Errors)i$.next();
                    throw new CloudException("An error occurred: " + error.getMessage());
                }
            } else if (job.getStatus().equals("DONE")) {
                return true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {}
        }
        throw new CloudException(CloudErrorType.COMMUNICATION, 408, "", "System timed out waiting for Operation to complete");
    }
}

