/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google;

import com.google.api.client.http.HttpTransport;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class LogHandler {
    private static Logger logger;

    private LogHandler() {
    }

    public static void verifyInitialized() {
        org.apache.log4j.Logger wire;
        if (null == logger && (wire = LogHandler.getWireLogger(HttpTransport.class)).isDebugEnabled()) {
            logger = Logger.getLogger(HttpTransport.class.getName());
            logger.setLevel(Level.CONFIG);
            logger.addHandler(new Handler(){

                @Override
                public void publish(LogRecord record) {
                    String msg = record.getMessage();
                    if (msg.startsWith("-------------- REQUEST")) {
                        String[] lines;
                        for (String line : lines = msg.split("[\n\r]+")) {
                            if (!line.contains("https") && !line.contains("Content-Length")) continue;
                            wire.debug((Object)("--> REQUEST: " + line));
                        }
                    } else if (msg.startsWith("{")) {
                        wire.debug((Object)msg);
                    } else if (msg.startsWith("Total")) {
                        wire.debug((Object)("<-- RESPONSE: " + record.getMessage()));
                    }
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            });
        }
    }

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static org.apache.log4j.Logger getWireLogger(@Nonnull Class<?> cls) {
        return org.apache.log4j.Logger.getLogger((String)("dasein.cloud.google.wire." + LogHandler.getLastItem(cls.getPackage().getName()) + "." + LogHandler.getLastItem(cls.getName())));
    }
}

