/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.storage.BlobStoreCapabilities;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class GCEBlobStoreCapabilities
extends AbstractCapabilities<Google>
implements BlobStoreCapabilities {
    private Google cloud;

    public GCEBlobStoreCapabilities(@Nonnull Google cloud) {
        super((CloudProvider)cloud);
        this.cloud = cloud;
    }

    public String getAccountNumber() {
        return this.cloud.getContext().getAccountNumber();
    }

    public String getRegionId() {
        return this.cloud.getContext().getRegionId();
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return true;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return true;
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return 0x7FFFFFFE;
    }

    public Storage<Byte> getMaxObjectSize() throws InternalException, CloudException {
        return (Storage)new Storage((Number)4L, (StorageUnit)Storage.GIGABYTE).convertTo((UnitOfMeasure)Storage.BYTE);
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return 0x7FFFFFFE;
    }

    public NamingConstraints getBucketNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)3, (int)63).withRegularExpression("^[a-z][_.-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-', '_', '.'});
    }

    public NamingConstraints getObjectNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getStrictInstance((int)1, (int)255);
    }

    public String getProviderTermForBucket(Locale locale) {
        return "Buckets";
    }

    public String getProviderTermForObject(Locale locale) {
        return "Objects";
    }
}

