/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.FirewallCapabilities;
import org.dasein.cloud.network.FirewallConstraints;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.util.NamingConstraints;

public class GCEFirewallCapabilities
extends AbstractCapabilities<Google>
implements FirewallCapabilities {
    private static volatile Iterable<Protocol> allProtocolTypes;

    public GCEFirewallCapabilities(Google provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public FirewallConstraints getFirewallConstraintsForCloud() throws InternalException, CloudException {
        return FirewallConstraints.getInstance().withConstraint(FirewallConstraints.Constraint.PERMISSION, FirewallConstraints.Level.REQUIRED).withConstraint(FirewallConstraints.Constraint.DIRECTION, FirewallConstraints.Level.REQUIRED).withConstraint(FirewallConstraints.Constraint.SOURCE, FirewallConstraints.Level.IF_DEFINED);
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "firewall";
    }

    @Nullable
    public VisibleScope getFirewallVisibleScope() {
        return VisibleScope.ACCOUNT_GLOBAL;
    }

    @Nonnull
    public Requirement identifyPrecedenceRequirement(boolean inVlan) throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isZeroPrecedenceHighest() throws InternalException, CloudException {
        return false;
    }

    @Deprecated
    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        return this.listSupportedDestinationTypes(inVlan, Direction.INGRESS);
    }

    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        return Collections.unmodifiableList(Collections.singletonList(Direction.INGRESS));
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        return Collections.unmodifiableList(Collections.singletonList(Permission.ALLOW));
    }

    @Deprecated
    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        return this.listSupportedSourceTypes(inVlan, Direction.INGRESS);
    }

    public boolean requiresRulesOnCreation() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Requirement requiresVLAN() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean supportsRules(@Nonnull Direction direction, @Nonnull Permission permission, boolean inVlan) throws CloudException, InternalException {
        return permission.equals((Object)Permission.ALLOW) && direction.equals((Object)Direction.INGRESS);
    }

    public boolean supportsFirewallCreation(boolean inVlan) throws CloudException, InternalException {
        return false;
    }

    public boolean supportsFirewallDeletion() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<Protocol> listSupportedProtocols(boolean inVlan) throws InternalException, CloudException {
        if (allProtocolTypes == null) {
            allProtocolTypes = Collections.unmodifiableList(Arrays.asList(Protocol.UDP, Protocol.TCP, Protocol.ICMP));
        }
        return allProtocolTypes;
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan, @Nonnull Direction direction) throws InternalException, CloudException {
        if (Direction.INGRESS == direction) {
            return Collections.unmodifiableList(Arrays.asList(RuleTargetType.CIDR, RuleTargetType.VM));
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan, @Nonnull Direction direction) throws InternalException, CloudException {
        if (Direction.INGRESS == direction) {
            return Collections.unmodifiableList(Arrays.asList(RuleTargetType.CIDR, RuleTargetType.VM));
        }
        return Collections.emptyList();
    }

    public NamingConstraints getFirewallNamingConstraints() {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-'});
    }
}

