/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ci.HttpLoadBalancerCapabilities;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.util.NamingConstraints;

public class GCEHttpLoadBalancerCapabilities
extends AbstractCapabilities<Google>
implements HttpLoadBalancerCapabilities {
    public GCEHttpLoadBalancerCapabilities(Google provider) {
        super((CloudProvider)provider);
    }

    public boolean supportsHttpTraffic() {
        return true;
    }

    public boolean supportsHttpsTraffic() {
        return false;
    }

    public boolean supportsHealthChecks() {
        return true;
    }

    public boolean supportsMoreThanOneHealthCheck() {
        return false;
    }

    public boolean supportsBackendServices() {
        return true;
    }

    public boolean supportsMoreThanOneBackendService() {
        return true;
    }

    public boolean supportsUrlSets() {
        return true;
    }

    public boolean supportsMoreThanOneUrlSet() {
        return true;
    }

    public boolean supportsTargetHttpProxies() {
        return true;
    }

    public boolean supportsMoreThanOneTargetHttpProxy() {
        return true;
    }

    public boolean supportsForwardingRules() {
        return true;
    }

    public boolean supportsMoreThanOneForwardingRule() {
        return true;
    }

    public String getProviderTermForHttpLoadBalancer(Locale locale) {
        return "HTTP Load Balancer";
    }

    public Iterable<String> listSupportedHttpPorts() {
        return Collections.unmodifiableList(Arrays.asList("80", "8080"));
    }

    public boolean supportsUsingExistingHealthCheck() {
        return true;
    }

    public boolean supportsUsingExistingBackendService() {
        return true;
    }

    @Nonnull
    public NamingConstraints getConvergedHttpLoadBalancerNamingConstraints() {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-'});
    }
}

