/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.util.NamingConstraints;

public class GCEImageCapabilities
extends AbstractCapabilities<Google>
implements ImageCapabilities {
    public GCEImageCapabilities(@Nonnull Google cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canBundle(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canImage(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return "image";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return "image";
    }

    @Nullable
    public VisibleScope getImageVisibleScope() {
        return VisibleScope.ACCOUNT_GLOBAL;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.RAW);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.unmodifiableList(Collections.singletonList(ImageClass.MACHINE));
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.unmodifiableList(Collections.singletonList(MachineImageType.STORAGE));
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return true;
    }

    public boolean supportsImageSharing() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsImageSharingWithPublic() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }

    public boolean supportsImageCopy() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsListingAllRegions() throws CloudException, InternalException {
        return true;
    }

    public boolean imageCaptureDestroysVM() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public NamingConstraints getImageNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-'});
    }
}

