/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.util.NamingConstraints;

public class GCEInstanceCapabilities
extends AbstractCapabilities<Google>
implements VirtualMachineCapabilities {
    public GCEInstanceCapabilities(@Nonnull Google cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState == VmState.RUNNING || fromState == VmState.STOPPED;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState == VmState.RUNNING;
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState == VmState.STOPPED;
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState == VmState.RUNNING;
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState == VmState.RUNNING || fromState == VmState.STOPPED;
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    public int getCostFactor(@Nonnull VmState state) throws CloudException, InternalException {
        int costFactor = 0;
        switch (state) {
            case TERMINATED: {
                costFactor = 0;
                break;
            }
            default: {
                costFactor = 100;
            }
        }
        return costFactor;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "instance";
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)false, (Requirement)Requirement.NONE, (Requirement)Requirement.NONE);
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-'});
    }

    @Nullable
    public VisibleScope getVirtualMachineVisibleScope() {
        return VisibleScope.ACCOUNT_DATACENTER;
    }

    @Nullable
    public VisibleScope getVirtualMachineProductVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        return Collections.unmodifiableList(Arrays.asList(Architecture.I64, Architecture.I32));
    }

    public boolean supportsSpotVirtualMachines() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsAlterVM() {
        return false;
    }

    public boolean supportsClone() {
        return true;
    }

    public boolean supportsPause() {
        return false;
    }

    public boolean supportsReboot() {
        return true;
    }

    public boolean supportsResume() {
        return false;
    }

    public boolean supportsStart() {
        return false;
    }

    public boolean supportsStop() {
        return false;
    }

    public boolean supportsSuspend() {
        return false;
    }

    public boolean supportsTerminate() {
        return true;
    }

    public boolean supportsUnPause() {
        return false;
    }

    public boolean isUserDefinedPrivateIPSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsClientRequestToken() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsCloudStoredShellKey() throws InternalException, CloudException {
        return false;
    }

    public boolean isVMProductDCConstrained() throws InternalException, CloudException {
        return false;
    }
}

