/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;
import org.dasein.cloud.util.NamingConstraints;

public class GCELoadBalancerCapabilities
extends AbstractCapabilities<Google>
implements LoadBalancerCapabilities {
    private static final Logger logger = Logger.getLogger(GCELoadBalancerCapabilities.class);
    private static volatile List<IPVersion> versions;
    private static volatile List<LbProtocol> protocols;

    public GCELoadBalancerCapabilities(@Nonnull Google Google2) {
        super((CloudProvider)Google2);
    }

    @Nonnull
    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.DNS;
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 0;
    }

    @Nonnull
    public String getProviderTermForLoadBalancer(Locale locale) {
        return "load balancer";
    }

    @Nullable
    public VisibleScope getLoadBalancerVisibleScope() {
        return VisibleScope.ACCOUNT_REGION;
    }

    public boolean healthCheckRequiresLoadBalancer() throws CloudException, InternalException {
        return true;
    }

    public Requirement identifyEndpointsOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyListenersOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    public boolean isAddressAssignedByProvider() throws CloudException, InternalException {
        return true;
    }

    public boolean isDataCenterLimited() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<LbAlgorithm> listSupportedAlgorithms() throws CloudException, InternalException {
        return Collections.singletonList(LbAlgorithm.SOURCE);
    }

    @Nonnull
    public Iterable<LbEndpointType> listSupportedEndpointTypes() throws CloudException, InternalException {
        return Collections.singletonList(LbEndpointType.VM);
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        if (versions == null) {
            versions = Collections.unmodifiableList(Arrays.asList(IPVersion.IPV4));
        }
        return versions;
    }

    @Nonnull
    public Iterable<LbPersistence> listSupportedPersistenceOptions() throws CloudException, InternalException {
        return Collections.singletonList(LbPersistence.SUBNET);
    }

    @Nonnull
    public Iterable<LbProtocol> listSupportedProtocols() throws CloudException, InternalException {
        if (protocols == null) {
            protocols = Collections.unmodifiableList(Arrays.asList(LbProtocol.RAW_TCP));
        }
        return protocols;
    }

    public boolean supportsAddingEndpoints() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMonitoring() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMultipleTrafficTypes() throws CloudException, InternalException {
        return false;
    }

    public Requirement healthCheckRequiresName() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public Requirement identifyVlanOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyHealthCheckOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public NamingConstraints getLoadBalancerNamingConstraints() {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-'});
    }

    public boolean supportsSslCertificateStore() throws CloudException, InternalException {
        return true;
    }
}

