/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.platform.RelationalDatabaseCapabilities;
import org.dasein.cloud.util.NamingConstraints;

public class GCERelationalDatabaseCapabilities
extends AbstractCapabilities<Google>
implements RelationalDatabaseCapabilities {
    private Google provider;

    public GCERelationalDatabaseCapabilities(@Nonnull Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public String getProviderTermForDatabase(Locale locale) {
        return "database";
    }

    public String getProviderTermForSnapshot(Locale locale) {
        return "point-in-time recovery";
    }

    public String getProviderTermForBackup(Locale locale) {
        return "Backup";
    }

    public boolean supportsFirewallRules() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsHighAvailability() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsLowAvailability() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsMaintenanceWindows() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsAlterDatabase() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsSnapshots() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsDatabaseBackups() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsScheduledDatabaseBackups() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsDemandBackups() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsRestoreBackup() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsDeleteBackup() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsBackupConfigurations() throws CloudException, InternalException {
        return false;
    }

    public String getAccountNumber() {
        ProviderContext ctx = this.provider.getContext();
        return ctx.getAccountNumber();
    }

    public String getRegionId() {
        ProviderContext ctx = this.provider.getContext();
        return ctx.getRegionId();
    }

    @Nonnull
    public NamingConstraints getRelationalDatabaseNamingConstraints() {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}$").lowerCaseOnly().withNoSpaces().constrainedBy(new char[]{'-'});
    }
}

