/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.capabilities;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class GCEVolumeCapabilities
extends AbstractCapabilities<Google>
implements VolumeCapabilities {
    private static volatile List<String> nonWindowsDevices;

    public GCEVolumeCapabilities(@Nonnull Google cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canAttach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.RUNNING);
    }

    public boolean canDetach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.RUNNING);
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)10000, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public NamingConstraints getVolumeNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)63).withRegularExpression("^[a-z][-a-z0-9]{0,61}[a-z0-9]$").lowerCaseOnly().withNoSpaces().withLastCharacterSymbolAllowed(false).constrainedBy(new char[]{'-'});
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "disk";
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        if (!platform.isWindows()) {
            if (nonWindowsDevices == null) {
                nonWindowsDevices = Collections.unmodifiableList(Arrays.asList("sdf", "sdg", "sdh", "sdi", "sdj", "sdk", "sdl", "sdm", "sdn", "sdo", "sdp", "sdq", "sdr", "sds", "sdt"));
            }
            return nonWindowsDevices;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Requirement requiresVMOnCreate() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public int getMaximumVolumeProductIOPS() throws InternalException, CloudException {
        return 10000;
    }

    public int getMaximumVolumeSizeIOPS() throws InternalException, CloudException {
        return 10000;
    }

    public int getMinimumVolumeProductIOPS() throws InternalException, CloudException {
        return 3000;
    }

    public int getMinimumVolumeSizeIOPS() throws InternalException, CloudException {
        return 3000;
    }

    public Requirement getDeviceIdOnAttachRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }
}

