/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.compute.server;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskAggregatedList;
import com.google.api.services.compute.model.DisksScopedList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Snapshot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractVolumeSupport;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFilterOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEVolumeCapabilities;
import org.dasein.cloud.util.APITrace;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DiskSupport
extends AbstractVolumeSupport {
    private static final Logger logger = Google.getLogger(DiskSupport.class);
    private Google provider;
    private volatile transient GCEVolumeCapabilities capabilities;

    public DiskSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@Nonnull String volumeId, @Nonnull String toServerId, @Nonnull String deviceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.attach");
        String toServer = this.provider.getComputeServices().getVirtualMachineSupport().getVmNameFromId(toServerId);
        try {
            Compute gce = this.provider.getGoogleCompute();
            try {
                VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(toServer);
                if (null == vm) {
                    throw new CloudException("Virtual machine " + toServer + " does not exist.");
                }
                Volume volume = this.getVolume(volumeId);
                AttachedDisk attachedDisk = new AttachedDisk();
                attachedDisk.setSource(volume.getTag("contentLink"));
                attachedDisk.setType("PERSISTENT");
                attachedDisk.setMode("READ_WRITE");
                attachedDisk.setBoot(Boolean.valueOf(false));
                attachedDisk.setDeviceName(deviceId);
                Operation job = (Operation)gce.instances().attachDisk(this.provider.getContext().getAccountNumber(), vm.getProviderDataCenterId(), toServer, attachedDisk).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", vm.getProviderDataCenterId())) {
                    throw new CloudException("An error occurred attaching the disk: Operation Timedout");
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while attaching the disk: " + ex.getMessage());
            }
            catch (Exception ex) {
                throw new CloudException("An error occurred while attaching the disk: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.createVolume");
        try {
            Compute gce = this.provider.getGoogleCompute();
            if (options.getFormat() == VolumeFormat.NFS) {
                throw new OperationNotSupportedException("NFS volumes not supported by GCE");
            }
            try {
                Disk disk = new Disk();
                disk.setName(this.getCapabilities().getVolumeNamingConstraints().convertToValidName(options.getName(), Locale.US));
                disk.setSizeGb(Long.valueOf(options.getVolumeSize().longValue()));
                disk.setZone(options.getDataCenterId());
                if (options.getSnapshotId() != null) {
                    Snapshot snapshot = (Snapshot)gce.snapshots().get(this.provider.getContext().getAccountNumber(), options.getSnapshotId()).execute();
                    disk.setSourceSnapshot(snapshot.getSelfLink());
                }
                Operation job = (Operation)gce.disks().insert(this.provider.getContext().getAccountNumber(), options.getDataCenterId(), disk).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                String string = method.getOperationTarget(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", options.getDataCenterId(), false);
                return string;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while creating the Volume: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.detach");
        try {
            Volume volume = this.getVolume(volumeId);
            Compute gce = this.provider.getGoogleCompute();
            Operation job = null;
            try {
                if (null != volume.getProviderVirtualMachineId()) {
                    String vmName = this.provider.getComputeServices().getVirtualMachineSupport().getVmNameFromId(volume.getProviderVirtualMachineId());
                    job = (Operation)gce.instances().detachDisk(this.provider.getContext().getAccountNumber(), volume.getProviderDataCenterId(), vmName, volume.getDeviceId()).execute();
                    GoogleMethod method = new GoogleMethod(this.provider);
                    if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", volume.getProviderDataCenterId())) {
                        throw new CloudException("An error occurred while detaching the volume: Operation Timedout");
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while detaching the volume: " + ex.getMessage());
            }
            catch (Exception ex) {
                throw new CloudException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public GCEVolumeCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new GCEVolumeCapabilities(this.provider);
        }
        return this.capabilities;
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return 16;
    }

    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)10240, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)200, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "disk";
    }

    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.getVolume");
        try {
            Compute gce = this.provider.getGoogleCompute();
            try {
                DiskAggregatedList diskList = (DiskAggregatedList)gce.disks().aggregatedList(this.provider.getContext().getAccountNumber()).setFilter("name eq " + volumeId).execute();
                for (String zone : diskList.getItems().keySet()) {
                    if (diskList.getItems().get(zone) == null || ((DisksScopedList)diskList.getItems().get(zone)).getDisks() == null) continue;
                    for (Disk disk : ((DisksScopedList)diskList.getItems().get(zone)).getDisks()) {
                        if (!disk.getName().equals(volumeId)) continue;
                        Volume volume = this.toVolume(disk);
                        return volume;
                    }
                }
                Volume volume = null;
                return volume;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred getting the volume: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return true;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        if (!platform.isWindows()) {
            list.add("sdf");
            list.add("sdg");
            list.add("sdh");
            list.add("sdi");
            list.add("sdj");
            list.add("sdk");
            list.add("sdl");
            list.add("sdm");
            list.add("sdn");
            list.add("sdo");
            list.add("sdp");
            list.add("sdq");
            list.add("sdr");
            list.add("sds");
            list.add("sdt");
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws InternalException, CloudException {
        ArrayList<ResourceStatus> status = new ArrayList<ResourceStatus>();
        Iterable<Volume> volumes = this.listVolumes();
        for (Volume volume : volumes) {
            VolumeState state = volume.getCurrentState();
            ResourceStatus resStatus = new ResourceStatus(volume.getProviderVolumeId(), (Object)state);
            status.add(resStatus);
        }
        return status;
    }

    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        return this.listVolumes(null);
    }

    @Nonnull
    public Iterable<Volume> listVolumes(VolumeFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.listVolumes");
        try {
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            Compute gce = this.provider.getGoogleCompute();
            try {
                DiskAggregatedList diskList = (DiskAggregatedList)gce.disks().aggregatedList(this.provider.getContext().getAccountNumber()).execute();
                for (String zone : diskList.getItems().keySet()) {
                    if (diskList.getItems().get(zone) == null || ((DisksScopedList)diskList.getItems().get(zone)).getDisks() == null) continue;
                    for (Disk disk : ((DisksScopedList)diskList.getItems().get(zone)).getDisks()) {
                        Volume volume = this.toVolume(disk);
                        if (volume == null || options != null && !options.matches(volume)) continue;
                        volumes.add(volume);
                    }
                }
                ArrayList<Volume> arrayList = volumes;
                return arrayList;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred listing Volumes: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.remove");
        try {
            Compute gce = this.provider.getGoogleCompute();
            Volume volume = this.getVolume(volumeId);
            try {
                Operation job = (Operation)gce.disks().delete(this.provider.getContext().getAccountNumber(), volume.getProviderDataCenterId(), volume.getProviderVolumeId()).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", volume.getProviderDataCenterId())) {
                    throw new CloudException("An error occurred while deleting the Volume: Operation Timedout");
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while deleting the volume: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public Volume toVolume(Disk disk) throws InternalException, CloudException {
        Volume volume = new Volume();
        volume.setProviderVolumeId(disk.getName());
        volume.setName(disk.getName());
        volume.setMediaLink(disk.getSelfLink());
        if (disk.getDescription() == null) {
            volume.setDescription(disk.getName());
        } else {
            volume.setDescription(disk.getDescription());
        }
        volume.setProviderRegionId(this.provider.getDataCenterServices().getRegionFromZone(disk.getZone().substring(disk.getZone().lastIndexOf("/") + 1)));
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        DateTime dt = DateTime.parse((String)disk.getCreationTimestamp(), (DateTimeFormatter)fmt);
        volume.setCreationTimestamp(dt.toDate().getTime());
        volume.setProviderDataCenterId(disk.getZone().substring(disk.getZone().lastIndexOf("/") + 1));
        if (disk.getStatus().equals("DONE") || disk.getStatus().equals("READY")) {
            volume.setCurrentState(VolumeState.AVAILABLE);
        } else if (disk.getStatus().equals("FAILED")) {
            volume.setCurrentState(VolumeState.ERROR);
        } else {
            volume.setCurrentState(VolumeState.PENDING);
        }
        volume.setType(VolumeType.HDD);
        volume.setFormat(VolumeFormat.BLOCK);
        volume.setSize(new Storage((Number)disk.getSizeGb(), (StorageUnit)Storage.GIGABYTE));
        if (disk.getSourceSnapshotId() != null && !disk.getSourceSnapshotId().equals("")) {
            volume.setProviderSnapshotId(disk.getSourceSnapshotId());
        }
        volume.setTag("contentLink", disk.getSelfLink());
        Compute gce = this.provider.getGoogleCompute();
        try {
            InstanceList list = (InstanceList)gce.instances().list(this.provider.getContext().getAccountNumber(), disk.getZone().substring(disk.getZone().lastIndexOf("/") + 1)).execute();
            if (list.getItems() != null) {
                block2: for (Instance instance : list.getItems()) {
                    for (AttachedDisk attachedDisk : instance.getDisks()) {
                        if (!attachedDisk.getSource().equals(disk.getSelfLink())) continue;
                        volume.setDeviceId(attachedDisk.getDeviceName());
                        volume.setProviderVirtualMachineId(instance.getName() + "_" + instance.getId());
                        continue block2;
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            return null;
        }
        return volume;
    }
}

