/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.compute.server;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEImageCapabilities;
import org.dasein.cloud.google.compute.server.ServerSupport;
import org.dasein.cloud.util.APITrace;

public class ImageSupport
extends AbstractImageSupport<Google> {
    private Google provider;
    private static final Logger logger = Google.getLogger(ImageSupport.class);
    private volatile transient GCEImageCapabilities capabilities;

    public ImageSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public void addImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to share images");
    }

    public void addPublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to make images public");
    }

    @Nonnull
    public String bundleVirtualMachine(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Bundling of virtual machines not supported");
    }

    public void bundleVirtualMachineAsync(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name, AsynchronousTask<String> trackingTask) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Bundling of virtual machines not supported");
    }

    @Nonnull
    public GCEImageCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GCEImageCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Image.getImage");
        if (!providerImageId.contains("_")) {
            throw new CloudException("Invalid image. Image does not conform to Dasein convention, " + providerImageId + " lacks a '_'");
        }
        try {
            Image image;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been established for this request");
            }
            Compute gce = this.provider.getGoogleCompute();
            try {
                String[] parts = providerImageId.split("_");
                image = (Image)gce.images().get(parts[0], parts[1]).execute();
            }
            catch (IOException ex) {
                if (ex.getMessage().contains("was not found")) {
                    MachineImage machineImage = null;
                    APITrace.end();
                    return machineImage;
                }
                logger.error((Object)("An error occurred while getting image: " + providerImageId + ": " + ex.getMessage()));
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException(ex.getMessage());
            }
            MachineImage machineImage = this.toMachineImage(image);
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        ArrayList<ResourceStatus> status = new ArrayList<ResourceStatus>();
        Iterable images = this.listImages(cls);
        for (MachineImage image : images) {
            MachineImageState state = image.getCurrentState();
            ResourceStatus resStatus = new ResourceStatus(image.getProviderMachineImageId(), (Object)state);
            status.add(resStatus);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> listImages(ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImages");
        try {
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            try {
                Compute gce = this.provider.getGoogleCompute();
                ImageList imgList = (ImageList)gce.images().list(this.provider.getContext().getAccountNumber()).execute();
                if (imgList.getItems() != null) {
                    for (Image img : imgList.getItems()) {
                        MachineImage image = this.toMachineImage(img);
                        if (image == null) continue;
                        images.add(image);
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)("An error occurred while listing images: " + ex.getMessage()));
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException(ex.getMessage());
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImages() throws CloudException, InternalException {
        return this.listImages(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(String accountId) throws CloudException, InternalException {
        return this.listImages(ImageClass.MACHINE, accountId);
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String providerImageId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public MachineImage registerImageBundle(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support bundling images");
    }

    public void remove(@Nonnull String providerImageId) throws CloudException, InternalException {
        this.remove(providerImageId, false);
    }

    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        Operation job = null;
        try {
            MachineImage image = this.getImage(providerImageId);
            if (null == image || null == image.getCurrentState()) {
                throw new CloudException("Image " + providerImageId + " does not exist.");
            }
            if (image.getCurrentState().equals((Object)MachineImageState.ACTIVE)) {
                job = (Operation)gce.images().delete(this.provider.getContext().getAccountNumber(), image.getName()).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "");
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                if (gjre.getStatusCode() == 503 && gjre.getStatusMessage().contains("backendError")) {
                    throw new CloudException("Due to a GCE error, you will need to start your task again. If the problem persists, please contact support.");
                }
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while deleting the image: " + ex.getMessage());
        }
    }

    public void removeAllImageShares(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not supported in GCE");
    }

    public void removeImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not supported in GCE");
    }

    public void removePublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not supported in GCE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchImages(String accountNumber, String keyword, Platform platform, Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.searchImages");
        ArrayList<MachineImage> results = new ArrayList<MachineImage>();
        if (architecture != null && architecture != Architecture.I64) {
            return results;
        }
        try {
            ArrayList images = new ArrayList();
            if (accountNumber == null) {
                images.addAll((Collection)this.searchPublicImages(ImageFilterOptions.getInstance()));
            }
            logger.error((Object)"******************* searchImages 268");
            images.addAll((Collection)this.listImages(ImageFilterOptions.getInstance()));
            for (MachineImage image : images) {
                Platform p;
                if (image == null || keyword != null && !image.getProviderMachineImageId().contains(keyword) && !image.getName().contains(keyword) && !image.getDescription().contains(keyword) || platform != null && !platform.equals((Object)(p = image.getPlatform())) && (!platform.isWindows() ? !platform.equals((Object)Platform.UNIX) || !p.isUnix() : !p.isWindows())) continue;
                if (architecture != null && architecture != image.getArchitecture()) continue;
                results.add(image);
            }
            ArrayList<MachineImage> arrayList = results;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    private boolean imageMatches(MachineImage image, Pattern pattern, String regex) {
        Matcher nameMatcher = pattern.matcher(image.getName());
        if (nameMatcher.matches()) {
            return true;
        }
        Matcher descriptionMatcher = pattern.matcher(image.getDescription());
        if (descriptionMatcher.matches()) {
            return true;
        }
        Map tags = image.getTags();
        for (String key : tags.keySet()) {
            Matcher tagMatcher = pattern.matcher((CharSequence)tags.get(key));
            if (!tagMatcher.matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nonnull ImageFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.searchPublicImages");
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        if (options.getArchitecture() != null && options.getArchitecture() != Architecture.I64) {
            return images;
        }
        Pattern pattern = null;
        if (options.getRegex() != null) {
            pattern = Pattern.compile(options.getRegex());
        }
        try {
            try {
                Compute gce = this.provider.getGoogleCompute();
                Platform platform = options.getPlatform();
                if (platform != null) {
                    String imageProject = ImageProject.getImageProject(platform);
                    ImageList imgList = (ImageList)gce.images().list(imageProject).execute();
                    if (imgList != null && imgList.getItems() != null) {
                        for (Image img : imgList.getItems()) {
                            MachineImage image = this.toMachineImage(img);
                            if (image == null || options.getRegex() != null && !this.imageMatches(image, pattern, options.getRegex())) continue;
                            images.add(image);
                        }
                    }
                } else {
                    for (ImageProject imageProject : ImageProject.values()) {
                        try {
                            ImageList imgList = (ImageList)gce.images().list(imageProject.projectName).execute();
                            if (imgList == null || imgList.getItems() == null) continue;
                            for (Image img : imgList.getItems()) {
                                MachineImage image = this.toMachineImage(img);
                                if (image == null || options.getRegex() != null && !this.imageMatches(image, pattern, options.getRegex())) continue;
                                images.add(image);
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void updateTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google image does not have meta data");
    }

    public void updateTags(@Nonnull String[] imageIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google image does not have meta data");
    }

    public void removeTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google image does not have meta data");
    }

    public void removeTags(@Nonnull String[] imageIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google image does not have meta data");
    }

    private MachineImage toMachineImage(Image img) {
        if (img.getDeprecated() != null && (img.getDeprecated().getState().equals("DELETED") || img.getDeprecated().getState().equals("DEPRECATED"))) {
            return null;
        }
        String imageStatus = img.getStatus();
        MachineImageState state = null;
        if (imageStatus.equalsIgnoreCase("READY")) {
            state = MachineImageState.ACTIVE;
        } else if (imageStatus.equalsIgnoreCase("PENDING")) {
            state = MachineImageState.PENDING;
        } else {
            return null;
        }
        Architecture arch = Architecture.I64;
        Platform platform = Platform.guess((String)img.getName());
        if (platform == Platform.UNKNOWN) {
            platform = Platform.guess((String)img.getDescription());
        }
        String project = "";
        Pattern p = Pattern.compile("/projects/(.*?)/");
        Matcher m = p.matcher(img.getSelfLink());
        if (m.find()) {
            project = m.group(1);
        }
        String owner = this.provider.getCloudName();
        if (project.equals(this.provider.getContext().getAccountNumber())) {
            owner = this.provider.getContext().getAccountNumber();
        }
        String description = null;
        description = img.getDescription() != null ? img.getDescription() : "Image Name: " + img.getName();
        MachineImage image = MachineImage.getImageInstance((String)owner, (String)"", (String)(project + "_" + img.getName()), (ImageClass)ImageClass.MACHINE, (MachineImageState)state, (String)img.getName(), (String)description, (Architecture)arch, (Platform)platform, (MachineImageFormat)MachineImageFormat.RAW, (VisibleScope)VisibleScope.ACCOUNT_GLOBAL);
        if (owner.equals("GCE")) {
            image = image.sharedWithPublic();
        }
        image.setTag("contentLink", img.getSelfLink());
        image.setTag("project", project);
        String size = null;
        try {
            size = img.get((Object)"diskSizeGb").toString();
            Long s = (long)Long.valueOf(size);
            image.setMinimumDiskSizeGb(s.longValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        return image;
    }

    public MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        ServerSupport server = new ServerSupport(this.provider);
        Image imageContent = new Image();
        try {
            VirtualMachine vm = server.getVirtualMachine(options.getVirtualMachineId());
            String[] disks = vm.getProviderVolumeIds((CloudProvider)this.provider);
            server.terminateVm(options.getVirtualMachineId());
            Disk disk = (Disk)gce.disks().get(this.provider.getContext().getAccountNumber(), vm.getProviderDataCenterId(), disks[0]).execute();
            imageContent.setName(this.getCapabilities().getImageNamingConstraints().convertToValidName(options.getName(), Locale.US));
            imageContent.setKind("compute#disk");
            imageContent.setSourceDisk(disk.getSelfLink());
            String derivedFrom = disk.getSourceImage().replaceAll(".*/", "");
            if (Platform.guess((String)derivedFrom) == Platform.UNKNOWN) {
                Boolean done = false;
                try {
                    while (!done.booleanValue()) {
                        Image imagePrior = (Image)gce.images().get(this.provider.getContext().getAccountNumber(), derivedFrom).execute();
                        if (!imagePrior.getDescription().startsWith("Derived from ") || Platform.guess((String)(derivedFrom = imagePrior.getDescription().replaceAll("Derived from ", ""))) == Platform.UNKNOWN) continue;
                        done = true;
                        imageContent.setDescription(imagePrior.getDescription());
                    }
                }
                catch (Exception e) {
                    imageContent.setDescription(derivedFrom);
                }
            } else {
                imageContent.setDescription("Derived from " + derivedFrom);
            }
            Operation job = (Operation)gce.images().insert(this.provider.getContext().getAccountNumber(), imageContent).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "");
            String zone = disk.getZone();
            zone = zone.substring(zone.lastIndexOf("/") + 1);
            job = (Operation)gce.disks().delete(this.provider.getContext().getAccountNumber(), zone, disk.getName()).execute();
            method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", zone);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while deleting the image: " + ex.getMessage());
        }
        return this.getImage(this.provider.getContext().getAccountNumber() + "_" + options.getName());
    }

    private static enum ImageProject {
        DEBIAN(Platform.DEBIAN, "debian-cloud"),
        CENT_OS(Platform.CENT_OS, "centos-cloud"),
        COREOS(Platform.COREOS, "coreos-cloud"),
        RHEL(Platform.RHEL, "rhel-cloud"),
        SUSE(Platform.SUSE, "suse-cloud"),
        UBUNTU(Platform.UBUNTU, "ubuntu-os-cloud"),
        WINDOWS(Platform.WINDOWS, "windows-cloud"),
        GOOGLE(null, "google");

        private Platform platform;
        private String projectName;

        private ImageProject(Platform platform, String projectName) {
            this.platform = platform;
            this.projectName = projectName;
        }

        public static String getImageProject(Platform platform) {
            for (ImageProject imgProject : ImageProject.values()) {
                if (platform == null || !platform.equals((Object)imgProject.platform)) continue;
                return imgProject.projectName;
            }
            return ImageProject.GOOGLE.projectName;
        }
    }
}

