/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.compute.server;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.replicapool.Replicapool;
import com.google.api.services.replicapool.model.InstanceGroupManager;
import com.google.api.services.replicapool.model.InstanceGroupManagerList;
import com.google.api.services.replicapool.model.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ci.AbstractConvergedInfrastructureSupport;
import org.dasein.cloud.ci.CIFilterOptions;
import org.dasein.cloud.ci.CIProvisionOptions;
import org.dasein.cloud.ci.ConvergedInfrastructure;
import org.dasein.cloud.ci.ConvergedInfrastructureState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEReplicapoolCapabilities;
import org.dasein.cloud.util.APITrace;

public class ReplicapoolSupport
extends AbstractConvergedInfrastructureSupport<Google> {
    private static final Logger logger = Google.getLogger(ReplicapoolSupport.class);
    private Google provider = null;
    private volatile transient GCEReplicapoolCapabilities capabilities;

    public ReplicapoolSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"GoogleConvergedInfrastructure.isSubscribed");
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public GCEReplicapoolCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GCEReplicapoolCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ConvergedInfrastructure> listConvergedInfrastructures(CIFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"GoogleConvergedInfrastructure.listConvergedInfrastructures");
        ArrayList<ConvergedInfrastructure> convergedInfrastrutures = new ArrayList<ConvergedInfrastructure>();
        try {
            Replicapool rp = this.provider.getGoogleReplicapool();
            InstanceGroupManagerList result = null;
            try {
                for (Region region : this.provider.getDataCenterServices().listRegions()) {
                    String regionName = region.getProviderRegionId();
                    for (DataCenter dataCenter : this.provider.getDataCenterServices().listDataCenters(regionName)) {
                        String dataCenterId = dataCenter.getProviderDataCenterId();
                        result = (InstanceGroupManagerList)rp.instanceGroupManagers().list(this.provider.getContext().getAccountNumber(), dataCenterId).execute();
                        if (null == result.getItems()) continue;
                        for (InstanceGroupManager item : result.getItems()) {
                            ConvergedInfrastructure ci = ConvergedInfrastructure.getInstance((String)this.provider.getContext().getAccountNumber(), (String)regionName, (String)dataCenterId, (String)item.getId().toString(), (ConvergedInfrastructureState)ConvergedInfrastructureState.RUNNING, (String)item.getName(), (String)item.getDescription(), (String)item.getSelfLink());
                            convergedInfrastrutures.add(ci);
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            APITrace.end();
        }
        return convergedInfrastrutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> listVirtualMachines(String inCIId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"GoogleConvergedInfrastructure.listVirtualMachines");
        ArrayList<String> vms = new ArrayList<String>();
        try {
            Replicapool rp = this.provider.getGoogleReplicapool();
            Compute gce = this.provider.getGoogleCompute();
            InstanceGroupManager pool = (InstanceGroupManager)rp.instanceGroupManagers().get(this.provider.getContext().getAccountNumber(), "us-central1-f", inCIId).execute();
            String baseInstanceName = pool.getBaseInstanceName();
            InstanceList result = (InstanceList)gce.instances().list(this.provider.getContext().getAccountNumber(), "us-central1-f").execute();
            for (Instance instance : result.getItems()) {
                if (!instance.getName().startsWith(baseInstanceName + "-")) continue;
                vms.add(instance.getName());
            }
            ArrayList<String> arrayList = vms;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            APITrace.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> listVLANs(String inCIId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"GoogleConvergedInfrastructure.listVLANs");
        ArrayList<String> nets = new ArrayList<String>();
        try {
            Replicapool rp = this.provider.getGoogleReplicapool();
            Compute gce = this.provider.getGoogleCompute();
            InstanceGroupManager pool = (InstanceGroupManager)rp.instanceGroupManagers().get(this.provider.getContext().getAccountNumber(), "us-central1-f", inCIId).execute();
            String baseInstanceName = pool.getBaseInstanceName();
            InstanceList result = (InstanceList)gce.instances().list(this.provider.getContext().getAccountNumber(), "us-central1-f").execute();
            for (Instance instance : result.getItems()) {
                if (!instance.getName().startsWith(baseInstanceName + "-") || null == instance.getNetworkInterfaces()) continue;
                for (NetworkInterface net : instance.getNetworkInterfaces()) {
                    nets.add(net.getNetwork().replaceAll(".*/", ""));
                }
            }
            ArrayList<String> arrayList = nets;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            APITrace.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvergedInfrastructure provision(CIProvisionOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"GoogleConvergedInfrastructure.provision");
        Replicapool rp = this.provider.getGoogleReplicapool();
        try {
            ProviderContext ctx = this.provider.getContext();
            InstanceGroupManager content = new InstanceGroupManager();
            content.setBaseInstanceName(this.getCapabilities().getConvergedInfrastructureNamingConstraints().convertToValidName(options.getBaseInstanceName(), Locale.US));
            content.setDescription(options.getDescription());
            content.setInstanceTemplate("https://www.googleapis.com/compute/v1/projects/" + ctx.getAccountNumber() + "/global/instanceTemplates/" + options.getInstanceTemplate());
            content.setName(this.getCapabilities().getConvergedInfrastructureNamingConstraints().convertToValidName(options.getName(), Locale.US));
            String region = options.getZone().replaceFirst("-.$", "");
            Operation job = (Operation)rp.instanceGroupManagers().insert(ctx.getAccountNumber(), options.getZone(), options.getSize(), content).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            method.getCIOperationComplete(ctx, job, GoogleOperationType.ZONE_OPERATION, region, options.getZone());
            ConvergedInfrastructure convergedInfrastructure = ConvergedInfrastructure.getInstance((String)ctx.getAccountNumber(), (String)region, (String)options.getZone(), (String)options.getBaseInstanceName(), (ConvergedInfrastructureState)ConvergedInfrastructureState.RUNNING, (String)options.getName(), (String)options.getDescription(), (String)options.getInstanceTemplate());
            return convergedInfrastructure;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            APITrace.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(String ciId, String explanation) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"GoogleConvergedInfrastructure.terminate");
        ProviderContext ctx = this.provider.getContext();
        try {
            Replicapool rp = this.provider.getGoogleReplicapool();
            for (ConvergedInfrastructure ci : this.listConvergedInfrastructures(null)) {
                if (!ci.getName().equals(ciId)) continue;
                Operation job = (Operation)rp.instanceGroupManagers().delete(this.provider.getContext().getAccountNumber(), ci.getProviderDataCenterId(), ciId).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                method.getCIOperationComplete(ctx, job, GoogleOperationType.ZONE_OPERATION, "us-central1", ci.getProviderDataCenterId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            APITrace.end();
        }
    }

    public boolean hasConvergedHttpLoadBalancerSupport() {
        return true;
    }
}

