/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.compute.server;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstancesScopedList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.MachineTypesScopedList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.api.services.compute.model.Tags;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMFilterOptions;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeAttachment;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEInstanceCapabilities;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ServerSupport
extends AbstractVMSupport<Google> {
    private Google provider;
    private static final Logger logger = Google.getLogger(ServerSupport.class);
    private Cache<MachineTypeAggregatedList> machineTypesCache;
    private volatile transient GCEInstanceCapabilities capabilities;

    public ServerSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
        this.machineTypesCache = Cache.getInstance((CloudProvider)provider, (String)"MachineTypes", MachineTypeAggregatedList.class, (CacheLevel)CacheLevel.CLOUD, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
    }

    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support altering of existing instances.");
    }

    public VirtualMachine modifyInstance(@Nonnull String vmId, @Nonnull String[] firewalls) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support altering of existing instances.");
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String vmId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support cloning of instances via the API.");
    }

    public void disableAnalytics(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not currently support analytics.");
    }

    public void enableAnalytics(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not currently support analytics.");
    }

    @Nonnull
    public GCEInstanceCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GCEInstanceCapabilities(this.provider);
        }
        return this.capabilities;
    }

    public String getPassword(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE instances do not have passwords");
    }

    @Nonnull
    public String getVmNameFromId(String vmId) throws InternalException, CloudException {
        if (null == vmId) {
            throw new InternalException("vmId cannot be null");
        }
        if (vmId.contains("_")) {
            String[] parts = vmId.split("_");
            if (null == parts[0]) {
                throw new InternalException("vmId cannot begin with '_'");
            }
            return parts[0];
        }
        return vmId;
    }

    @Nonnull
    public String getVmIdFromName(String vmName) throws InternalException, CloudException {
        if (null == vmName) {
            throw new InternalException("vmName cannot be null ");
        }
        VirtualMachine vm = this.getVirtualMachine(vmName);
        if (null != vm && null != vm.getProviderVirtualMachineId()) {
            return vm.getProviderVirtualMachineId();
        }
        throw new CloudException("Unable to lookup vmId for vm named: " + vmName);
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String vmId) throws InternalException, CloudException {
        try {
            for (VirtualMachine vm : this.listVirtualMachines()) {
                if (!vm.getProviderVirtualMachineId().equalsIgnoreCase(vmId)) continue;
                Compute gce = this.provider.getGoogleCompute();
                SerialPortOutput output = (SerialPortOutput)gce.instances().getSerialPortOutput(this.provider.getContext().getAccountNumber(), vm.getProviderDataCenterId(), this.getVmNameFromId(vmId)).execute();
                return output.getContents();
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred when getting console output for VM: " + vmId + ": " + ex.getMessage());
        }
        throw new InternalException("The Virtual Machine: " + vmId + " could not be found.");
    }

    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        try {
            MachineTypeList types;
            Compute gce = this.provider.getGoogleCompute();
            String[] parts = productId.split("\\+");
            if (parts != null && parts.length > 1 && null != (types = (MachineTypeList)gce.machineTypes().list(this.provider.getContext().getAccountNumber(), parts[1]).setFilter("name eq " + parts[0]).execute()) && null != types.getItems()) {
                for (MachineType type : types.getItems()) {
                    if (!parts[0].equals(type.getName())) continue;
                    return this.toProduct(type);
                }
            }
            return null;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred retrieving the product: " + productId + ": " + ex.getMessage());
        }
    }

    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"getVirtualMachine");
        try {
            Compute gce = this.provider.getGoogleCompute();
            InstanceAggregatedList instances = (InstanceAggregatedList)gce.instances().aggregatedList(this.provider.getContext().getAccountNumber()).setFilter("name eq " + this.getVmNameFromId(vmId)).execute();
            for (String zone : instances.getItems().keySet()) {
                if (instances.getItems() == null || instances.getItems().get(zone) == null || ((InstancesScopedList)instances.getItems().get(zone)).getInstances() == null) continue;
                for (Instance instance : ((InstancesScopedList)instances.getItems().get(zone)).getInstances()) {
                    if (!instance.getName().equals(this.getVmNameFromId(vmId))) continue;
                    VirtualMachine virtualMachine = this.toVirtualMachine(instance);
                    return virtualMachine;
                }
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred retrieving VM: " + vmId + ": " + ex.getMessage());
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        this.listVirtualMachines();
        return true;
    }

    public void validateLaunchOptions(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        if (withLaunchOptions.getDataCenterId() == null || withLaunchOptions.getDataCenterId().equals("")) {
            throw new InternalException("A datacenter must be specified when launching an instance");
        }
        if (withLaunchOptions.getMachineImageId() == null || withLaunchOptions.getMachineImageId().equals("")) {
            throw new InternalException("A MachineImage must be specified when launching an instance");
        }
        if (withLaunchOptions.getHostName() == null || withLaunchOptions.getHostName().equals("")) {
            throw new InternalException("A hostname must be specified when launching an instance");
        }
        if (withLaunchOptions.getVlanId() == null || withLaunchOptions.getVlanId().equals("")) {
            throw new InternalException("A vlan must be specified when launching an instance");
        }
        VLAN vlan = this.provider.getNetworkServices().getVlanSupport().getVlan(withLaunchOptions.getVlanId());
        if (null == vlan || null == vlan.getTag("contentLink")) {
            throw new InternalException("Problem getting Vlan for " + withLaunchOptions.getVlanId());
        }
        String hostName = this.getCapabilities().getVirtualMachineNamingConstraints().convertToValidName(withLaunchOptions.getHostName(), Locale.US);
        if (null != this.provider.getComputeServices().getVolumeSupport().getVolume(hostName)) {
            throw new InternalException("Root disk " + hostName + " already exists.");
        }
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"launchVM");
        this.validateLaunchOptions(withLaunchOptions);
        try {
            Compute gce = this.provider.getGoogleCompute();
            GoogleMethod method = new GoogleMethod(this.provider);
            String hostName = this.getCapabilities().getVirtualMachineNamingConstraints().convertToValidName(withLaunchOptions.getHostName(), Locale.US);
            Instance instance = new Instance();
            instance.setName(hostName);
            instance.setDescription(withLaunchOptions.getDescription());
            if (withLaunchOptions.getStandardProductId().contains("+")) {
                instance.setMachineType(this.getProduct(withLaunchOptions.getStandardProductId()).getDescription());
            } else {
                instance.setMachineType(this.getProduct(withLaunchOptions.getStandardProductId() + "+" + withLaunchOptions.getDataCenterId()).getDescription());
            }
            MachineImage image = this.provider.getComputeServices().getImageSupport().getImage(withLaunchOptions.getMachineImageId());
            AttachedDisk rootVolume = new AttachedDisk();
            rootVolume.setBoot(Boolean.TRUE);
            rootVolume.setType("PERSISTENT");
            rootVolume.setMode("READ_WRITE");
            AttachedDiskInitializeParams params = new AttachedDiskInitializeParams();
            params.setDiskName(hostName);
            try {
                String[] parts = withLaunchOptions.getMachineImageId().split("_");
                Image img = (Image)gce.images().get(parts[0], parts[1]).execute();
                Long size = img.getDiskSizeGb();
                String diskSizeGb = size.toString();
                if (null == diskSizeGb) {
                    diskSizeGb = img.getUnknownKeys().get("diskSizeGb").toString();
                }
                Long MinimumDiskSizeGb = (long)Long.valueOf(diskSizeGb);
                params.setDiskSizeGb(MinimumDiskSizeGb);
            }
            catch (Exception e) {
                params.setDiskSizeGb(Long.valueOf(10L));
            }
            if (image == null || image.getTag("contentLink") == null) {
                throw new CloudException("Problem getting the contentLink tag value from the image for " + withLaunchOptions.getMachineImageId());
            }
            params.setSourceImage((String)image.getTag("contentLink"));
            rootVolume.setInitializeParams(params);
            ArrayList<AttachedDisk> attachedDisks = new ArrayList<AttachedDisk>();
            attachedDisks.add(rootVolume);
            if (withLaunchOptions.getVolumes().length > 0) {
                for (VolumeAttachment volume : withLaunchOptions.getVolumes()) {
                    AttachedDisk vol = new AttachedDisk();
                    vol.setBoot(Boolean.FALSE);
                    vol.setType("PERSISTENT");
                    vol.setMode("READ_WRITE");
                    vol.setAutoDelete(Boolean.FALSE);
                    vol.setKind("compute#attachedDisk");
                    if (null != volume.getExistingVolumeId()) {
                        vol.setDeviceName(volume.getExistingVolumeId());
                        vol.setSource(this.provider.getComputeServices().getVolumeSupport().getVolume(volume.getExistingVolumeId()).getMediaLink());
                    } else {
                        VolumeCreateOptions volumeOptions = volume.getVolumeToCreate();
                        volumeOptions.setDataCenterId(withLaunchOptions.getDataCenterId());
                        String newDisk = this.provider.getComputeServices().getVolumeSupport().createVolume(volume.getVolumeToCreate());
                        vol.setDeviceName(newDisk);
                        vol.setSource(this.provider.getComputeServices().getVolumeSupport().getVolume(newDisk).getMediaLink());
                    }
                    attachedDisks.add(vol);
                }
            }
            instance.setDisks(attachedDisks);
            AccessConfig nicConfig = new AccessConfig();
            nicConfig.setName("External NAT");
            nicConfig.setType("ONE_TO_ONE_NAT");
            if (withLaunchOptions.getStaticIpIds().length > 0) {
                nicConfig.setNatIP(withLaunchOptions.getStaticIpIds()[0]);
            }
            ArrayList<AccessConfig> accessConfigs = new ArrayList<AccessConfig>();
            accessConfigs.add(nicConfig);
            NetworkInterface nic = new NetworkInterface();
            nic.setName("nic0");
            if (null != withLaunchOptions.getVlanId()) {
                VLAN vlan = this.provider.getNetworkServices().getVlanSupport().getVlan(withLaunchOptions.getVlanId());
                nic.setNetwork(vlan.getTag("contentLink"));
            } else {
                nic.setNetwork(this.provider.getNetworkServices().getVlanSupport().getVlan("default").getTag("contentLink"));
            }
            nic.setAccessConfigs(accessConfigs);
            ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>();
            nics.add(nic);
            instance.setNetworkInterfaces(nics);
            instance.setCanIpForward(Boolean.FALSE);
            Scheduling scheduling = new Scheduling();
            scheduling.setAutomaticRestart(Boolean.TRUE);
            scheduling.setOnHostMaintenance("TERMINATE");
            instance.setScheduling(scheduling);
            HashMap<String, String> keyValues = new HashMap<String, String>();
            if (withLaunchOptions.getBootstrapUser() != null && withLaunchOptions.getBootstrapKey() != null && !withLaunchOptions.getBootstrapUser().equals("") && !withLaunchOptions.getBootstrapKey().equals("")) {
                keyValues.put("sshKeys", withLaunchOptions.getBootstrapUser() + ":" + withLaunchOptions.getBootstrapKey());
            }
            if (!withLaunchOptions.getMetaData().isEmpty()) {
                for (Map.Entry entry : withLaunchOptions.getMetaData().entrySet()) {
                    keyValues.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!keyValues.isEmpty()) {
                Metadata metadata = new Metadata();
                ArrayList<Metadata.Items> items = new ArrayList<Metadata.Items>();
                for (Map.Entry entry : keyValues.entrySet()) {
                    Metadata.Items item = new Metadata.Items();
                    item.set("key", entry.getKey());
                    if (entry.getValue() == null || ((String)entry.getValue()).isEmpty() || ((String)entry.getValue()).equals("")) {
                        item.set("value", (Object)"");
                    } else {
                        item.set("value", entry.getValue());
                    }
                    items.add(item);
                }
                if (null != withLaunchOptions.getUserData()) {
                    Metadata.Items item = new Metadata.Items();
                    item.set("key", (Object)"startup-script");
                    item.set("value", (Object)withLaunchOptions.getUserData());
                    items.add(item);
                }
                metadata.setItems(items);
                instance.setMetadata(metadata);
            }
            Tags tags = new Tags();
            ArrayList<String> tagItems = new ArrayList<String>();
            tagItems.add(hostName);
            tags.setItems(tagItems);
            instance.setTags(tags);
            String vmId = "";
            try {
                Operation job = (Operation)gce.instances().insert(this.provider.getContext().getAccountNumber(), withLaunchOptions.getDataCenterId(), instance).execute();
                vmId = method.getOperationTarget(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", withLaunchOptions.getDataCenterId(), false);
            }
            catch (IOException ex) {
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred launching the instance: " + ex.getMessage());
            }
            catch (Exception e) {
                if (e.getMessage().contains("The resource") && e.getMessage().contains("disks") && e.getMessage().contains("already exists")) {
                    throw new CloudException("A disk named '" + withLaunchOptions.getFriendlyName() + "' already exists.");
                }
                throw new CloudException((Throwable)e);
            }
            if (!vmId.equals("")) {
                VirtualMachine vm = this.getVirtualMachine(vmId);
                if (withLaunchOptions.getMachineImageId().toLowerCase().contains("windows")) {
                    KeyPair keys = null;
                    try {
                        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                        keyGen.initialize(2048);
                        keys = keyGen.genKeyPair();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new InternalException((Throwable)e);
                    }
                    this.resetPassword(vmId, withLaunchOptions.getDataCenterId(), keys);
                    int retryCount = 20;
                    while (retryCount-- > 0) {
                        SerialPortOutput output = null;
                        try {
                            output = (SerialPortOutput)gce.instances().getSerialPortOutput(this.provider.getContext().getAccountNumber(), withLaunchOptions.getDataCenterId(), vmId).setPort(Integer.valueOf(4)).execute();
                        }
                        catch (IOException e) {
                            throw new CloudException((Throwable)e);
                        }
                        System.out.println(output);
                        String[] entries = output.getContents().split("\n");
                        String outputEntry = entries[entries.length - 1];
                        JSONParser parser = new JSONParser();
                        try {
                            JSONObject passwordDict = (JSONObject)parser.parse(outputEntry);
                            vm.setRootUser(passwordDict.get((Object)"userName").toString());
                            vm.setRootPassword(this.decryptPassword(passwordDict.get((Object)"encryptedPassword").toString(), keys));
                            break;
                        }
                        catch (Exception e) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e2) {}
                        }
                    }
                }
                VirtualMachine virtualMachine = vm;
                return virtualMachine;
            }
            throw new CloudException("Could not find the instance: " + withLaunchOptions.getFriendlyName() + " after launch.");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        ArrayList<String> firewalls = new ArrayList<String>();
        for (Firewall firewall : this.provider.getNetworkServices().getFirewallSupport().list()) {
            for (String key : firewall.getTags().keySet()) {
                if (!((String)firewall.getTags().get(key)).equals(this.getVmNameFromId(vmId))) continue;
                firewalls.add(firewall.getName());
            }
        }
        return firewalls;
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture, String preferredDataCenterId) throws InternalException, CloudException {
        MachineTypeAggregatedList machineTypes = null;
        Compute gce = this.provider.getGoogleCompute();
        Iterable machineTypesCachedList = this.machineTypesCache.get(this.provider.getContext());
        if (machineTypesCachedList != null) {
            Iterator machineTypesCachedListIterator = machineTypesCachedList.iterator();
            if (machineTypesCachedListIterator.hasNext()) {
                machineTypes = (MachineTypeAggregatedList)machineTypesCachedListIterator.next();
            }
        } else {
            try {
                machineTypes = (MachineTypeAggregatedList)gce.machineTypes().aggregatedList(this.provider.getContext().getAccountNumber()).execute();
                this.machineTypesCache.put(this.provider.getContext(), Arrays.asList(machineTypes));
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred listing VM products.");
            }
        }
        ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
        for (Object dataCenterId : machineTypes.getItems().keySet()) {
            if (preferredDataCenterId != null && !dataCenterId.toString().endsWith(preferredDataCenterId)) continue;
            for (MachineType type : ((MachineTypesScopedList)machineTypes.getItems().get(dataCenterId)).getMachineTypes()) {
                if (preferredDataCenterId != null && !type.getZone().equals(preferredDataCenterId)) continue;
                VirtualMachineProduct product = this.toProduct(type);
                products.add(product);
            }
        }
        return products;
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull String machineImageId, @Nonnull VirtualMachineProductFilterOptions options) throws InternalException, CloudException {
        ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
        Iterable<VirtualMachineProduct> candidateProduct = this.listProducts(options, null);
        for (VirtualMachineProduct product : candidateProduct) {
            if (options != null && !options.matches(product)) continue;
            products.add(product);
        }
        return products;
    }

    public Iterable<VirtualMachineProduct> listProducts(VirtualMachineProductFilterOptions options, Architecture architecture) throws InternalException, CloudException {
        if (architecture == null || Architecture.I64 == architecture) {
            String dataCenterId = null;
            if (options != null) {
                dataCenterId = options.getDataCenterId();
            }
            Iterable<VirtualMachineProduct> result = this.listProducts(Architecture.I64, dataCenterId);
            return result;
        }
        return new ArrayList<VirtualMachineProduct>();
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines(VMFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"listVirtualMachines");
        try {
            ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
            Compute gce = this.provider.getGoogleCompute();
            InstanceAggregatedList instances = (InstanceAggregatedList)gce.instances().aggregatedList(this.provider.getContext().getAccountNumber()).execute();
            for (String zone : instances.getItems().keySet()) {
                if (!this.getContext().getRegionId().equals(this.provider.getDataCenterServices().getRegionFromZone(zone)) || instances.getItems() == null || instances.getItems().get(zone) == null || ((InstancesScopedList)instances.getItems().get(zone)).getInstances() == null) continue;
                for (Instance instance : ((InstancesScopedList)instances.getItems().get(zone)).getInstances()) {
                    VirtualMachine vm = this.toVirtualMachine(instance);
                    if (options != null && !options.matches(vm)) continue;
                    vms.add(vm);
                }
            }
            ArrayList<VirtualMachine> arrayList = vms;
            return arrayList;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while listing Virtual Machines.");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        VMFilterOptions options = VMFilterOptions.getInstance();
        return this.listVirtualMachines(options);
    }

    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        ArrayList<ResourceStatus> vmStatuses = new ArrayList<ResourceStatus>();
        for (VirtualMachine vm : this.listVirtualMachines()) {
            ResourceStatus status = new ResourceStatus(vm.getProviderVirtualMachineId(), (Object)vm.getCurrentState());
            vmStatuses.add(status);
        }
        return vmStatuses;
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support pausing vms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"rebootVM");
        try {
            try {
                Operation job = null;
                String zone = null;
                for (VirtualMachine vm : this.listVirtualMachines()) {
                    if (!vm.getProviderVirtualMachineId().equalsIgnoreCase(vmId)) continue;
                    zone = vm.getProviderDataCenterId();
                    Compute gce = this.provider.getGoogleCompute();
                    job = (Operation)gce.instances().reset(this.provider.getContext().getAccountNumber(), vm.getProviderDataCenterId(), this.getVmNameFromId(vmId)).execute();
                    break;
                }
                if (job != null) {
                    GoogleMethod method = new GoogleMethod(this.provider);
                    method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, null, zone);
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while rebooting VM: " + vmId + ": " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE does not support suspend/resume of instances.");
    }

    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE does not support suspend/resume of instances.");
    }

    public void start(@Nonnull String vmId) throws InternalException, CloudException {
        Compute gce = this.provider.getGoogleCompute();
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            gce.instances().start(this.provider.getContext().getAccountNumber(), vm.getProviderDataCenterId(), this.getVmNameFromId(vmId)).execute();
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while rebooting VM: " + vmId + ": " + ex.getMessage());
        }
    }

    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        Compute gce = this.provider.getGoogleCompute();
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            gce.instances().stop(this.provider.getContext().getAccountNumber(), vm.getProviderDataCenterId(), this.getVmNameFromId(vmId)).execute();
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while rebooting VM: " + vmId + ": " + ex.getMessage());
        }
    }

    public void terminate(@Nonnull String vmId) throws InternalException, CloudException {
        VirtualMachine vm = this.getVirtualMachine(vmId);
        this.terminateVm(vmId);
        this.terminateVmDisk(this.getVmNameFromId(vmId), vm.getProviderDataCenterId());
    }

    public void terminate(@Nonnull String vmId, String reason) throws InternalException, CloudException {
        VirtualMachine vm = this.getVirtualMachine(vmId);
        this.terminateVm(vmId, null);
        this.terminateVmDisk(vmId, vm.getProviderDataCenterId());
    }

    public void terminateVm(@Nonnull String vmId) throws InternalException, CloudException {
        this.terminateVm(vmId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateVm(@Nonnull String vmId, String reason) throws InternalException, CloudException {
        try {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"terminateVM");
            Operation job = null;
            GoogleMethod method = null;
            String zone = null;
            Compute gce = this.provider.getGoogleCompute();
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (null == vm) {
                throw new CloudException("Virtual Machine " + vmId + " was not found.");
            }
            try {
                zone = vm.getProviderDataCenterId();
                job = (Operation)gce.instances().delete(this.provider.getContext().getAccountNumber(), zone, this.getVmNameFromId(vmId)).execute();
                if (job != null && !(method = new GoogleMethod(this.provider)).getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, null, zone)) {
                    throw new CloudException("An error occurred while terminating the VM. Note: The root disk might also still exist");
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while terminating VM: " + vmId + ": " + ex.getMessage());
            }
            catch (Exception ex) {
                throw new CloudException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateVmDisk(@Nonnull String diskName, String zone) throws InternalException, CloudException {
        block8: {
            try {
                APITrace.begin((CloudProvider)this.getProvider(), (String)"terminateVM");
                try {
                    Compute gce = this.provider.getGoogleCompute();
                    Operation job = (Operation)gce.disks().delete(this.provider.getContext().getAccountNumber(), zone, diskName).execute();
                    GoogleMethod method = new GoogleMethod(this.provider);
                    method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, null, zone);
                }
                catch (IOException ex) {
                    if (ex.getClass() == GoogleJsonResponseException.class) {
                        GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                        if (404 == gjre.getStatusCode() && gjre.getStatusMessage().equals("Not Found")) {
                            break block8;
                        }
                        throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                    }
                    throw new CloudException("An error occurred while deleting VM disk: " + diskName + ": " + ex.getMessage());
                }
                catch (Exception ex) {
                    throw new CloudException((Throwable)ex);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    public void unpause(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE does not support unpausing vms.");
    }

    public void updateTags(String vmId, Tag ... tags) throws CloudException, InternalException {
        this.updateTags(new String[]{vmId}, tags);
    }

    public void updateTags(String[] vmIds, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(String vmId, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support removing meta data from vms");
    }

    public void removeTags(String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support removing meta data from vms");
    }

    private VirtualMachine toVirtualMachine(Instance instance) throws InternalException, CloudException {
        VirtualMachine vm = new VirtualMachine();
        vm.setProviderVirtualMachineId(instance.getName() + "_" + instance.getId().toString());
        vm.setName(instance.getName());
        if (instance.getDescription() != null) {
            vm.setDescription(instance.getDescription());
        } else {
            vm.setDescription(instance.getName());
        }
        vm.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        VmState vmState = null;
        vmState = instance.getStatus().equalsIgnoreCase("provisioning") || instance.getStatus().equalsIgnoreCase("staging") ? (null != instance.getStatusMessage() && instance.getStatusMessage().contains("failed") ? VmState.ERROR : VmState.PENDING) : (instance.getStatus().equalsIgnoreCase("stopping") ? VmState.STOPPING : (instance.getStatus().equalsIgnoreCase("terminated") ? VmState.STOPPED : VmState.RUNNING));
        vm.setCurrentState(vmState);
        String regionId = "";
        try {
            regionId = this.provider.getDataCenterServices().getRegionFromZone(instance.getZone().substring(instance.getZone().lastIndexOf("/") + 1));
        }
        catch (Exception ex) {
            logger.error((Object)"An error occurred getting the region for the instance");
            return null;
        }
        vm.setProviderRegionId(regionId);
        String zone = instance.getZone();
        zone = zone.substring(zone.lastIndexOf("/") + 1);
        vm.setProviderDataCenterId(zone);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        DateTime dt = DateTime.parse((String)instance.getCreationTimestamp(), (DateTimeFormatter)fmt);
        vm.setCreationTimestamp(dt.toDate().getTime());
        if (instance.getDisks() != null) {
            for (AttachedDisk disk : instance.getDisks()) {
                if (disk == null || disk.getBoot() == null || !disk.getBoot().booleanValue()) continue;
                String diskName = disk.getSource().substring(disk.getSource().lastIndexOf("/") + 1);
                Compute gce = this.provider.getGoogleCompute();
                try {
                    Disk sourceDisk = (Disk)gce.disks().get(this.provider.getContext().getAccountNumber(), zone, diskName).execute();
                    if (sourceDisk == null || sourceDisk.getSourceImage() == null) continue;
                    String project = "";
                    Pattern p = Pattern.compile("/projects/(.*?)/");
                    Matcher m = p.matcher(sourceDisk.getSourceImage());
                    if (m.find()) {
                        project = m.group(1);
                    }
                    vm.setProviderMachineImageId(project + "_" + sourceDisk.getSourceImage().substring(sourceDisk.getSourceImage().lastIndexOf("/") + 1));
                }
                catch (IOException ex) {
                    logger.error((Object)ex.getMessage());
                    if (ex.getClass() == GoogleJsonResponseException.class) {
                        GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                        throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                    }
                    throw new InternalException("IOException: " + ex.getMessage());
                }
            }
        }
        String machineTypeName = instance.getMachineType().substring(instance.getMachineType().lastIndexOf("/") + 1);
        vm.setProductId(machineTypeName + "+" + zone);
        ArrayList<RawAddress> publicAddresses = new ArrayList<RawAddress>();
        ArrayList<RawAddress> privateAddresses = new ArrayList<RawAddress>();
        boolean firstPass = true;
        boolean isSet = false;
        String providerAssignedIpAddressId = null;
        for (NetworkInterface nic : instance.getNetworkInterfaces()) {
            if (firstPass) {
                vm.setProviderVlanId(nic.getNetwork().substring(nic.getNetwork().lastIndexOf("/") + 1));
                firstPass = false;
            }
            if (nic.getNetworkIP() != null) {
                privateAddresses.add(new RawAddress(nic.getNetworkIP()));
            }
            if (nic.getAccessConfigs() == null || nic.getAccessConfigs().isEmpty()) continue;
            for (AccessConfig accessConfig : nic.getAccessConfigs()) {
                if (accessConfig.getNatIP() == null) continue;
                publicAddresses.add(new RawAddress(accessConfig.getNatIP()));
                if (isSet) continue;
                try {
                    isSet = true;
                    providerAssignedIpAddressId = this.provider.getNetworkServices().getIpAddressSupport().getIpAddressIdFromIP(accessConfig.getNatIP(), regionId);
                }
                catch (InternalException ex) {}
            }
        }
        vm.setPublicAddresses(publicAddresses.toArray(new RawAddress[publicAddresses.size()]));
        vm.setPrivateAddresses(privateAddresses.toArray(new RawAddress[privateAddresses.size()]));
        vm.setProviderAssignedIpAddressId(providerAssignedIpAddressId);
        vm.setRebootable(true);
        vm.setPersistent(true);
        vm.setIpForwardingAllowed(true);
        vm.setImagable(false);
        vm.setClonable(false);
        vm.setPlatform(Platform.guess((String)instance.getName()));
        vm.setArchitecture(Architecture.I64);
        vm.setTag("contentLink", instance.getSelfLink());
        return vm;
    }

    private VirtualMachineProduct toProduct(MachineType machineType) {
        VirtualMachineProduct product = new VirtualMachineProduct();
        product.setProviderProductId(machineType.getName() + "+" + machineType.getZone());
        product.setName(machineType.getName());
        product.setDescription(machineType.getSelfLink());
        product.setCpuCount(machineType.getGuestCpus().intValue());
        product.setRamSize(new Storage((Number)machineType.getMemoryMb(), (StorageUnit)Storage.MEGABYTE));
        if (machineType.getImageSpaceGb() != null) {
            product.setRootVolumeSize(new Storage((Number)machineType.getImageSpaceGb(), (StorageUnit)Storage.GIGABYTE));
        } else {
            product.setRootVolumeSize(new Storage((Number)0, (StorageUnit)Storage.GIGABYTE));
        }
        product.setVisibleScope(VisibleScope.ACCOUNT_DATACENTER);
        return product;
    }

    @Nonnull
    public Iterable<String> launchMany(@Nonnull VMLaunchOptions withLaunchOptions, @Nonnegative int count) throws CloudException, InternalException {
        if (count < 1) {
            throw new InternalException("Invalid attempt to launch less than 1 virtual machine (requested " + count + ").");
        }
        if (count == 1) {
            return Collections.singleton(this.launch(withLaunchOptions).getProviderVirtualMachineId());
        }
        final ArrayList<Future> results = new ArrayList<Future>();
        NamingConstraints c = NamingConstraints.getAlphaNumeric((int)1, (int)63).withNoSpaces().withRegularExpression("(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?)").lowerCaseOnly().constrainedBy(new char[]{'-'});
        String baseHost = c.convertToValidName(withLaunchOptions.getHostName(), Locale.US);
        if (baseHost == null) {
            baseHost = withLaunchOptions.getHostName();
        }
        for (int i = 1; i <= count; ++i) {
            String hostName = c.incrementName(baseHost, i);
            String friendlyName = withLaunchOptions.getFriendlyName() + "-" + i;
            VMLaunchOptions options = withLaunchOptions.copy(hostName == null ? withLaunchOptions.getHostName() + "-" + i : hostName, friendlyName);
            results.add(this.launchAsync(options));
        }
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<String>(){

            public void populate(@Nonnull Jiterator<String> iterator) throws Exception {
                ArrayList<Future> original = results;
                ArrayList<Future> copy = new ArrayList<Future>();
                Exception exception = null;
                boolean loaded = false;
                while (!original.isEmpty()) {
                    for (Future result : original) {
                        if (result.isDone()) {
                            try {
                                iterator.push(result.get());
                                loaded = true;
                            }
                            catch (Exception e) {
                                exception = e;
                            }
                            continue;
                        }
                        copy.add(result);
                    }
                    original = copy;
                    copy = new ArrayList();
                }
                if (exception != null && !loaded) {
                    throw exception;
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nullable
    public String getUserData(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"getVirtualMachine");
        try {
            Compute gce = this.provider.getGoogleCompute();
            InstanceAggregatedList instances = (InstanceAggregatedList)gce.instances().aggregatedList(this.provider.getContext().getAccountNumber()).setFilter("name eq " + this.getVmNameFromId(vmId)).execute();
            for (String zone : instances.getItems().keySet()) {
                if (instances.getItems() == null || instances.getItems().get(zone) == null || ((InstancesScopedList)instances.getItems().get(zone)).getInstances() == null) continue;
                for (Instance instance : ((InstancesScopedList)instances.getItems().get(zone)).getInstances()) {
                    List items;
                    Metadata metadata;
                    if (!instance.getName().equals(this.getVmNameFromId(vmId)) || null == (metadata = instance.getMetadata()) || null == (items = metadata.getItems())) continue;
                    for (Metadata.Items item : items) {
                        if (!"startup-script".equals(item.getKey())) continue;
                        String string = item.getValue();
                        return string;
                    }
                }
            }
            String string = null;
            return string;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred retrieving VM: " + vmId + ": " + ex.getMessage());
        }
        finally {
            APITrace.end();
        }
    }

    private void resetPassword(String vmId, String dataCenterId, KeyPair keys) throws InternalException, CloudException {
        Instance inst;
        Compute gce = this.provider.getGoogleCompute();
        try {
            inst = (Instance)gce.instances().get(this.provider.getContext().getAccountNumber(), dataCenterId, vmId).execute();
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        Metadata metadata = inst.getMetadata();
        this.replaceMetadata(metadata, this.buildKeyMetadata(keys, "admin", ""));
        try {
            gce.instances().setMetadata(this.provider.getContext().getAccountNumber(), dataCenterId, vmId, metadata).execute();
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private String decryptPassword(String message, KeyPair keys) throws InternalException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher rsaOAEPPadding = Cipher.getInstance("RSA/NONE/OAEPPadding", "BC");
            rsaOAEPPadding.init(2, keys.getPrivate());
            return new String(rsaOAEPPadding.doFinal(Base64.decodeBase64((String)message)), "UTF8");
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void replaceMetadata(Metadata metadata, org.json.JSONObject newMetadataItem) {
        String newItemString = newMetadataItem.toString();
        LinkedList<Metadata.Items> items = metadata.getItems();
        if (items == null) {
            items = new LinkedList<Metadata.Items>();
            metadata.setItems(items);
        }
        for (Metadata.Items item : items) {
            if (item.getKey().compareTo("windows-keys") != 0) continue;
            item.setValue(newItemString);
            return;
        }
        items.add(new Metadata.Items().setKey("windows-keys").setValue(newItemString));
    }

    private org.json.JSONObject buildKeyMetadata(KeyPair pair, String userName, String email) throws InternalException {
        org.json.JSONObject metadataValues = this.jsonEncode(pair);
        for (String key : org.json.JSONObject.getNames((org.json.JSONObject)metadataValues)) {
            try {
                metadataValues.put(key, metadataValues.get(key));
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        Date now = new Date();
        Date expireDate = new Date(now.getTime() + 360000L);
        SimpleDateFormat rfc3339Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        rfc3339Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateString = rfc3339Format.format(expireDate);
        try {
            metadataValues.put("userName", (Object)userName);
            metadataValues.put("email", (Object)email);
            metadataValues.put("expireOn", (Object)dateString);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return metadataValues;
    }

    private org.json.JSONObject jsonEncode(KeyPair keys) throws InternalException {
        org.json.JSONObject returnJson = new org.json.JSONObject();
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec pubSpec = factory.getKeySpec(keys.getPublic(), RSAPublicKeySpec.class);
            BigInteger modulus = pubSpec.getModulus();
            BigInteger exponent = pubSpec.getPublicExponent();
            BaseEncoding stringEncoder = BaseEncoding.base64();
            byte[] arr = Arrays.copyOfRange(modulus.toByteArray(), 1, modulus.toByteArray().length);
            returnJson.put("modulus", (Object)stringEncoder.encode(arr).replaceAll("\n", ""));
            returnJson.put("exponent", (Object)stringEncoder.encode(exponent.toByteArray()).replaceAll("\n", ""));
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        return returnJson;
    }
}

