/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.compute.server;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.SnapshotList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.compute.AbstractSnapshotSupport;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotCreateOptions;
import org.dasein.cloud.compute.SnapshotFilterOptions;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCESnapshotCapabilities;
import org.dasein.cloud.util.APITrace;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SnapshotSupport
extends AbstractSnapshotSupport {
    private static final Logger logger = Google.getLogger(SnapshotSupport.class);
    private Google provider;
    private volatile transient GCESnapshotCapabilities capabilities;

    public SnapshotSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public void addSnapshotShare(@Nonnull String providerSnapshotId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support sharing a snapshot across accounts.");
    }

    public void addPublicShare(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support sharing a snapshot across accounts.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createSnapshot(@Nonnull SnapshotCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Snapshot.createSnapshot");
        try {
            Compute gce = this.provider.getGoogleCompute();
            try {
                com.google.api.services.compute.model.Snapshot s;
                Volume volume = this.provider.getComputeServices().getVolumeSupport().getVolume(options.getVolumeId());
                com.google.api.services.compute.model.Snapshot snapshot = new com.google.api.services.compute.model.Snapshot();
                snapshot.setName(this.getCapabilities().getSnapshotNamingConstraints().convertToValidName(options.getName(), Locale.US));
                snapshot.setDescription(options.getDescription());
                snapshot.setSourceDiskId(options.getVolumeId());
                Operation job = (Operation)gce.disks().createSnapshot(this.provider.getContext().getAccountNumber(), volume.getProviderDataCenterId(), options.getVolumeId(), snapshot).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", volume.getProviderDataCenterId())) throw new CloudException("An error occurred creating the snapshot: Operation Timedout");
                SnapshotList snapshots = (SnapshotList)gce.snapshots().list(this.provider.getContext().getAccountNumber()).setFilter("name eq " + options.getName()).execute();
                Iterator i$ = snapshots.getItems().iterator();
                do {
                    if (!i$.hasNext()) throw new CloudException("An error occurred creating the snapshot: Operation Timedout");
                } while (!(s = (com.google.api.services.compute.model.Snapshot)i$.next()).getName().equals(options.getName()));
                String string = s.getName();
                return string;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() != GoogleJsonResponseException.class) throw new CloudException("An error occurred creating the snapshot: " + ex.getMessage());
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            catch (Exception ex) {
                throw new OperationNotSupportedException("Copying snapshots is not supported in GCE");
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public GCESnapshotCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GCESnapshotCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nonnull
    public String getProviderTermForSnapshot(@Nonnull Locale locale) {
        return "snapshot";
    }

    public Snapshot getSnapshot(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Snapshot.getSnapshot");
        try {
            Compute gce = this.provider.getGoogleCompute();
            try {
                com.google.api.services.compute.model.Snapshot snapshot = (com.google.api.services.compute.model.Snapshot)gce.snapshots().get(this.provider.getContext().getAccountNumber(), snapshotId).execute();
                Snapshot snapshot2 = this.toSnapshot(snapshot);
                return snapshot2;
            }
            catch (IOException ex) {
                block8: {
                    if (ex.getMessage() == null || !ex.getMessage().contains("404 Not Found")) break block8;
                    Snapshot snapshot = null;
                    APITrace.end();
                    return snapshot;
                }
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred getting the snapshot: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isPublic(@Nonnull String snapshotId) throws InternalException, CloudException {
        return false;
    }

    public boolean isSubscribed() throws InternalException, CloudException {
        return true;
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String snapshotId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listSnapshotStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Snapshot.listSnapshotStatus");
        try {
            ArrayList<ResourceStatus> statuses = new ArrayList<ResourceStatus>();
            Compute gce = this.provider.getGoogleCompute();
            try {
                SnapshotList list = (SnapshotList)gce.snapshots().list(this.provider.getContext().getAccountNumber()).execute();
                if (list != null && list.size() > 0) {
                    for (com.google.api.services.compute.model.Snapshot googleSnapshot : list.getItems()) {
                        ResourceStatus status = this.toStatus(googleSnapshot);
                        if (status == null) continue;
                        statuses.add(status);
                    }
                }
                ArrayList<ResourceStatus> i$ = statuses;
                return i$;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred retrieving snapshot status");
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<Snapshot> listSnapshots() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Snapshot.listSnapshots");
        try {
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            Compute gce = this.provider.getGoogleCompute();
            try {
                SnapshotList list = (SnapshotList)gce.snapshots().list(this.provider.getContext().getAccountNumber()).execute();
                if (list != null && list.getItems() != null && list.getItems().size() > 0) {
                    for (com.google.api.services.compute.model.Snapshot googleSnapshot : list.getItems()) {
                        Snapshot snapshot = this.toSnapshot(googleSnapshot);
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
                ArrayList<Snapshot> i$ = snapshots;
                return i$;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while listing snapshots: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<Snapshot> listSnapshots(SnapshotFilterOptions options) throws InternalException, CloudException {
        return this.searchSnapshots(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Snapshot.remove");
        try {
            Compute gce = this.provider.getGoogleCompute();
            try {
                Operation job = (Operation)gce.snapshots().delete(this.provider.getContext().getAccountNumber(), snapshotId).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "")) {
                    throw new CloudException("An error occurred deleting the snapshot: Operation timed out");
                }
            }
            catch (IOException ex) {
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    logger.error((Object)ex.getMessage());
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred deleting the snapshot: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void removeAllSnapshotShares(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
    }

    public void removeSnapshotShare(@Nonnull String providerSnapshotId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support sharing/unsharing a snapshot across accounts.");
    }

    public void removePublicShare(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google does not support sharing/unsharing a snapshot across accounts.");
    }

    public void removeTags(@Nonnull String snapshotId, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google snapshot does not contain meta data");
    }

    public void removeTags(@Nonnull String[] snapshotIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google snapshot does not contain meta data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Snapshot> searchSnapshots(@Nonnull SnapshotFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Snapshot.searchSnapshots");
        try {
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            for (Snapshot snapshot : this.listSnapshots()) {
                if (options != null && !options.matches(snapshot, null)) continue;
                snapshots.add(snapshot);
            }
            ArrayList<Snapshot> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void updateTags(@Nonnull String snapshotId, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google snapshot does not contain meta data");
    }

    public void updateTags(@Nonnull String[] snapshotIds, Tag ... tags) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Google snapshot does not contain meta data");
    }

    @Nullable
    private Snapshot toSnapshot(com.google.api.services.compute.model.Snapshot googleSnapshot) {
        Snapshot snapshot = new Snapshot();
        snapshot.setProviderSnapshotId(googleSnapshot.getName());
        snapshot.setName(googleSnapshot.getName());
        snapshot.setDescription(googleSnapshot.getDescription());
        snapshot.setOwner(this.provider.getContext().getAccountNumber());
        SnapshotState state = SnapshotState.PENDING;
        if (googleSnapshot.getStatus().equals("READY")) {
            state = SnapshotState.AVAILABLE;
        } else if (googleSnapshot.getStatus().equals("DELETING")) {
            state = SnapshotState.DELETED;
        }
        snapshot.setCurrentState(state);
        snapshot.setSizeInGb(googleSnapshot.getDiskSizeGb().intValue());
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        DateTime dt = DateTime.parse((String)googleSnapshot.getCreationTimestamp(), (DateTimeFormatter)fmt);
        snapshot.setSnapshotTimestamp(dt.toDate().getTime());
        String sourceDisk = googleSnapshot.getSourceDisk();
        if (sourceDisk != null) {
            snapshot.setVolumeId(sourceDisk.substring(sourceDisk.lastIndexOf("/") + 1));
        }
        return snapshot;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable com.google.api.services.compute.model.Snapshot snapshot) throws CloudException {
        SnapshotState state = snapshot.getStatus().equals("READY") ? SnapshotState.AVAILABLE : (snapshot.getStatus().equals("DELETING") ? SnapshotState.DELETED : SnapshotState.PENDING);
        return new ResourceStatus(snapshot.getName(), (Object)state);
    }
}

