/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.network;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Backend;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.HostRule;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpProxyList;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Tag;
import org.dasein.cloud.ci.AbstractConvergedHttpLoadBalancer;
import org.dasein.cloud.ci.ConvergedHttpLoadBalancer;
import org.dasein.cloud.ci.HttpLoadBalancerCapabilities;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEHttpLoadBalancerCapabilities;
import org.dasein.cloud.identity.ServiceAction;

public class CIHttpLoadBalancerSupport
extends AbstractConvergedHttpLoadBalancer<Google> {
    private Google provider;
    private ProviderContext ctx;

    public CIHttpLoadBalancerSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
        this.ctx = provider.getContext();
    }

    public HttpLoadBalancerCapabilities getCapabilities() {
        return new GCEHttpLoadBalancerCapabilities(this.provider);
    }

    public String getProviderTermForConvergedHttpLoadBalancer(Locale locale) {
        return "HTTP load balancer";
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    public Iterable<String> listConvergedHttpLoadBalancers() throws CloudException, InternalException {
        ArrayList<String> httpLoadBalancers = new ArrayList<String>();
        Compute gce = this.provider.getGoogleCompute();
        try {
            UrlMapList urlMaps = (UrlMapList)gce.urlMaps().list(this.ctx.getAccountNumber()).execute();
            if (null != urlMaps && null != urlMaps.getItems()) {
                for (UrlMap urlMap : urlMaps.getItems()) {
                    httpLoadBalancers.add(urlMap.getName());
                }
            }
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred listing convergedHttpLoadBalancers " + ex.getMessage());
        }
        return httpLoadBalancers;
    }

    @Nullable
    public ConvergedHttpLoadBalancer getConvergedHttpLoadBalancer(@Nonnull String convergedHttpLoadBalancerName) throws CloudException, InternalException {
        return this.toConvergedHttpLoadBalancer(convergedHttpLoadBalancerName);
    }

    private String flatten(List<String> items) {
        String flattened = "";
        for (String item : items) {
            flattened = flattened + item + ", ";
        }
        return flattened.replaceFirst(", $", "");
    }

    public ConvergedHttpLoadBalancer toConvergedHttpLoadBalancer(@Nonnull String urlMap) throws CloudException, InternalException {
        ConvergedHttpLoadBalancer convergedHttpLoadBalancer;
        Compute gce = this.provider.getGoogleCompute();
        urlMap = urlMap.replaceAll(".*/", "");
        try {
            UrlMap um = (UrlMap)gce.urlMaps().get(this.ctx.getAccountNumber(), urlMap).execute();
            convergedHttpLoadBalancer = ConvergedHttpLoadBalancer.getInstance((String)um.getName(), (String)um.getDescription(), (String)um.getSelfLink(), (String)um.getCreationTimestamp(), (String)um.getDefaultService().replaceAll(".*/", ""));
            List hostRules = um.getHostRules();
            HashMap<String, String> descriptionMap = new HashMap<String, String>();
            HashMap<String, String> hostMatchPatternMap = new HashMap<String, String>();
            for (HostRule hostRule : hostRules) {
                descriptionMap.put(hostRule.getPathMatcher(), hostRule.getDescription());
                hostMatchPatternMap.put(hostRule.getPathMatcher(), this.flatten(hostRule.getHosts()));
            }
            List pathMatchers = um.getPathMatchers();
            for (PathMatcher pathMatcher : pathMatchers) {
                HashMap<String, String> pathMap = new HashMap<String, String>();
                String defaultService = pathMatcher.getDefaultService().replaceAll(".*/", "");
                pathMap.put("/*", defaultService);
                if (null != pathMatcher.getPathRules()) {
                    for (PathRule pathRule : pathMatcher.getPathRules()) {
                        pathMap.put(this.flatten(pathRule.getPaths()), pathRule.getService().replaceAll(".*/", ""));
                    }
                }
                convergedHttpLoadBalancer = convergedHttpLoadBalancer.withUrlSet(pathMatcher.getName(), (String)descriptionMap.get(pathMatcher.getName()), (String)hostMatchPatternMap.get(pathMatcher.getName()), pathMap);
            }
            TargetHttpProxyList targetHttpProxyList = (TargetHttpProxyList)gce.targetHttpProxies().list(this.ctx.getAccountNumber()).execute();
            for (TargetHttpProxy targetProxy : targetHttpProxyList.getItems()) {
                if (!targetProxy.getUrlMap().endsWith(urlMap)) continue;
                convergedHttpLoadBalancer = convergedHttpLoadBalancer.withTargetHttpProxy(targetProxy.getName(), targetProxy.getDescription(), targetProxy.getCreationTimestamp(), targetProxy.getSelfLink());
                ForwardingRuleList forwardingRuleList = (ForwardingRuleList)gce.globalForwardingRules().list(this.ctx.getAccountNumber()).execute();
                for (ForwardingRule forwardingRule : forwardingRuleList.getItems()) {
                    if (!forwardingRule.getTarget().endsWith(targetProxy.getName())) continue;
                    convergedHttpLoadBalancer = convergedHttpLoadBalancer.withForwardingRule(forwardingRule.getName(), forwardingRule.getDescription(), forwardingRule.getCreationTimestamp(), forwardingRule.getIPAddress(), forwardingRule.getIPProtocol(), forwardingRule.getPortRange(), forwardingRule.getSelfLink(), forwardingRule.getTarget().replaceAll(".*/", ""));
                }
            }
            ArrayList<String> backendServices = new ArrayList<String>();
            backendServices.add(um.getDefaultService().replaceAll(".*/", ""));
            ArrayList<String> allHealthChecks = new ArrayList<String>();
            for (String backendService : new HashSet(backendServices)) {
                BackendService bes = (BackendService)gce.backendServices().get(this.ctx.getAccountNumber(), backendService).execute();
                List healthChecks = bes.getHealthChecks();
                ArrayList<String> instanceGroups = new ArrayList<String>();
                for (Backend backend : bes.getBackends()) {
                    instanceGroups.add(backend.getGroup().replaceAll(".*/", ""));
                    convergedHttpLoadBalancer = convergedHttpLoadBalancer.withBackendServiceBackend(bes.getName(), backend.getDescription(), backend.getBalancingMode(), backend.getCapacityScaler(), backend.getGroup(), backend.getMaxRate(), backend.getMaxRatePerInstance(), backend.getMaxUtilization());
                }
                convergedHttpLoadBalancer = convergedHttpLoadBalancer.withBackendService(bes.getName(), bes.getDescription(), bes.getCreationTimestamp(), bes.getPort(), bes.getPortName(), bes.getProtocol(), healthChecks.toArray(new String[healthChecks.size()]), instanceGroups.toArray(new String[instanceGroups.size()]), bes.getSelfLink(), bes.getTimeoutSec());
                for (String healthCheck : bes.getHealthChecks()) {
                    allHealthChecks.add(healthCheck.replaceAll(".*/", ""));
                }
            }
            for (String healthCheck : new HashSet(allHealthChecks)) {
                HttpHealthCheck hc = (HttpHealthCheck)gce.httpHealthChecks().get(this.ctx.getAccountNumber(), healthCheck).execute();
                convergedHttpLoadBalancer = convergedHttpLoadBalancer.withHealthCheck(hc.getName(), hc.getDescription(), hc.getCreationTimestamp(), hc.getHost(), hc.getPort(), hc.getRequestPath(), hc.getCheckIntervalSec(), hc.getTimeoutSec(), hc.getHealthyThreshold(), hc.getUnhealthyThreshold(), hc.getSelfLink());
            }
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred listing convergedHttpLoadBalancers " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing Converged Http Load Balancer " + ex.getMessage());
        }
        return convergedHttpLoadBalancer;
    }

    public void removeGlobalForwardingRule(@Nonnull String globalForwardingRule) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            Operation job = (Operation)gce.globalForwardingRules().delete(this.ctx.getAccountNumber(), globalForwardingRule.replaceAll(".*/", "")).execute();
            method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred removing global forwarding rule " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing global forwarding rule " + ex.getMessage());
        }
    }

    public void removeTargetHttpProxy(@Nonnull String targetHttpProxy) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            Operation job = (Operation)gce.targetHttpProxies().delete(this.ctx.getAccountNumber(), targetHttpProxy.replaceAll(".*/", "")).execute();
            method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred removing target http proxy " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing target http proxy " + ex.getMessage());
        }
    }

    public void removeUrlMap(@Nonnull String urlMap) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            Operation job = (Operation)gce.urlMaps().delete(this.ctx.getAccountNumber(), urlMap.replaceAll(".*/", "")).execute();
            method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred removing url map " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing url map " + ex.getMessage());
        }
    }

    public void removeBackendService(@Nonnull String backendService) throws CloudException, InternalException {
        block4: {
            Compute gce = this.provider.getGoogleCompute();
            GoogleMethod method = new GoogleMethod(this.provider);
            try {
                Operation job = (Operation)gce.backendServices().delete(this.ctx.getAccountNumber(), backendService.replaceAll(".*/", "")).execute();
                method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
            }
            catch (IOException ex) {
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred removing backend service " + ex.getMessage());
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("is already being used by")) break block4;
                throw new CloudException("Error removing backend service " + ex.getMessage());
            }
        }
    }

    public void removeHttpHealthCheck(@Nonnull String httpHealthCheck) throws CloudException, InternalException {
        block4: {
            Compute gce = this.provider.getGoogleCompute();
            GoogleMethod method = new GoogleMethod(this.provider);
            try {
                Operation job = (Operation)gce.httpHealthChecks().delete(this.ctx.getAccountNumber(), httpHealthCheck.replaceAll(".*/", "")).execute();
                method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
            }
            catch (IOException ex) {
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred removing http health check " + ex.getMessage());
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("is already being used by")) break block4;
                throw new CloudException("Error removing http health check " + ex.getMessage());
            }
        }
    }

    public void removeConvergedHttpLoadBalancers(@Nonnull String urlMap) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        urlMap = urlMap.replaceAll(".*/", "");
        try {
            ForwardingRuleList forwardingRuleList = (ForwardingRuleList)gce.globalForwardingRules().list(this.ctx.getAccountNumber()).execute();
            TargetHttpProxyList targetHttpProxyList = (TargetHttpProxyList)gce.targetHttpProxies().list(this.ctx.getAccountNumber()).execute();
            for (TargetHttpProxy targetProxy : targetHttpProxyList.getItems()) {
                if (!targetProxy.getUrlMap().endsWith(urlMap)) continue;
                for (ForwardingRule forwardingRule : forwardingRuleList.getItems()) {
                    if (!forwardingRule.getTarget().endsWith(targetProxy.getName())) continue;
                    this.removeGlobalForwardingRule(forwardingRule.getName());
                }
                this.removeTargetHttpProxy(targetProxy.getName());
            }
            UrlMap um = (UrlMap)gce.urlMaps().get(this.ctx.getAccountNumber(), urlMap).execute();
            ArrayList<String> backendServices = new ArrayList<String>();
            backendServices.add(um.getDefaultService().replaceAll(".*/", ""));
            List pathMatchers = um.getPathMatchers();
            for (PathMatcher pathMatcher : pathMatchers) {
                backendServices.add(pathMatcher.getDefaultService().replaceAll(".*/", ""));
                if (null == pathMatcher.getPathRules()) continue;
                for (PathRule pathRule : pathMatcher.getPathRules()) {
                    backendServices.add(pathRule.getService().replaceAll(".*/", ""));
                }
            }
            this.removeUrlMap(um.getName());
            ArrayList<String> healthChecks = new ArrayList<String>();
            for (String backendService : new HashSet(backendServices)) {
                BackendService bes = (BackendService)gce.backendServices().get(this.ctx.getAccountNumber(), backendService).execute();
                for (String healthCheck : bes.getHealthChecks()) {
                    healthChecks.add(healthCheck);
                }
                this.removeBackendService(backendService);
            }
            for (String healthCheck : new HashSet(healthChecks)) {
                this.removeHttpHealthCheck(healthCheck);
            }
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred removing convergedHttpLoadBalancer " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing Converged Http Load Balancer " + ex.getMessage());
        }
    }

    public void createBackendService(ConvergedHttpLoadBalancer withConvergedHttpLoadBalancerOptions) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        List backendServices = withConvergedHttpLoadBalancerOptions.getBackendServices();
        for (ConvergedHttpLoadBalancer.BackendService backendService : backendServices) {
            if (null != backendService.getSelfLink()) continue;
            BackendService beContent = new BackendService();
            beContent.setName(this.getCapabilities().getConvergedHttpLoadBalancerNamingConstraints().convertToValidName(backendService.getName(), Locale.US));
            beContent.setDescription(backendService.getDescription());
            beContent.setPort(backendService.getPort());
            beContent.setPortName(backendService.getPortName());
            beContent.setTimeoutSec(backendService.getTimeoutSec());
            ArrayList<String> healthCheckSelfUrls = new ArrayList<String>();
            for (String healthCheckName : backendService.getHealthChecks()) {
                healthCheckSelfUrls.add(withConvergedHttpLoadBalancerOptions.getHealthCheckSelfUrl(healthCheckName));
            }
            beContent.setHealthChecks(healthCheckSelfUrls);
            ArrayList<Backend> backends = new ArrayList<Backend>();
            for (String backendServiceInstranceGroupSelfUrl : backendService.getBackendServiceBackends()) {
                Backend backend = new Backend();
                backend.setGroup(backendServiceInstranceGroupSelfUrl);
                backends.add(backend);
            }
            beContent.setBackends(backends);
            try {
                Operation foo = (Operation)gce.backendServices().insert(this.ctx.getAccountNumber(), beContent).execute();
                method.getOperationComplete(this.provider.getContext(), foo, GoogleOperationType.GLOBAL_OPERATION, null, null);
            }
            catch (IOException ex) {
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred listing convergedHttpLoadBalancers " + ex.getMessage());
            }
            catch (Exception ex) {
                throw new CloudException("Error removing Converged Http Load Balancer " + ex.getMessage());
            }
            backendService.setServiceUrl(gce.getBaseUrl() + this.ctx.getAccountNumber() + "/global/backendServices/" + backendService.getName());
        }
    }

    public void createURLMap(ConvergedHttpLoadBalancer withConvergedHttpLoadBalancerOptions) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            List urlSets = withConvergedHttpLoadBalancerOptions.getUrlSets();
            UrlMap urlMap = new UrlMap();
            ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>();
            ArrayList<HostRule> hostRules = new ArrayList<HostRule>();
            for (ConvergedHttpLoadBalancer.UrlSet urlSet : urlSets) {
                HostRule hostRule = new HostRule();
                ArrayList<String> hosts = new ArrayList<String>();
                String hostMatchPatterns = urlSet.getHostMatchPatterns();
                if (hostMatchPatterns.contains(",")) {
                    for (String hostMatchPattern : hostMatchPatterns.split(", ?")) {
                        hosts.add(hostMatchPattern);
                    }
                } else {
                    hosts.add(hostMatchPatterns);
                }
                hostRule.setHosts(hosts);
                hostRule.setPathMatcher(urlSet.getName());
                hostRules.add(hostRule);
                PathMatcher pathMatcher = new PathMatcher();
                pathMatcher.setName(urlSet.getName());
                ArrayList<PathRule> pathRules = new ArrayList<PathRule>();
                Map pathMap = urlSet.getPathMap();
                for (String key : pathMap.keySet()) {
                    PathRule pathRule = new PathRule();
                    ArrayList<String> paths = new ArrayList<String>();
                    if (key.equals("/*")) {
                        pathMatcher.setDefaultService(withConvergedHttpLoadBalancerOptions.getBackendServiceSelfUrl((String)pathMap.get(key)));
                        continue;
                    }
                    if (key.contains(",")) {
                        for (String path : key.split(", *")) {
                            paths.add(path);
                        }
                    } else {
                        paths.add(key);
                    }
                    pathRule.setPaths(paths);
                    pathRule.setService(withConvergedHttpLoadBalancerOptions.getBackendServiceSelfUrl((String)pathMap.get(key)));
                    pathRules.add(pathRule);
                }
                pathMatcher.setPathRules(pathRules);
                pathMatchers.add(pathMatcher);
            }
            urlMap.setHostRules(hostRules);
            urlMap.setName(this.getCapabilities().getConvergedHttpLoadBalancerNamingConstraints().convertToValidName(withConvergedHttpLoadBalancerOptions.getName(), Locale.US));
            urlMap.setPathMatchers(pathMatchers);
            urlMap.setDescription(withConvergedHttpLoadBalancerOptions.getDescription());
            urlMap.setDefaultService(withConvergedHttpLoadBalancerOptions.getBackendServiceSelfUrl(withConvergedHttpLoadBalancerOptions.getDefaultBackendService()));
            Operation job = (Operation)gce.urlMaps().insert(this.ctx.getAccountNumber(), urlMap).execute();
            method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred creating convergedHttpLoadBalancers " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error creating Converged Http Load Balancer " + ex.getMessage());
        }
        withConvergedHttpLoadBalancerOptions.setUrlMapSelfUrl(gce.getBaseUrl() + this.ctx.getAccountNumber() + "/global/urlMaps/" + withConvergedHttpLoadBalancerOptions.getName());
    }

    public void createTargetProxy(ConvergedHttpLoadBalancer withConvergedHttpLoadBalancerOptions) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        TargetHttpProxy content = new TargetHttpProxy();
        List targetHttpProxies = withConvergedHttpLoadBalancerOptions.getTargetHttpProxies();
        try {
            for (ConvergedHttpLoadBalancer.TargetHttpProxy targetHttpProxy : targetHttpProxies) {
                content.setName(this.getCapabilities().getConvergedHttpLoadBalancerNamingConstraints().convertToValidName(targetHttpProxy.getName(), Locale.US));
                content.setDescription(targetHttpProxy.getDescription());
                content.setUrlMap(withConvergedHttpLoadBalancerOptions.getSelfLink());
                Operation job = (Operation)gce.targetHttpProxies().insert(this.ctx.getAccountNumber(), content).execute();
                method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
                targetHttpProxy.setTargetProxySelfUrl(gce.getBaseUrl() + this.ctx.getAccountNumber() + "/global/targetHttpProxies/" + targetHttpProxy.getName());
            }
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred listing convergedHttpLoadBalancers " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing Converged Http Load Balancer " + ex.getMessage());
        }
    }

    public void createGlobalForwardingRule(ConvergedHttpLoadBalancer withConvergedHttpLoadBalancerOptions) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        ForwardingRule gfwContent = new ForwardingRule();
        List forwardingRules = withConvergedHttpLoadBalancerOptions.getForwardingRules();
        try {
            for (ConvergedHttpLoadBalancer.ForwardingRule forwardingRule : forwardingRules) {
                gfwContent.setName(this.getCapabilities().getConvergedHttpLoadBalancerNamingConstraints().convertToValidName(forwardingRule.getName(), Locale.US));
                gfwContent.setDescription(forwardingRule.getDescription());
                if (null != forwardingRule.getIpAddress()) {
                    gfwContent.setIPAddress(forwardingRule.getIpAddress());
                }
                gfwContent.setIPProtocol(forwardingRule.getIpProtocol());
                gfwContent.setPortRange(forwardingRule.getPortRange());
                gfwContent.setTarget(withConvergedHttpLoadBalancerOptions.getTargetProxySelfUrl(forwardingRule.getTarget()));
                Operation job = (Operation)gce.globalForwardingRules().insert(this.ctx.getAccountNumber(), gfwContent).execute();
                method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
                forwardingRule.setGlobalForwardingRuleSelfUrl(gce.getBaseUrl() + this.ctx.getAccountNumber() + "/global/httpHealthChecks/" + forwardingRule.getName());
            }
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred creating GlobalForwardingRule: " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error occurred creating GlobalForwardingRule: " + ex.getMessage());
        }
    }

    public String createConvergedHttpLoadBalancer(@Nonnull ConvergedHttpLoadBalancer withConvergedHttpLoadBalancerOptions) throws CloudException, InternalException {
        try {
            this.createHttpHealthChecks(withConvergedHttpLoadBalancerOptions);
        }
        catch (Exception ex) {
            throw new CloudException("Error creating Converged Http Load Balancer " + ex.getMessage());
        }
        try {
            this.createBackendService(withConvergedHttpLoadBalancerOptions);
        }
        catch (Exception ex) {
            throw new CloudException("Error creating Converged Http Load Balancer " + ex.getMessage());
        }
        try {
            this.createURLMap(withConvergedHttpLoadBalancerOptions);
        }
        catch (Exception ex) {
            throw new CloudException("Error creating Converged Http Load Balancer " + ex.getMessage());
        }
        try {
            this.createTargetProxy(withConvergedHttpLoadBalancerOptions);
        }
        catch (Exception ex) {
            throw new CloudException("Error creating Converged Http Load Balancer " + ex.getMessage());
        }
        try {
            this.createGlobalForwardingRule(withConvergedHttpLoadBalancerOptions);
        }
        catch (Exception ex) {
            throw new CloudException("Error creating Converged Http Load Balancer " + ex.getMessage());
        }
        return withConvergedHttpLoadBalancerOptions.getSelfLink();
    }

    private void createHttpHealthChecks(ConvergedHttpLoadBalancer withConvergedHttpLoadBalancerOptions) throws CloudException, InternalException {
        Compute gce = this.provider.getGoogleCompute();
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            List healthChecks = withConvergedHttpLoadBalancerOptions.getHealthChecks();
            for (ConvergedHttpLoadBalancer.HealthCheck healthCheck : healthChecks) {
                if (null != healthCheck.getSelfLink()) continue;
                HttpHealthCheck httpHealthCheck = new HttpHealthCheck();
                httpHealthCheck.setName(this.getCapabilities().getConvergedHttpLoadBalancerNamingConstraints().convertToValidName(healthCheck.getName(), Locale.US));
                httpHealthCheck.setDescription(healthCheck.getDescription());
                httpHealthCheck.setCheckIntervalSec(healthCheck.getCheckIntervalSec());
                httpHealthCheck.setHealthyThreshold(healthCheck.getHealthyThreshold());
                httpHealthCheck.setUnhealthyThreshold(healthCheck.getUnHealthyThreshold());
                httpHealthCheck.setTimeoutSec(healthCheck.getTimeoutSec());
                httpHealthCheck.setHost(healthCheck.getHost());
                httpHealthCheck.setPort(healthCheck.getPort());
                httpHealthCheck.setRequestPath(healthCheck.getRequestPath());
                Operation job = (Operation)gce.httpHealthChecks().insert(this.ctx.getAccountNumber(), httpHealthCheck).execute();
                method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, null, null);
                healthCheck.setSelfLink(gce.getBaseUrl() + this.ctx.getAccountNumber() + "/global/httpHealthChecks/" + healthCheck.getName());
            }
        }
        catch (IOException ex) {
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred listing convergedHttpLoadBalancers " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new CloudException("Error removing Converged Http Load Balancer " + ex.getMessage());
        }
    }

    public void updateTags(String convergedHttpLoadbalancerId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateTags(String[] convergedHttpLoadbalancerIds, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(String convergedHttpLoadbalancerId, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(String[] convergedHttpLoadbalancerIds, Tag ... tags) throws CloudException, InternalException {
    }

    public String[] mapServiceAction(ServiceAction action) {
        return null;
    }
}

