/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.network;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Firewall;
import com.google.api.services.compute.model.FirewallList;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEFirewallCapabilities;
import org.dasein.cloud.network.AbstractFirewallSupport;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallConstraints;
import org.dasein.cloud.network.FirewallCreateOptions;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.util.APITrace;

public class FirewallSupport
extends AbstractFirewallSupport<Google> {
    private static final Logger logger = Google.getLogger(org.dasein.cloud.network.FirewallSupport.class);
    private Google provider = null;
    private volatile transient GCEFirewallCapabilities capabilities;

    FirewallSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull RuleTarget sourceEndpoint, @Nonnull Protocol protocol, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort, int precedence) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Firewall.authorize");
        try {
            if (Permission.DENY.equals((Object)permission)) {
                throw new OperationNotSupportedException("GCE does not support DENY rules");
            }
            if (direction.equals((Object)Direction.EGRESS)) {
                throw new OperationNotSupportedException("GCE does not support EGRESS rules");
            }
            Compute gce = this.provider.getGoogleCompute();
            com.google.api.services.compute.model.Firewall googleFirewall = new com.google.api.services.compute.model.Firewall();
            Random r = new Random();
            char c = (char)(r.nextInt(26) + 97);
            googleFirewall.setName(c + UUID.randomUUID().toString());
            if (protocol == Protocol.ICMP) {
                googleFirewall.setDescription(sourceEndpoint.getCidr() + ":" + protocol.name());
            } else {
                googleFirewall.setDescription(sourceEndpoint + ":" + protocol.name() + ":" + beginPort + "-" + endPort);
            }
            VLAN vlan = this.provider.getNetworkServices().getVlanSupport().getVlan(firewallId.split("fw-")[1]);
            googleFirewall.setNetwork(vlan.getTag("contentLink"));
            String portString = "";
            portString = beginPort == endPort ? beginPort + "" : beginPort + "-" + endPort;
            ArrayList<Firewall.Allowed> allowedRules = new ArrayList<Firewall.Allowed>();
            Firewall.Allowed allowed = new Firewall.Allowed();
            allowed.setIPProtocol(protocol.name());
            if (protocol != Protocol.ICMP) {
                allowed.setPorts(Collections.singletonList(portString));
            }
            allowedRules.add(allowed);
            googleFirewall.setAllowed(allowedRules);
            if (sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.VLAN) || sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL)) {
                throw new OperationNotSupportedException("GCE does not support VLAN or GLOBAL as valid source types");
            }
            if (sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.VM)) {
                googleFirewall.setSourceTags(Collections.singletonList(this.provider.getComputeServices().getVirtualMachineSupport().getVmNameFromId(sourceEndpoint.getProviderVirtualMachineId())));
            } else if (sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.CIDR)) {
                googleFirewall.setSourceRanges(Collections.singletonList(sourceEndpoint.getCidr()));
            }
            if (destinationEndpoint.getRuleTargetType().equals((Object)RuleTargetType.VM)) {
                googleFirewall.setTargetTags(Collections.singletonList(this.provider.getComputeServices().getVirtualMachineSupport().getVmNameFromId(destinationEndpoint.getProviderVirtualMachineId())));
            }
            Iterable existingRules = this.getRules(firewallId);
            boolean ruleDiffers = true;
            String sourceEndpointCidr = sourceEndpoint.getCidr();
            for (FirewallRule candidateRule : existingRules) {
                boolean directionMatch;
                boolean protocolMatch = candidateRule.getProtocol() == protocol;
                boolean startPortMatch = candidateRule.getStartPort() == beginPort;
                boolean endPortMatch = candidateRule.getEndPort() == endPort;
                boolean sourceCidrMatch = sourceEndpoint.equals(candidateRule.getCidr().toString()) || sourceEndpoint.toString().equals("CIDR:" + candidateRule.getCidr().toString()) || sourceEndpoint.toString().equals("VM:" + candidateRule.getCidr().toString());
                boolean endpointCidrMatch = sourceEndpointCidr == null || sourceEndpoint.getCidr().equals(candidateRule.getSourceEndpoint());
                boolean bl = directionMatch = candidateRule.getDirection() == direction;
                if (protocol == Protocol.ICMP) {
                    if (protocolMatch && sourceCidrMatch) {
                        ruleDiffers = false;
                    } else if (protocolMatch && directionMatch && startPortMatch && endPortMatch && sourceCidrMatch) {
                        ruleDiffers = false;
                    }
                }
                if (!protocolMatch || !directionMatch || !startPortMatch || !endPortMatch || !sourceCidrMatch) continue;
                ruleDiffers = false;
            }
            if (!ruleDiffers) {
                throw new CloudException("Duplicate rule already exists");
            }
            try {
                Operation job = (Operation)gce.firewalls().insert(this.provider.getContext().getAccountNumber(), googleFirewall).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                String string = method.getOperationTarget(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "", false);
                return string;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred creating a new rule on " + firewallId + ": " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String create(@Nonnull FirewallCreateOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not allow the creation/deletion of firewalls");
    }

    @Nonnull
    public GCEFirewallCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new GCEFirewallCapabilities((Google)this.getProvider());
        }
        return this.capabilities;
    }

    public void delete(@Nonnull String s) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not allow the creation/deletion of firewalls");
    }

    public Firewall getFirewall(@Nonnull String firewallId) throws InternalException, CloudException {
        if (!firewallId.startsWith("fw-")) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context has been established for this request");
        }
        Compute gce = this.provider.getGoogleCompute();
        try {
            Network firewall = (Network)gce.networks().get(ctx.getAccountNumber(), firewallId.split("fw-")[1]).execute();
            FirewallList firewallList = (FirewallList)gce.firewalls().list(ctx.getAccountNumber()).setFilter("network eq .*/" + firewall.getName()).execute();
            if (null != firewallList) {
                List rules = firewallList.getItems();
                return this.toFirewall(firewall, rules);
            }
            throw new CloudException("Firewall Not Found.");
        }
        catch (IOException ex) {
            logger.error((Object)("An error occurred while getting firewall " + firewallId + ": " + ex.getMessage()));
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException(ex.getMessage());
        }
    }

    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String firewallId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context has been established for this request");
        }
        if (null == ctx.getAccountNumber()) {
            throw new CloudException("Context for this request lacks a account number");
        }
        Compute gce = this.provider.getGoogleCompute();
        try {
            firewallId = firewallId.replaceFirst("^fw-", "");
            FirewallList rules = (FirewallList)gce.firewalls().list(ctx.getAccountNumber()).setFilter("network eq .*" + firewallId).execute();
            if (rules != null && null != rules.getItems()) {
                return this.toFirewallRules(rules.getItems());
            }
            return Collections.emptyList();
        }
        catch (IOException ex) {
            logger.error((Object)("An error occurred while getting firewall " + firewallId + ": " + ex.getMessage()));
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException(ex.getMessage());
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was established");
        }
        ArrayList<Firewall> firewalls = new ArrayList<Firewall>();
        try {
            Compute gce = this.provider.getGoogleCompute();
            NetworkList networkList = (NetworkList)gce.networks().list(ctx.getAccountNumber()).execute();
            if (null != networkList) {
                List networks = networkList.getItems();
                FirewallList firewallList = (FirewallList)gce.firewalls().list(ctx.getAccountNumber()).execute();
                if (null != firewallList) {
                    List rules = firewallList.getItems();
                    if (networks != null && networks.size() > 0) {
                        for (Network network : networks) {
                            Firewall firewall;
                            ArrayList<com.google.api.services.compute.model.Firewall> rulesSubset = new ArrayList<com.google.api.services.compute.model.Firewall>();
                            for (com.google.api.services.compute.model.Firewall rule : rules) {
                                if (!rule.getNetwork().equals(network.getSelfLink())) continue;
                                rulesSubset.add(rule);
                            }
                            if (network == null || (firewall = this.toFirewall(network, rulesSubset)) == null) continue;
                            firewalls.add(firewall);
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while listing Firewalls: " + ex.getMessage());
        }
        return firewalls;
    }

    @Nonnull
    public Iterable<ResourceStatus> listFirewallStatus() throws InternalException, CloudException {
        ArrayList<ResourceStatus> statuses = new ArrayList<ResourceStatus>();
        Iterable firewalls = this.list();
        for (Firewall firewall : firewalls) {
            ResourceStatus status = new ResourceStatus(firewall.getProviderFirewallId(), (Object)true);
            statuses.add(status);
        }
        return statuses;
    }

    @Deprecated
    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        ArrayList<RuleTargetType> destinationTypes = new ArrayList<RuleTargetType>();
        destinationTypes.add(RuleTargetType.VM);
        return destinationTypes;
    }

    @Deprecated
    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        directions.add(Direction.INGRESS);
        return directions;
    }

    @Deprecated
    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        permissions.add(Permission.ALLOW);
        return permissions;
    }

    @Deprecated
    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        ArrayList<RuleTargetType> sourceTypes = new ArrayList<RuleTargetType>();
        sourceTypes.add(RuleTargetType.CIDR);
        sourceTypes.add(RuleTargetType.VM);
        return sourceTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(@Nonnull String providerFirewallRuleId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Firewall.revoke");
        try {
            try {
                Compute gce = this.provider.getGoogleCompute();
                if (providerFirewallRuleId.contains("--")) {
                    String[] parts = providerFirewallRuleId.split("\\-\\-");
                    String firewall = parts[0];
                    com.google.api.services.compute.model.Firewall fw = (com.google.api.services.compute.model.Firewall)gce.firewalls().get(this.provider.getContext().getAccountNumber(), firewall).execute();
                    List sourceRanges = fw.getSourceRanges();
                    for (String sourceRange : sourceRanges) {
                        if (!parts[1].equals(sourceRange)) continue;
                        sourceRanges.remove(sourceRange);
                        break;
                    }
                    fw.setSourceRanges(sourceRanges);
                    Operation job = (Operation)gce.firewalls().update(this.provider.getContext().getAccountNumber(), firewall, fw).execute();
                    GoogleMethod method = new GoogleMethod(this.provider);
                    if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "")) {
                        throw new CloudException("An error occurred deleting the rule: Operation Timed Out");
                    }
                } else {
                    Operation job = (Operation)gce.firewalls().delete(this.provider.getContext().getAccountNumber(), providerFirewallRuleId).execute();
                    GoogleMethod method = new GoogleMethod(this.provider);
                    if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "")) {
                        throw new CloudException("An error occurred deleting the rule: Operation Timed Out");
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while deleting the firewall rule: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void revoke(@Nonnull String firewallId, @Nonnull String source, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, Direction.INGRESS, source, protocol, beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String source, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        if (!direction.equals((Object)Direction.INGRESS)) {
            throw new OperationNotSupportedException("GCE does not support outbound firewall rules");
        }
        this.revoke(firewallId, Direction.INGRESS, Permission.ALLOW, source, protocol, beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        if (!direction.equals((Object)Direction.INGRESS)) {
            throw new OperationNotSupportedException("GCE does not support outbound firewall rules");
        }
        if (!permission.equals((Object)Permission.ALLOW)) {
            throw new OperationNotSupportedException("GCE does not support deny firewall rules");
        }
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, @Nonnull RuleTarget target, int beginPort, int endPort) throws CloudException, InternalException {
        if (!direction.equals((Object)Direction.INGRESS)) {
            throw new OperationNotSupportedException("GCE does not support outbound firewall rules");
        }
        if (!permission.equals((Object)Permission.ALLOW)) {
            throw new OperationNotSupportedException("GCE does not support deny firewall rules");
        }
        if (source.contains("/")) {
            String[] parts = source.split("/");
            if (!InetAddressUtils.isIPv4Address((String)parts[0])) {
                throw new OperationNotSupportedException("GCE only supports valid IPv4 addresses or cidrs as source targets");
            }
        } else {
            if (!InetAddressUtils.isIPv4Address((String)source)) {
                throw new OperationNotSupportedException("GCE only supports valid IPv4 addresses or cidrs as source targets");
            }
            source = source + "/32";
        }
        if (!target.getRuleTargetType().equals((Object)RuleTargetType.VM) && !target.getRuleTargetType().equals((Object)RuleTargetType.VLAN)) {
            throw new InternalException("GCE only supports VM or VLAN targets for firewall rules");
        }
        FirewallRule rule = null;
        for (FirewallRule current : this.getRules(firewallId)) {
            if (!current.getSourceEndpoint().getCidr().equals(source) || !current.getProtocol().equals((Object)protocol) || (!current.getDestinationEndpoint().getRuleTargetType().equals((Object)RuleTargetType.VM) ? current.getDestinationEndpoint().getRuleTargetType().equals((Object)RuleTargetType.VLAN) && !current.getDestinationEndpoint().getProviderVlanId().equals(target.getProviderVlanId()) : !current.getDestinationEndpoint().getProviderVirtualMachineId().equals(target.getProviderVirtualMachineId()))) continue;
            if (current.getStartPort() != beginPort || current.getEndPort() != endPort) continue;
            rule = current;
        }
        if (rule == null) {
            throw new InternalException("The rule for " + direction.name() + ", " + permission.name() + ", " + source + ", " + beginPort + "-" + endPort + " does not exist");
        }
        this.revoke(rule.getProviderRuleId());
    }

    @Nullable
    private Firewall toFirewall(@Nonnull Network googleFirewall, @Nullable List<com.google.api.services.compute.model.Firewall> rules) {
        Firewall firewall = new Firewall();
        firewall.setProviderFirewallId("fw-" + googleFirewall.getName());
        firewall.setVisibleScope(VisibleScope.ACCOUNT_GLOBAL);
        firewall.setAvailable(true);
        firewall.setActive(true);
        firewall.setName(googleFirewall.getName() + " Firewall");
        firewall.setDescription(googleFirewall.getDescription());
        firewall.setProviderVlanId(googleFirewall.getName());
        if (rules != null) {
            firewall.setRules(this.toFirewallRules(rules));
        }
        return firewall;
    }

    @Nonnull
    private Collection<FirewallRule> toFirewallRules(@Nonnull List<com.google.api.services.compute.model.Firewall> rules) {
        ArrayList<FirewallRule> firewallRules = new ArrayList<FirewallRule>();
        for (com.google.api.services.compute.model.Firewall googleRule : rules) {
            ArrayList<RuleTarget> sources = new ArrayList<RuleTarget>();
            if (googleRule.getSourceRanges() != null) {
                for (String source : googleRule.getSourceRanges()) {
                    if (InetAddressUtils.isIPv4Address((String)source)) {
                        source = source + "/32";
                    }
                    sources.add(RuleTarget.getCIDR((String)source));
                }
            } else if (googleRule.getSourceTags() != null) {
                for (String source : googleRule.getSourceTags()) {
                    sources.add(RuleTarget.getVirtualMachine((String)source));
                }
            } else {
                return firewallRules;
            }
            for (RuleTarget sourceTarget : sources) {
                String tail = "";
                if (sources.size() > 1) {
                    tail = "--" + sourceTarget.getCidr();
                }
                String vLanId = googleRule.getNetwork().substring(googleRule.getNetwork().lastIndexOf("/") + 1);
                for (Firewall.Allowed allowed : googleRule.getAllowed()) {
                    FirewallRule rule;
                    RuleTarget destinationTarget;
                    Protocol protocol = Protocol.ANY;
                    try {
                        protocol = Protocol.valueOf((String)allowed.getIPProtocol().toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                    int portStart = 0;
                    int portEnd = 0;
                    if (protocol != Protocol.ICMP) {
                        if (null == allowed || null == allowed.getPorts()) continue;
                        for (String portString : allowed.getPorts()) {
                            if (portString.indexOf("-") > 0) {
                                String[] parts = portString.split("-");
                                portStart = Integer.valueOf(parts[0]);
                                portEnd = Integer.valueOf(parts[1]);
                            } else {
                                portStart = portEnd = Integer.valueOf(portString).intValue();
                            }
                            if (googleRule.getTargetTags() != null) {
                                for (String targetTag : googleRule.getTargetTags()) {
                                    destinationTarget = RuleTarget.getVirtualMachine((String)targetTag);
                                    FirewallRule rule2 = FirewallRule.getInstance((String)(googleRule.getName() + tail), (String)("fw-" + vLanId), (RuleTarget)sourceTarget, (Direction)Direction.INGRESS, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)destinationTarget, (int)portStart, (int)portEnd);
                                    firewallRules.add(rule2);
                                }
                                continue;
                            }
                            destinationTarget = RuleTarget.getVlan((String)vLanId);
                            rule = FirewallRule.getInstance((String)(googleRule.getName() + tail), (String)("fw-" + vLanId), (RuleTarget)sourceTarget, (Direction)Direction.INGRESS, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)destinationTarget, (int)portStart, (int)portEnd);
                            firewallRules.add(rule);
                        }
                        continue;
                    }
                    if (googleRule.getTargetTags() != null) {
                        for (String targetTag : googleRule.getTargetTags()) {
                            destinationTarget = RuleTarget.getVirtualMachine((String)targetTag);
                            rule = FirewallRule.getInstance((String)(googleRule.getName() + tail), (String)("fw-" + vLanId), (RuleTarget)sourceTarget, (Direction)Direction.INGRESS, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)destinationTarget, (int)portStart, (int)portEnd);
                            firewallRules.add(rule);
                        }
                        continue;
                    }
                    destinationTarget = RuleTarget.getVlan((String)vLanId);
                    FirewallRule rule3 = FirewallRule.getInstance((String)(googleRule.getName() + tail), (String)("fw-" + vLanId), (RuleTarget)sourceTarget, (Direction)Direction.INGRESS, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)destinationTarget, (int)portStart, (int)portEnd);
                    firewallRules.add(rule3);
                }
            }
        }
        return firewallRules;
    }

    @Nonnull
    public Map<FirewallConstraints.Constraint, Object> getActiveConstraintsForFirewall(@Nonnull String firewallId) throws CloudException, InternalException {
        Firewall firewall = this.getFirewall(firewallId);
        RuleTarget sourceTarget = ((FirewallRule)firewall.getRules().iterator().next()).getSourceEndpoint();
        HashMap<FirewallConstraints.Constraint, Object> constraints = new HashMap<FirewallConstraints.Constraint, Object>();
        constraints.put(FirewallConstraints.Constraint.PERMISSION, Permission.ALLOW);
        constraints.put(FirewallConstraints.Constraint.DIRECTION, Direction.INGRESS);
        constraints.put(FirewallConstraints.Constraint.SOURCE, sourceTarget);
        return constraints;
    }

    @Deprecated
    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "firewall";
    }
}

