/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.network;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AddressAggregatedList;
import com.google.api.services.compute.model.AddressList;
import com.google.api.services.compute.model.AddressesScopedList;
import com.google.api.services.compute.model.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCEIPAddressCapabilities;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AbstractIpAddressSupport;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.util.APITrace;

public class IPAddressSupport
extends AbstractIpAddressSupport<Google> {
    private static final ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private static final Logger logger = Google.getLogger(IPAddressSupport.class);
    private volatile transient GCEIPAddressCapabilities capabilities;
    private ListIpPoolCallable task;

    protected IPAddressSupport(Google provider) {
        super((CloudProvider)provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(@Nonnull String addressId, @Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.assign");
        try {
            Compute gce = ((Google)this.getProvider()).getGoogleCompute();
            IpAddress ipAddress = this.getIpAddress(addressId);
            VirtualMachine vm = ((Google)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(serverId);
            AccessConfig accessConfig = new AccessConfig();
            accessConfig.setName("External NAT");
            accessConfig.setKind("compute#accessConfig");
            accessConfig.setType("ONE_TO_ONE_NAT");
            accessConfig.setNatIP(ipAddress.getRawAddress().getIpAddress());
            try {
                Operation job;
                GoogleMethod method = new GoogleMethod((Google)this.getProvider());
                try {
                    job = (Operation)gce.instances().deleteAccessConfig(this.getContext().getAccountNumber(), vm.getProviderDataCenterId(), vm.getName(), "External NAT", "nic0").execute();
                    method.getOperationComplete(this.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", vm.getProviderDataCenterId());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                job = (Operation)gce.instances().addAccessConfig(this.getContext().getAccountNumber(), vm.getProviderDataCenterId(), serverId, "nic0", accessConfig).execute();
                if (!method.getOperationComplete(this.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", vm.getProviderDataCenterId())) {
                    throw new CloudException("An error occurred assigning the IP: " + addressId + ": Operation timed out");
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred assigning the IP: " + addressId + ": " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support NICs");
    }

    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String onServerId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Forwarding rules are not supported by GCE");
    }

    @Nonnull
    public GCEIPAddressCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GCEIPAddressCapabilities((Google)this.getProvider());
        }
        return this.capabilities;
    }

    @Nullable
    public IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.getIpAddress");
        try {
            block10: {
                Compute gce = ((Google)this.getProvider()).getGoogleCompute();
                AddressAggregatedList addressList = (AddressAggregatedList)gce.addresses().aggregatedList(this.getContext().getAccountNumber()).setFilter("name eq " + addressId).execute();
                if (addressList == null || addressList.getItems() == null || addressList.getItems().isEmpty()) break block10;
                for (String region : addressList.getItems().keySet()) {
                    if (addressList.getItems() == null || addressList.getItems().get(region) == null || ((AddressesScopedList)addressList.getItems().get(region)).getAddresses() == null || ((AddressesScopedList)addressList.getItems().get(region)).getAddresses().isEmpty()) continue;
                    for (Address address : ((AddressesScopedList)addressList.getItems().get(region)).getAddresses()) {
                        if (address.getName().equals(addressId)) {
                            IpAddress ipAddress = this.toIpAddress(address);
                            return ipAddress;
                        }
                        try {
                        }
                        catch (IOException ex) {
                            logger.error((Object)ex.getMessage());
                            if (ex.getClass() == GoogleJsonResponseException.class) {
                                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                            }
                            throw new CloudException("An error occurred getting the IPAddress: " + ex.getMessage());
                        }
                    }
                }
            }
            throw new InternalException("Could not find IPAddress: " + addressId);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getIpAddressIdFromIP(@Nonnull String ipAddress, @Nonnull String regionId) throws InternalException, CloudException {
        try {
            Compute gce = ((Google)this.getProvider()).getGoogleCompute();
            AddressList addressList = (AddressList)gce.addresses().list(this.getContext().getAccountNumber(), regionId).execute();
            if (addressList != null && addressList.getItems() != null && !addressList.getItems().isEmpty()) {
                for (Address address : addressList.getItems()) {
                    if (!ipAddress.equals(address.getAddress())) continue;
                    return address.getName();
                }
            }
            throw new InternalException("An address could not be found matching " + ipAddress + " in " + regionId);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred finding the specified IPAddress: " + ex.getMessage());
        }
    }

    @Deprecated
    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "Address";
    }

    @Deprecated
    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Deprecated
    public boolean isAssigned(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC);
    }

    @Deprecated
    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    @Deprecated
    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return true;
    }

    @Deprecated
    public boolean isForwarding() {
        return false;
    }

    @Deprecated
    public boolean isForwarding(IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    @Deprecated
    public boolean isRequestable(@Nonnull AddressType type) {
        return true;
    }

    @Deprecated
    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<IpAddress> listPrivateIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpAddress> listPublicIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return this.listIpPool(IPVersion.IPV4, unassignedOnly);
    }

    @Nonnull
    public Iterable<IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.listIpPool");
        try {
            if (!version.equals((Object)IPVersion.IPV4)) {
                List<IpAddress> list = Collections.emptyList();
                return list;
            }
            ArrayList<IpAddress> addresses = new ArrayList<IpAddress>();
            try {
                Compute gce = ((Google)this.getProvider()).getGoogleCompute();
                AddressList addressList = (AddressList)gce.addresses().list(this.getContext().getAccountNumber(), this.getContext().getRegionId()).execute();
                if (addressList != null && addressList.getItems() != null && !addressList.getItems().isEmpty()) {
                    for (Address address : addressList.getItems()) {
                        IpAddress ipAddress = this.toIpAddress(address);
                        if (ipAddress == null) continue;
                        addresses.add(ipAddress);
                    }
                }
                ArrayList<IpAddress> arrayList = addresses;
                return arrayList;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred listing IPs: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.listIpPoolStatus");
        try {
            if (!version.equals((Object)IPVersion.IPV4)) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            ArrayList<ResourceStatus> statuses = new ArrayList<ResourceStatus>();
            try {
                Compute gce = ((Google)this.getProvider()).getGoogleCompute();
                AddressAggregatedList addressList = (AddressAggregatedList)gce.addresses().aggregatedList(this.getContext().getAccountNumber()).execute();
                for (String region : addressList.getItems().keySet()) {
                    if (null == addressList || null == addressList.getItems() || null == addressList.getItems().get(region) || null == ((AddressesScopedList)addressList.getItems().get(region)).getAddresses()) continue;
                    for (Address address : ((AddressesScopedList)addressList.getItems().get(region)).getAddresses()) {
                        ResourceStatus status = this.toStatus(address);
                        if (status == null) continue;
                        statuses.add(status);
                    }
                }
                ArrayList<ResourceStatus> arrayList = statuses;
                return arrayList;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred listing IPs: " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Forwarding rules are not supported by GCE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.releaseFromPool");
        try {
            try {
                IpAddress ipAddress = this.getIpAddress(addressId);
                Compute gce = ((Google)this.getProvider()).getGoogleCompute();
                Operation job = (Operation)gce.addresses().delete(this.getContext().getAccountNumber(), ipAddress.getRegionId(), addressId).execute();
                GoogleMethod method = new GoogleMethod((Google)this.getProvider());
                if (!method.getOperationComplete(this.getContext(), job, GoogleOperationType.REGION_OPERATION, ipAddress.getRegionId(), "")) {
                    throw new CloudException("An error occurred releasing address: " + addressId + ": Operation timed out");
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred releasing address: " + addressId + ": " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.releaseFromServer");
        try {
            Compute gce = ((Google)this.getProvider()).getGoogleCompute();
            try {
                Address address = (Address)gce.addresses().get(this.getContext().getAccountNumber(), this.getContext().getRegionId(), addressId).execute();
                String zone = "";
                String instance = "";
                if (null != address.getUsers()) {
                    for (String vm : address.getUsers()) {
                        Pattern p = Pattern.compile("/zones/(.*?)/instances");
                        Matcher m = p.matcher(vm);
                        if (!m.find()) continue;
                        zone = m.group();
                        instance = vm;
                        break;
                    }
                }
                zone = zone.replace("/zones/", "");
                zone = zone.replace("/instances", "");
                instance = instance.substring(instance.lastIndexOf("/") + 1);
                Operation job = (Operation)gce.instances().deleteAccessConfig(this.getContext().getAccountNumber(), zone, instance, "External NAT", "nic0").execute();
                GoogleMethod method = new GoogleMethod((Google)this.getProvider());
                if (!method.getOperationComplete(this.getContext(), job, GoogleOperationType.ZONE_OPERATION, "", zone)) {
                    throw new CloudException("An error occurred releasing the address from the server: Operation timed out");
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred releasing the address from the server: " + ex.getMessage());
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String request(@Nonnull AddressType typeOfAddress) throws InternalException, CloudException {
        if (typeOfAddress.equals((Object)AddressType.PUBLIC)) {
            return this.request(IPVersion.IPV4);
        }
        throw new OperationNotSupportedException("GCE only supports creation of public IP Addresses");
    }

    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.request");
        try {
            if (version.equals((Object)IPVersion.IPV4)) {
                Compute gce = ((Google)this.getProvider()).getGoogleCompute();
                try {
                    Address address = new Address();
                    address.setName("a" + UUID.randomUUID().toString());
                    Operation job = (Operation)gce.addresses().insert(this.getContext().getAccountNumber(), this.getContext().getRegionId(), address).execute();
                    GoogleMethod method = new GoogleMethod((Google)this.getProvider());
                    String string = method.getOperationTarget(this.getContext(), job, GoogleOperationType.REGION_OPERATION, this.getContext().getRegionId(), "", false);
                    return string;
                }
                catch (IOException ex) {
                    logger.error((Object)ex.getMessage());
                    if (ex.getClass() == GoogleJsonResponseException.class) {
                        GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                        throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                    }
                    throw new CloudException("An error occurred requesting an IPAddress: " + ex.getMessage());
                }
            }
            throw new OperationNotSupportedException("GCE currently only supports IPv4");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support manual creation of IP Addresses for VLANs");
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("GCE does not support manual creation of IP Addresses for VLANs");
    }

    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Forwarding rules are not supported by GCE");
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return false;
    }

    private IpAddress toIpAddress(Address address) {
        IpAddress ipAddress = new IpAddress();
        ipAddress.setIpAddressId(address.getName());
        ipAddress.setAddress(address.getAddress());
        ipAddress.setRegionId(address.getRegion().substring(address.getRegion().lastIndexOf("/") + 1));
        ipAddress.setAddressType(AddressType.PUBLIC);
        ipAddress.setVersion(IPVersion.IPV4);
        ipAddress.setForVlan(false);
        if (address.getUsers() != null && address.getUsers().size() > 0) {
            for (String user : address.getUsers()) {
                user = user.substring(user.lastIndexOf("/") + 1);
                ipAddress.setServerId(user);
            }
        }
        return ipAddress;
    }

    private ResourceStatus toStatus(Address address) {
        return new ResourceStatus(address.getName(), (Object)(!address.getStatus().equals("RESERVED") ? 1 : 0));
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public Future<Iterable<IpAddress>> listIpPoolConcurrently(IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        this.task = new ListIpPoolCallable(version, unassignedOnly);
        return threadPool.submit(this.task);
    }

    public class ListIpPoolCallable
    implements Callable<Iterable<IpAddress>> {
        IPVersion version;
        boolean unassignedOnly;

        public ListIpPoolCallable(IPVersion version, boolean unassignedOnly) {
            this.version = version;
            this.unassignedOnly = unassignedOnly;
        }

        @Override
        public Iterable<IpAddress> call() throws CloudException, InternalException {
            if (!this.version.equals((Object)IPVersion.IPV4)) {
                return Collections.emptyList();
            }
            ProviderContext ctx = ((Google)IPAddressSupport.this.getProvider()).getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            ArrayList<IpAddress> list = new ArrayList<IpAddress>();
            Compute gce = ((Google)IPAddressSupport.this.getProvider()).getGoogleCompute();
            try {
                AddressList foo = (AddressList)gce.addresses().list(((Google)IPAddressSupport.this.getProvider()).getContext().getAccountNumber(), null).execute();
                for (Address item : foo.getItems()) {
                    IpAddress ipAddress = new IpAddress();
                    ipAddress.setAddress(item.getAddress());
                    ipAddress.setIpAddressId(item.getName());
                    ipAddress.setVersion(IPVersion.IPV4);
                    ipAddress.setRegionId(item.getRegion());
                    list.add(ipAddress);
                }
            }
            catch (IOException e) {
                throw new OperationNotSupportedException("Problem obtaining results for listIpPoolConcurrently");
            }
            return list;
        }
    }
}

