/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.network;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.HealthCheckReference;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolList;
import com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCELoadBalancerCapabilities;
import org.dasein.cloud.google.network.IPAddressSupport;
import org.dasein.cloud.network.AbstractLoadBalancerSupport;
import org.dasein.cloud.network.HealthCheckFilterOptions;
import org.dasein.cloud.network.HealthCheckOptions;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointState;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LbType;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;
import org.dasein.cloud.network.LoadBalancerCreateOptions;
import org.dasein.cloud.network.LoadBalancerEndpoint;
import org.dasein.cloud.network.LoadBalancerHealthCheck;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.util.APITrace;

public class LoadBalancerSupport
extends AbstractLoadBalancerSupport<Google> {
    private static final Logger logger = Logger.getLogger(AbstractLoadBalancerSupport.class);
    private volatile transient GCELoadBalancerCapabilities capabilities;
    private Google provider = null;
    private ProviderContext ctx = null;
    private Compute gce = null;

    public LoadBalancerSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
        this.ctx = provider.getContext();
    }

    @Nonnull
    public LoadBalancerCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new GCELoadBalancerCapabilities(this.provider);
        }
        return this.capabilities;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    private void releaseLoadBalancerIp(@Nonnull LoadBalancer lb) throws CloudException, InternalException {
        try {
            if (lb.getAddress() != null && !lb.getAddress().equals("")) {
                IPAddressSupport ipSupport = this.provider.getNetworkServices().getIpAddressSupport();
                String ip = lb.getAddress();
                if (ip != null) {
                    ipSupport.releaseFromPool(ipSupport.getIpAddressIdFromIP(ip, this.provider.getContext().getRegionId()));
                }
            }
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
    }

    public void removeLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeLoadBalancer");
        this.gce = this.provider.getGoogleCompute();
        LoadBalancer lb = this.getLoadBalancer(loadBalancerId);
        List<String> forwardingRuleNames = this.getForwardingRules(loadBalancerId);
        for (String forwardingRuleName : forwardingRuleNames) {
            if (forwardingRuleName == null) continue;
            this.removeLoadBalancerForwardingRule(forwardingRuleName);
        }
        this.releaseLoadBalancerIp(lb);
        try {
            String healthCheckName = this.getLoadBalancerHealthCheckName(loadBalancerId);
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation job = (Operation)this.gce.targetPools().delete(this.ctx.getAccountNumber(), this.ctx.getRegionId(), loadBalancerId).execute();
            method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
            if (null != healthCheckName) {
                this.removeLoadBalancerHealthCheck(healthCheckName);
            }
        }
        catch (CloudException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    public String getLoadBalancerHealthCheckName(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        List hcs;
        TargetPool tp;
        this.gce = this.provider.getGoogleCompute();
        try {
            tp = (TargetPool)this.gce.targetPools().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), loadBalancerId).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        String healthCheck = null;
        if (tp != null && (hcs = tp.getHealthChecks()) != null && hcs.size() > 0) {
            healthCheck = (String)hcs.get(0);
            healthCheck = healthCheck.substring(healthCheck.lastIndexOf("/") + 1);
        }
        return healthCheck;
    }

    private List<String> getForwardingRules(String targetPoolName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.getForwardingRule");
        this.gce = this.provider.getGoogleCompute();
        ArrayList<String> forwardingRuleNames = new ArrayList<String>();
        try {
            ForwardingRuleList result = (ForwardingRuleList)this.gce.forwardingRules().list(this.ctx.getAccountNumber(), this.ctx.getRegionId()).execute();
            if (result != null && result.getItems() != null) {
                for (ForwardingRule fr : result.getItems()) {
                    String forwardingRuleTarget = fr.getTarget();
                    if (!targetPoolName.equals(forwardingRuleTarget = forwardingRuleTarget.substring(forwardingRuleTarget.lastIndexOf("/") + 1))) continue;
                    forwardingRuleNames.add(fr.getName());
                }
            }
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
        return forwardingRuleNames;
    }

    private int flatten(@Nonnull String portRange) throws CloudException {
        String[] ports = portRange.split("-");
        if (ports[0].equals(ports[1])) {
            return new Integer(ports[0]);
        }
        throw new CloudException("expected a port range like 80-80, got " + portRange);
    }

    private LbProtocol standardizeGCEProtocol(@Nonnull String protocol) {
        if (protocol.equals("TCP")) {
            return LbProtocol.RAW_TCP;
        }
        return LbProtocol.valueOf((String)protocol);
    }

    private boolean isIPAddressInUse(@Nonnull String ipAddress, HashMap<String, ForwardingRule> rules) {
        for (String ruleName : rules.keySet()) {
            if (!rules.get(ruleName).getIPAddress().equals(ipAddress)) continue;
            return true;
        }
        return false;
    }

    public void removeListeners(String toLoadBalancerId, LbListener[] listeners) throws CloudException, InternalException {
        this.gce = this.provider.getGoogleCompute();
        ForwardingRule forwardingRule = null;
        List<String> existingForwardingRuleNames = this.getForwardingRules(toLoadBalancerId);
        try {
            HashMap<String, ForwardingRule> existingForwardingRules = new HashMap<String, ForwardingRule>();
            for (String ruleName : existingForwardingRuleNames) {
                existingForwardingRules.put(ruleName, (ForwardingRule)this.gce.forwardingRules().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), ruleName).execute());
            }
            for (String ruleName : existingForwardingRuleNames) {
                for (LbListener listener : listeners) {
                    forwardingRule = (ForwardingRule)existingForwardingRules.get(ruleName);
                    if (forwardingRule == null || this.flatten(forwardingRule.getPortRange()) != listener.getPublicPort() || this.flatten(forwardingRule.getPortRange()) != listener.getPrivatePort() || !this.standardizeGCEProtocol(forwardingRule.getIPProtocol()).equals((Object)listener.getNetworkProtocol())) continue;
                    Operation job = (Operation)this.gce.forwardingRules().delete(this.ctx.getAccountNumber(), this.ctx.getRegionId(), ruleName).execute();
                    GoogleMethod method = new GoogleMethod(this.provider);
                    method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
                    existingForwardingRules.remove(ruleName);
                    if (this.isIPAddressInUse(forwardingRule.getIPAddress(), existingForwardingRules)) continue;
                    IPAddressSupport ipSupport = this.provider.getNetworkServices().getIpAddressSupport();
                    String ip = forwardingRule.getIPAddress();
                    if (ip == null) continue;
                    ipSupport.releaseFromPool(ipSupport.getIpAddressIdFromIP(ip, this.provider.getContext().getRegionId()));
                }
            }
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
    }

    private void removeLoadBalancerForwardingRule(String forwardingRuleName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeLoadBalancerForwardingRule");
        this.gce = this.provider.getGoogleCompute();
        try {
            Operation job = (Operation)this.gce.forwardingRules().delete(this.ctx.getAccountNumber(), this.ctx.getRegionId(), forwardingRuleName).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String createLoadBalancer(@Nonnull LoadBalancerCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.create");
        this.gce = this.provider.getGoogleCompute();
        try {
            TargetPool tp = new TargetPool();
            tp.setRegion(this.ctx.getRegionId());
            tp.setName(this.getCapabilities().getLoadBalancerNamingConstraints().convertToValidName(options.getName(), Locale.US));
            tp.setInstances(null);
            try {
                GoogleMethod method = new GoogleMethod(this.provider);
                Operation job = (Operation)this.gce.targetPools().insert(this.ctx.getAccountNumber(), this.ctx.getRegionId(), tp).execute();
                method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
            }
            catch (IOException e) {
                if (e.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException((Throwable)e);
            }
            HealthCheckOptions hco = options.getHealthCheckOptions();
            if (hco != null) {
                LoadBalancerHealthCheck hc = this.createLoadBalancerHealthCheck(hco.getName(), hco.getDescription(), hco.getHost(), hco.getProtocol(), hco.getPort(), hco.getPath(), hco.getInterval(), hco.getTimeout(), hco.getHealthyCount(), hco.getUnhealthyCount());
                this.attachHealthCheckToLoadBalancer(options.getName(), options.getHealthCheckOptions().getName());
            }
            this.createLoadBalancerForwardingRule(options);
            String string = options.getName();
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public void addListeners(String toLoadBalancerId, LbListener[] listeners) throws CloudException, InternalException {
        this.gce = this.provider.getGoogleCompute();
        int index = 0;
        try {
            TargetPool tp = (TargetPool)this.gce.targetPools().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), toLoadBalancerId).execute();
            if (tp == null) {
                throw new CloudException("Target Pool " + toLoadBalancerId + " not found.");
            }
            List<String> forwardingRuleNames = this.getForwardingRules(toLoadBalancerId);
            String ipAddress = null;
            for (String ruleName : forwardingRuleNames) {
                int num;
                String[] ruleNameComponents;
                ForwardingRule forwardingRules = (ForwardingRule)this.gce.forwardingRules().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), ruleName).execute();
                if (null == ipAddress) {
                    ipAddress = forwardingRules.getIPAddress();
                }
                if (!(ruleNameComponents = ruleName.split("-"))[ruleNameComponents.length - 1].matches("\\d+") || (num = new Integer(ruleNameComponents[ruleNameComponents.length - 1]).intValue()) < index) continue;
                index = num + 1;
            }
            if (ipAddress == null) {
                ipAddress = this.provider.getNetworkServices().getIpAddressSupport().getIpAddress(this.provider.getNetworkServices().getIpAddressSupport().request(IPVersion.IPV4)).getRawAddress().getIpAddress();
            }
            String targetPoolSelfLink = tp.getSelfLink();
            for (LbListener listener : listeners) {
                ForwardingRule forwardingRule = new ForwardingRule();
                toLoadBalancerId = this.getCapabilities().getLoadBalancerNamingConstraints().convertToValidName(toLoadBalancerId + "-" + index++, Locale.US);
                forwardingRule.setName(toLoadBalancerId);
                forwardingRule.setDescription(toLoadBalancerId);
                forwardingRule.setIPAddress(ipAddress);
                forwardingRule.setIPProtocol("TCP");
                forwardingRule.setPortRange("" + listener.getPublicPort());
                forwardingRule.setRegion(this.ctx.getRegionId());
                forwardingRule.setTarget(targetPoolSelfLink);
                GoogleMethod method = new GoogleMethod(this.provider);
                Operation job = (Operation)this.gce.forwardingRules().insert(this.ctx.getAccountNumber(), this.ctx.getRegionId(), forwardingRule).execute();
                method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
            }
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
    }

    void createLoadBalancerForwardingRule(@Nonnull LoadBalancerCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.createLoadBalancerForwardingRule");
        this.gce = this.provider.getGoogleCompute();
        LbListener[] listeners = options.getListeners();
        String targetPoolSelfLink = null;
        try {
            TargetPool tp = (TargetPool)this.gce.targetPools().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), options.getName()).execute();
            if (tp == null) {
                throw new CloudException("Target Pool " + options.getName() + " not found.");
            }
            targetPoolSelfLink = tp.getSelfLink();
            String ipAddress = options.getProviderIpAddressId();
            if (options.getProviderIpAddressId() == null || options.getProviderIpAddressId().equals("")) {
                ipAddress = this.provider.getNetworkServices().getIpAddressSupport().getIpAddress(this.provider.getNetworkServices().getIpAddressSupport().request(IPVersion.IPV4)).getRawAddress().getIpAddress();
            }
            if (listeners.length > 0) {
                int index = 0;
                for (LbListener listener : listeners) {
                    ForwardingRule forwardingRule = new ForwardingRule();
                    String name = options.getName();
                    if (listeners.length > 1) {
                        name = name + "-" + index++;
                    }
                    name = this.getCapabilities().getLoadBalancerNamingConstraints().convertToValidName(name, Locale.US);
                    forwardingRule.setName(name);
                    forwardingRule.setDescription(options.getDescription());
                    forwardingRule.setIPAddress(ipAddress);
                    forwardingRule.setIPProtocol("TCP");
                    forwardingRule.setPortRange("" + listener.getPublicPort());
                    forwardingRule.setRegion(this.ctx.getRegionId());
                    forwardingRule.setTarget(targetPoolSelfLink);
                    GoogleMethod method = new GoogleMethod(this.provider);
                    Operation job = (Operation)this.gce.forwardingRules().insert(this.ctx.getAccountNumber(), this.ctx.getRegionId(), forwardingRule).execute();
                    method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
                }
            } else {
                ForwardingRule forwardingRule = new ForwardingRule();
                forwardingRule.setName(this.getCapabilities().getLoadBalancerNamingConstraints().convertToValidName(options.getName(), Locale.US));
                forwardingRule.setDescription("Default Forwarding Rule");
                forwardingRule.setIPAddress(ipAddress);
                forwardingRule.setIPProtocol("TCP");
                forwardingRule.setPortRange("80");
                forwardingRule.setRegion(this.ctx.getRegionId());
                forwardingRule.setTarget(targetPoolSelfLink);
                GoogleMethod method = new GoogleMethod(this.provider);
                Operation job = (Operation)this.gce.forwardingRules().insert(this.ctx.getAccountNumber(), this.ctx.getRegionId(), forwardingRule).execute();
                method.getOperationComplete(this.ctx, job, GoogleOperationType.REGION_OPERATION, this.ctx.getRegionId(), "");
            }
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    public LoadBalancerHealthCheck createLoadBalancerHealthCheck(@Nonnull HealthCheckOptions options) throws CloudException, InternalException {
        return this.createLoadBalancerHealthCheck(options.getName(), options.getDescription(), options.getHost(), LoadBalancerHealthCheck.HCProtocol.HTTP, options.getPort(), options.getPath(), options.getInterval(), options.getTimeout(), options.getHealthyCount(), options.getUnhealthyCount());
    }

    public LoadBalancerHealthCheck createLoadBalancerHealthCheck(@Nullable String name, @Nullable String description, @Nullable String host, @Nullable LoadBalancerHealthCheck.HCProtocol protocol, int port, @Nullable String path, int interval, int timeout, int healthyCount, int unhealthyCount) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.createLoadBalancerHealthCheck");
        this.gce = this.provider.getGoogleCompute();
        HttpHealthCheck hc = new HttpHealthCheck();
        try {
            name = this.getCapabilities().getLoadBalancerNamingConstraints().convertToValidName(name, Locale.US);
            hc.setName(this.getCapabilities().getLoadBalancerNamingConstraints().convertToValidName(name, Locale.US));
            hc.setDescription(description);
            hc.setHost(host);
            hc.setPort(Integer.valueOf(port));
            hc.setRequestPath(path);
            hc.setCheckIntervalSec(Integer.valueOf(interval));
            hc.setTimeoutSec(Integer.valueOf(timeout));
            hc.setHealthyThreshold(Integer.valueOf(healthyCount));
            hc.setUnhealthyThreshold(Integer.valueOf(unhealthyCount));
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation job = (Operation)this.gce.httpHealthChecks().insert(this.ctx.getAccountNumber(), hc).execute();
            method.getOperationComplete(this.ctx, job, GoogleOperationType.GLOBAL_OPERATION, this.ctx.getRegionId(), "");
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
        return this.getLoadBalancerHealthCheck(name);
    }

    public void attachHealthCheckToLoadBalancer(@Nonnull String providerLoadBalancerId, @Nonnull String providerLBHealthCheckId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.attachHealthCheckToLoadBalancer");
        this.gce = this.provider.getGoogleCompute();
        HttpHealthCheck hc = null;
        try {
            hc = (HttpHealthCheck)this.gce.httpHealthChecks().get(this.ctx.getAccountNumber(), providerLBHealthCheckId).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        ArrayList<HealthCheckReference> hcl = new ArrayList<HealthCheckReference>();
        HealthCheckReference hcr = new HealthCheckReference();
        hcr.setHealthCheck(hc.getSelfLink());
        hcl.add(hcr);
        TargetPoolsAddHealthCheckRequest tphcr = new TargetPoolsAddHealthCheckRequest();
        tphcr.setHealthChecks(hcl);
        try {
            this.gce.targetPools().addHealthCheck(this.ctx.getAccountNumber(), this.ctx.getRegionId(), providerLoadBalancerId, tphcr).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    public LoadBalancerHealthCheck toLoadBalancerHealthCheck(String loadBalancerName, HttpHealthCheck hc) throws CloudException, InternalException {
        LoadBalancerHealthCheck.HCProtocol protocol = LoadBalancerHealthCheck.HCProtocol.TCP;
        if (loadBalancerName == null) {
            throw new InternalException("loadBalancerName was null. Name is required");
        }
        if (hc == null) {
            throw new InternalException("HttpHealthCheck was null");
        }
        Integer port = -1;
        if (hc.getPort() != null && ((port = hc.getPort()) == 80 || port == 8080)) {
            protocol = LoadBalancerHealthCheck.HCProtocol.HTTP;
        }
        Integer checkIntervalSecond = -1;
        if (hc.getCheckIntervalSec() != null) {
            checkIntervalSecond = hc.getCheckIntervalSec();
        }
        Integer timeoutSec = -1;
        if (hc.getTimeoutSec() != null) {
            timeoutSec = hc.getTimeoutSec();
        }
        Integer healthyThreshold = -1;
        if (hc.getHealthyThreshold() != null) {
            healthyThreshold = hc.getHealthyThreshold();
        }
        Integer unhealthyThreshold = -1;
        if (hc.getUnhealthyThreshold() != null) {
            unhealthyThreshold = hc.getUnhealthyThreshold();
        }
        LoadBalancerHealthCheck lbhc = LoadBalancerHealthCheck.getInstance((String)loadBalancerName, (String)hc.getName(), (String)hc.getDescription(), (String)hc.getHost(), (LoadBalancerHealthCheck.HCProtocol)protocol, (int)port, (String)hc.getRequestPath(), (int)checkIntervalSecond, (int)timeoutSec, (int)healthyThreshold, (int)unhealthyThreshold);
        lbhc.addProviderLoadBalancerId(loadBalancerName);
        return lbhc;
    }

    public Iterable<LoadBalancerHealthCheck> listLBHealthChecks(@Nullable HealthCheckFilterOptions opts) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLBHealthChecks");
        this.gce = this.provider.getGoogleCompute();
        ArrayList<LoadBalancerHealthCheck> lbhc = new ArrayList<LoadBalancerHealthCheck>();
        try {
            TargetPoolList tpl = (TargetPoolList)this.gce.targetPools().list(this.ctx.getAccountNumber(), this.ctx.getRegionId()).execute();
            if (tpl.getItems() != null) {
                for (TargetPool lb : tpl.getItems()) {
                    String healthCheckName;
                    String loadBalancerName = lb.getName();
                    List hcs = lb.getHealthChecks();
                    if (hcs == null || hcs.isEmpty() || (healthCheckName = (String)hcs.get(0)) == null) continue;
                    healthCheckName = healthCheckName.substring(healthCheckName.lastIndexOf("/") + 1);
                    HttpHealthCheck hc = (HttpHealthCheck)this.gce.httpHealthChecks().get(this.ctx.getAccountNumber(), healthCheckName).execute();
                    if (hc == null) continue;
                    LoadBalancerHealthCheck healthCheckItem = this.toLoadBalancerHealthCheck(loadBalancerName, hc);
                    lbhc.add(healthCheckItem);
                }
            }
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
        return lbhc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadBalancerHealthCheck(String healthCheckId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeLoadBalancerHealthCheck");
        this.gce = this.provider.getGoogleCompute();
        try {
            Operation job = (Operation)this.gce.httpHealthChecks().delete(this.ctx.getAccountNumber(), healthCheckId).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            boolean result = method.getOperationComplete(this.ctx, job, GoogleOperationType.GLOBAL_OPERATION, this.ctx.getRegionId(), "");
        }
        catch (IOException e) {
            if (!e.getMessage().endsWith("was not found")) {
                if (e.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException((Throwable)e);
            }
        }
        catch (Exception e) {
            if (!e.getMessage().contains(" is already being used by ")) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public LoadBalancerHealthCheck modifyHealthCheck(@Nonnull String providerLBHealthCheckId, @Nonnull HealthCheckOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.modifyHealthCheck");
        this.gce = this.provider.getGoogleCompute();
        HttpHealthCheck hc = null;
        try {
            hc = (HttpHealthCheck)this.gce.httpHealthChecks().get(this.ctx.getAccountNumber(), providerLBHealthCheckId).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        if (options.getName() != null) {
            hc.setName(options.getName());
        }
        hc.setDescription(options.getDescription());
        hc.setHost(options.getHost());
        hc.setRequestPath(options.getPath());
        hc.setPort(Integer.valueOf(options.getPort()));
        hc.setCheckIntervalSec(Integer.valueOf(options.getInterval()));
        hc.setTimeoutSec(Integer.valueOf(options.getTimeout()));
        hc.setHealthyThreshold(Integer.valueOf(options.getHealthyCount()));
        hc.setUnhealthyThreshold(Integer.valueOf(options.getUnhealthyCount()));
        try {
            this.gce.httpHealthChecks().update(this.ctx.getAccountNumber(), providerLBHealthCheckId, hc).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
        return this.getLoadBalancerHealthCheck(providerLBHealthCheckId);
    }

    public LoadBalancerHealthCheck getLoadBalancerHealthCheck(@Nonnull String providerLBHealthCheckId, @Nullable String providerLoadBalancerId) throws CloudException, InternalException {
        return this.getLoadBalancerHealthCheck(providerLBHealthCheckId);
    }

    private LoadBalancerHealthCheck getLoadBalancerHealthCheck(@Nonnull String providerLBHealthCheckId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.getLoadBalancerHealthCheck");
        this.gce = this.provider.getGoogleCompute();
        HttpHealthCheck hc = null;
        LoadBalancerHealthCheck lbhc = null;
        try {
            hc = (HttpHealthCheck)this.gce.httpHealthChecks().get(this.ctx.getAccountNumber(), providerLBHealthCheckId).execute();
            lbhc = this.toLoadBalancerHealthCheck(providerLBHealthCheckId, hc);
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
        return lbhc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LoadBalancer getLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.getLoadBalancer");
        this.gce = this.provider.getGoogleCompute();
        LoadBalancer lb = null;
        try {
            TargetPool tp = (TargetPool)this.gce.targetPools().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), loadBalancerId).execute();
            lb = this.toLoadBalancer(tp);
        }
        catch (Exception e) {
            lb = null;
        }
        finally {
            APITrace.end();
        }
        return lb;
    }

    public void addServers(@Nonnull String toLoadBalancerId, String ... serverIdsToAdd) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.addServers");
        this.gce = this.provider.getGoogleCompute();
        String vmRegion = null;
        try {
            ArrayList<InstanceReference> instances = new ArrayList<InstanceReference>();
            for (String server : serverIdsToAdd) {
                VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(server);
                vmRegion = vm.getProviderRegionId();
                instances.add(new InstanceReference().setInstance((String)vm.getTag("contentLink")));
            }
            this.gce.targetPools().addInstance(this.ctx.getAccountNumber(), vmRegion, toLoadBalancerId, new TargetPoolsAddInstanceRequest().setInstances(instances)).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    public void removeServers(@Nonnull String fromLoadBalancerId, String ... serverIdsToRemove) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeServers");
        this.gce = this.provider.getGoogleCompute();
        ArrayList<InstanceReference> replacementInstances = new ArrayList<InstanceReference>();
        try {
            TargetPool tp = (TargetPool)this.gce.targetPools().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), fromLoadBalancerId).execute();
            if (tp == null) {
                throw new CloudException("Target Pool " + fromLoadBalancerId + " not found.");
            }
            List instances = tp.getInstances();
            for (String i : instances) {
                for (String serverToRemove : serverIdsToRemove) {
                    String serverVmNameToRemove = this.provider.getComputeServices().getVirtualMachineSupport().getVmNameFromId(serverToRemove);
                    if (!i.endsWith(serverVmNameToRemove)) continue;
                    replacementInstances.add(new InstanceReference().setInstance(i));
                }
            }
            TargetPoolsRemoveInstanceRequest content = new TargetPoolsRemoveInstanceRequest();
            content.setInstances(replacementInstances);
            this.gce.targetPools().removeInstance(this.ctx.getAccountNumber(), this.ctx.getRegionId(), fromLoadBalancerId, content).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<LoadBalancerEndpoint> listEndpoints(@Nonnull String forLoadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listEndpoints");
        this.gce = this.provider.getGoogleCompute();
        TargetPool tp = null;
        try {
            tp = (TargetPool)this.gce.targetPools().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), forLoadBalancerId).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        if (tp == null) {
            throw new CloudException("Target Pool " + forLoadBalancerId + " not found.");
        }
        try {
            ArrayList<LoadBalancerEndpoint> list = new ArrayList<LoadBalancerEndpoint>();
            List instances = tp.getInstances();
            if (instances != null) {
                for (String instanceName : instances) {
                    try {
                        String instance = this.provider.getComputeServices().getVirtualMachineSupport().getVmIdFromName(instanceName.substring(1 + instanceName.lastIndexOf("/")));
                        list.add(LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.VM, (String)instance, (LbEndpointState)LbEndpointState.ACTIVE));
                    }
                    catch (CloudException e) {
                        logger.warn((Object)("VM instance " + instanceName.substring(1 + instanceName.lastIndexOf("/")) + " referenced by load balancer end point does not exist."));
                    }
                }
            }
            ArrayList<LoadBalancerEndpoint> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listLoadBalancerStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLoadBalancers");
        this.gce = this.provider.getGoogleCompute();
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        try {
            TargetPoolList tpl = (TargetPoolList)this.gce.targetPools().list(this.ctx.getAccountNumber(), this.ctx.getRegionId()).execute();
            if (tpl != null && tpl.getItems() != null) {
                for (TargetPool lb : tpl.getItems()) {
                    List healthChecks = lb.getHealthChecks();
                    if (null == healthChecks) {
                        list.add(new ResourceStatus(lb.getName(), (Object)"UNKNOWN"));
                        continue;
                    }
                    for (String healthCheckName : healthChecks) {
                        healthCheckName = healthCheckName.substring(healthCheckName.lastIndexOf("/") + 1);
                        LoadBalancerHealthCheck healthCheck = this.getLoadBalancerHealthCheck(healthCheckName);
                        list.add(new ResourceStatus(lb.getName(), (Object)"UNKNOWN"));
                    }
                }
            }
            ArrayList<ResourceStatus> loadBalancers = list;
            return loadBalancers;
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<LoadBalancer> listLoadBalancers() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLoadBalancers");
        this.gce = this.provider.getGoogleCompute();
        ArrayList<LoadBalancer> list = new ArrayList<LoadBalancer>();
        try {
            if (null == this.ctx.getAccountNumber()) {
                throw new InternalException("Account number cannot be null");
            }
            if (null == this.ctx.getRegionId()) {
                throw new InternalException("RegionId cannot be null");
            }
            TargetPoolList tpl = (TargetPoolList)this.gce.targetPools().list(this.ctx.getAccountNumber(), this.ctx.getRegionId()).execute();
            if (tpl != null && tpl.getItems() != null) {
                for (TargetPool lb : tpl.getItems()) {
                    LoadBalancer loadBalancer = this.toLoadBalancer(lb);
                    if (loadBalancer == null) continue;
                    list.add(loadBalancer);
                }
            }
            ArrayList<LoadBalancer> loadBalancers = list;
            return loadBalancers;
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    private LoadBalancer toLoadBalancer(TargetPool tp) throws CloudException, InternalException {
        String description;
        this.gce = this.provider.getGoogleCompute();
        List hcl = tp.getHealthChecks();
        String healthCheckName = null;
        if (hcl != null && !hcl.isEmpty()) {
            healthCheckName = (String)hcl.get(0);
            healthCheckName = healthCheckName.substring(healthCheckName.lastIndexOf("/") + 1);
        }
        long created = 0L;
        try {
            created = this.provider.parseTime(tp.getCreationTimestamp());
        }
        catch (CloudException e) {
            throw new CloudException((Throwable)e);
        }
        ForwardingRule fr = null;
        String forwardingRuleAddress = null;
        String forwardingRulePortRange = null;
        int[] ports = null;
        ArrayList<LbListener> listeners = new ArrayList<LbListener>();
        try {
            List<String> forwardingRuleNames = this.getForwardingRules(tp.getName());
            for (String forwardingRuleName : forwardingRuleNames) {
                fr = (ForwardingRule)this.gce.forwardingRules().get(this.ctx.getAccountNumber(), this.ctx.getRegionId(), forwardingRuleName).execute();
                if (fr == null) continue;
                forwardingRuleAddress = fr.getIPAddress();
                forwardingRulePortRange = fr.getPortRange();
                for (int port : ports = this.portsToRange(forwardingRulePortRange)) {
                    listeners.add(LbListener.getInstance((LbAlgorithm)LbAlgorithm.SOURCE, (LbPersistence)LbPersistence.SUBNET, (LbProtocol)this.standardizeGCEProtocol(fr.getIPProtocol()), (int)port, (int)port));
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String region = tp.getRegion();
        region = region.substring(region.lastIndexOf("/") + 1);
        ArrayList<String> zones = new ArrayList<String>();
        try {
            Region puzzle = (Region)this.gce.regions().get(this.ctx.getAccountNumber(), this.ctx.getRegionId()).execute();
            List longZones = puzzle.getZones();
            for (String zone : longZones) {
                zone = zone.substring(zone.lastIndexOf("/") + 1);
                zones.add(zone);
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        if (null == (description = tp.getDescription())) {
            description = tp.getName();
        }
        String[] dataCenterIDs = new String[zones.size()];
        dataCenterIDs = zones.toArray(dataCenterIDs);
        LoadBalancer lb = LoadBalancer.getInstance((String)this.ctx.getAccountNumber(), (String)region, (String)tp.getName(), (LoadBalancerState)LoadBalancerState.ACTIVE, (String)tp.getName(), (String)description, (LbType)LbType.EXTERNAL, (LoadBalancerAddressType)LoadBalancerAddressType.DNS, (String)forwardingRuleAddress, (String)healthCheckName, (int[])ports).operatingIn(dataCenterIDs).supportingTraffic(new IPVersion[]{IPVersion.IPV4}).createdAt(created);
        LbListener[] LBListeners = new LbListener[listeners.size()];
        LBListeners = listeners.toArray(LBListeners);
        if (!listeners.isEmpty()) {
            lb = lb.withListeners(LBListeners);
        }
        return lb;
    }

    private int[] portsToRange(String portRange) {
        int[] ports;
        if (portRange.contains("-")) {
            String[] parts = portRange.split("-");
            int start = new Integer(parts[0]);
            int end = new Integer(parts[1]);
            ports = new int[end - start + 1];
            for (int x = 0; x < end - start + 1; ++x) {
                ports[x] = start + x;
            }
        } else {
            ports = new int[]{new Integer(portRange)};
        }
        return ports;
    }
}

