/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.network;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Route;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.GoogleOperationType;
import org.dasein.cloud.google.capabilities.GCENetworkCapabilities;
import org.dasein.cloud.google.network.FirewallSupport;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.util.APITrace;

public class NetworkSupport
extends AbstractVLANSupport {
    private static final Logger logger = Google.getLogger(NetworkSupport.class);
    private Google provider;
    private volatile transient GCENetworkCapabilities capabilities;

    NetworkSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public org.dasein.cloud.network.Route addRouteToAddress(String toRoutingTableId, IPVersion version, String destinationCidr, String address) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE currently only supports routing to instances.");
    }

    public org.dasein.cloud.network.Route addRouteToGateway(String toRoutingTableId, IPVersion version, String destinationCidr, String gatewayId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE currently only supports routing to instances.");
    }

    public org.dasein.cloud.network.Route addRouteToNetworkInterface(String toRoutingTableId, IPVersion version, String destinationCidr, String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE currently only supports routing to instances.");
    }

    public org.dasein.cloud.network.Route addRouteToVirtualMachine(String toRoutingTableId, IPVersion version, String destinationCidr, String vmId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            logger.error((Object)"No context was set for this request");
            throw new InternalException("No context was set for this request");
        }
        Operation job = null;
        try {
            Compute gce = this.provider.getGoogleCompute();
            VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
            Route route = new Route();
            route.setName((destinationCidr + "-" + vmId).toLowerCase());
            route.setDestRange(destinationCidr);
            route.setNextHopInstance((String)vm.getTag("contentLink"));
            route.setNextHopIp(vm.getPrivateAddresses()[0].getIpAddress());
            route.setNextHopGateway("/projects/<project-id>/global/gateways/default-internet-gateway");
            job = (Operation)gce.routes().insert(ctx.getAccountNumber(), route).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            String routeName = method.getOperationTarget(ctx, job, GoogleOperationType.GLOBAL_OPERATION, "", "", false);
            Route googleRoute = (Route)gce.routes().get(ctx.getAccountNumber(), routeName).execute();
            org.dasein.cloud.network.Route r = this.toRoute(googleRoute);
            return r;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while creating the route: " + ex.getMessage());
        }
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nonnull String domainName, @Nonnull String[] dnsServers, @Nonnull String[] ntpServers) throws CloudException, InternalException {
        if (!this.getCapabilities().allowsNewVlanCreation()) {
            throw new OperationNotSupportedException();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            logger.error((Object)"No context was set for this request");
            throw new InternalException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            logger.error((Object)"No region was set for this request");
            throw new CloudException("No region was set for this request");
        }
        Operation job = null;
        try {
            Compute gce = this.provider.getGoogleCompute();
            Network network = new Network();
            name = this.getCapabilities().getVlanNamingConstraints().convertToValidName(name, Locale.US);
            network.setName(name);
            network.setDescription(description);
            network.setIPv4Range(cidr);
            job = (Operation)gce.networks().insert(ctx.getAccountNumber(), network).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            String vLanName = method.getOperationTarget(ctx, job, GoogleOperationType.GLOBAL_OPERATION, "", "", false);
            Network googleVLan = (Network)gce.networks().get(ctx.getAccountNumber(), vLanName).execute();
            VLAN vLan = this.toVlan(googleVLan, ctx);
            return vLan;
        }
        catch (IOException ex) {
            logger.error((Object)("An error occurred while creating vlan: " + ex.getMessage()));
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while creating vlan: " + ex.getMessage());
        }
    }

    @Nonnull
    public GCENetworkCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GCENetworkCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Deprecated
    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "network interface";
    }

    @Deprecated
    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Deprecated
    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "";
    }

    public NetworkInterface getNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        Iterable<NetworkInterface> nicList = this.listNetworkInterfaces();
        for (NetworkInterface nic : nicList) {
            if (!nic.getName().equals(nicId)) continue;
            return nic;
        }
        return null;
    }

    public RoutingTable getRoutingTableForVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported.");
    }

    @Nullable
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        try {
            Compute gce = this.provider.getGoogleCompute();
            Network network = (Network)gce.networks().get(ctx.getAccountNumber(), vlanId).execute();
            return this.toVlan(network, ctx);
        }
        catch (IOException ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("404 Not Found")) {
                return null;
            }
            logger.error((Object)("An error occurred while getting network " + vlanId + ": " + ex.getMessage()));
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException(ex.getMessage());
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Collection<String> listFirewallIdsForNIC(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not currently implemented for " + this.provider.getCloudName());
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String vlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not currently implemented for " + this.provider.getCloudName());
    }

    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not currently implemented for " + this.provider.getCloudName());
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not currently implemented for " + this.provider.getCloudName());
    }

    public void removeInternetGatewayById(@Nonnull String id) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not currently implemented for " + this.provider.getCloudName());
    }

    @Nonnull
    public Iterable<ResourceStatus> listNetworkInterfaceStatus() throws CloudException, InternalException {
        Iterable<NetworkInterface> nicList = this.listNetworkInterfaces();
        ArrayList<ResourceStatus> status = new ArrayList<ResourceStatus>();
        for (NetworkInterface nic : nicList) {
            status.add(new ResourceStatus(nic.getName(), (Object)nic.getCurrentState()));
        }
        return status;
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not currently implemented for " + this.provider.getCloudName());
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesForVM(@Nonnull String forVmId) throws CloudException, InternalException {
        Iterable<NetworkInterface> nics = this.listNetworkInterfaces();
        ArrayList<NetworkInterface> vmNics = new ArrayList<NetworkInterface>();
        for (NetworkInterface nic : nics) {
            if (!nic.getProviderVirtualMachineId().equals(forVmId)) continue;
            vmNics.add(nic);
        }
        return vmNics;
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Subnets are not supported by GCE.");
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(@Nonnull String vlanId) throws CloudException, InternalException {
        Iterable<NetworkInterface> nics = this.listNetworkInterfaces();
        ArrayList<NetworkInterface> vlanNics = new ArrayList<NetworkInterface>();
        for (NetworkInterface nic : nics) {
            if (!nic.getProviderVlanId().equals(vlanId)) continue;
            vlanNics.add(nic);
        }
        return vlanNics;
    }

    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        ArrayList<Networkable> resources = new ArrayList<Networkable>();
        Iterable<NetworkInterface> nics = this.listNetworkInterfacesInVLAN(inVlanId);
        for (NetworkInterface nic : nics) {
            IpAddress ip = new IpAddress();
            ip.setVersion(IPVersion.IPV4);
            ip.setProviderNetworkInterfaceId(nic.getProviderNetworkInterfaceId());
            ip.setRegionId(nic.getProviderRegionId());
            ip.setServerId(nic.getProviderVirtualMachineId());
            ip.setProviderVlanId(nic.getProviderVlanId());
            resources.add((Networkable)ip);
        }
        return resources;
    }

    @Nonnull
    public Iterable<RoutingTable> listRoutingTables(@Nonnull String inVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables and subnets not supported.");
    }

    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String inVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Subnets not supported.");
    }

    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"VLAN.listVlanStatus");
        try {
            Compute gce = this.provider.getGoogleCompute();
            ArrayList<ResourceStatus> statuses = new ArrayList<ResourceStatus>();
            try {
                NetworkList networks = (NetworkList)gce.networks().list(this.provider.getContext().getAccountNumber()).execute();
                for (Network network : networks.getItems()) {
                    statuses.add(new ResourceStatus(network.getName(), (Object)VLANState.AVAILABLE));
                }
                ArrayList<ResourceStatus> i$ = statuses;
                return i$;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred getting VLAN statuses");
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was established");
        }
        ArrayList<VLAN> vlans = new ArrayList<VLAN>();
        try {
            List networks;
            Compute gce = this.provider.getGoogleCompute();
            NetworkList networkList = (NetworkList)gce.networks().list(ctx.getAccountNumber()).execute();
            if (null != networkList && (networks = networkList.getItems()) != null) {
                for (Network net : networks) {
                    VLAN vlan = this.toVlan(net, ctx);
                    if (vlan == null) continue;
                    vlans.add(vlan);
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred while listing VLans: " + ex.getMessage());
        }
        catch (Exception e) {
            throw new CloudException("An error occurred while listing VLans for " + ctx.getAccountNumber() + ": " + e.getMessage());
        }
        return vlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"VLAN.removeVlan");
        try {
            Operation job = null;
            try {
                Compute gce = this.provider.getGoogleCompute();
                VLAN vlan = this.getVlan(vlanId);
                FirewallSupport fws = new FirewallSupport(this.provider);
                Iterable rules = fws.getRules("fw-" + vlanId);
                for (FirewallRule rule : rules) {
                    fws.revoke(rule.getProviderRuleId());
                }
                job = (Operation)gce.networks().delete(this.provider.getContext().getAccountNumber(), vlan.getName()).execute();
                GoogleMethod method = new GoogleMethod(this.provider);
                if (!method.getOperationComplete(this.provider.getContext(), job, GoogleOperationType.GLOBAL_OPERATION, "", "")) {
                    throw new CloudException("An error occurred while removing network: " + vlanId + ": Operation timed out");
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)ex;
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred while removing network: " + vlanId + ": " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private VLAN toVlan(Network network, ProviderContext ctx) {
        VLAN vLan = new VLAN();
        vLan.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        if (null != network.getName()) {
            vLan.setProviderVlanId(network.getName());
        }
        if (null != network.getName()) {
            vLan.setName(network.getName());
        }
        if (null != network.getSelfLink()) {
            vLan.setTag("contentLink", network.getSelfLink());
        }
        if (null != network.getIPv4Range()) {
            vLan.setCidr(network.getIPv4Range());
        }
        vLan.setDescription(network.getDescription() == null || network.getDescription().equals("") ? network.getName() : network.getDescription());
        vLan.setVisibleScope(VisibleScope.ACCOUNT_GLOBAL);
        vLan.setCurrentState(VLANState.AVAILABLE);
        vLan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        return vLan;
    }

    @Nullable
    private org.dasein.cloud.network.Route toRoute(Route googleRoute) {
        return org.dasein.cloud.network.Route.getRouteToVirtualMachine((IPVersion)IPVersion.IPV4, (String)googleRoute.getDestRange(), (String)this.provider.getContext().getAccountNumber(), (String)googleRoute.getNextHopInstance());
    }

    public void removeInternetGatewayTags(String internetGatewayId, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeRoutingTableTags(String routingTableId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateRoutingTableTags(String routingTableId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateInternetGatewayTags(String internetGatewayId, Tag ... tags) throws CloudException, InternalException {
    }
}

