/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.platform;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.api.services.sqladmin.model.AclEntry;
import com.google.api.services.sqladmin.model.BackupConfiguration;
import com.google.api.services.sqladmin.model.BackupRun;
import com.google.api.services.sqladmin.model.BackupRunsListResponse;
import com.google.api.services.sqladmin.model.CloneContext;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.Flag;
import com.google.api.services.sqladmin.model.FlagsListResponse;
import com.google.api.services.sqladmin.model.InstancesCloneRequest;
import com.google.api.services.sqladmin.model.InstancesListResponse;
import com.google.api.services.sqladmin.model.InstancesRestoreBackupRequest;
import com.google.api.services.sqladmin.model.IpConfiguration;
import com.google.api.services.sqladmin.model.IpMapping;
import com.google.api.services.sqladmin.model.LocationPreference;
import com.google.api.services.sqladmin.model.Operation;
import com.google.api.services.sqladmin.model.OperationError;
import com.google.api.services.sqladmin.model.OperationsListResponse;
import com.google.api.services.sqladmin.model.RestoreBackupContext;
import com.google.api.services.sqladmin.model.Settings;
import com.google.api.services.sqladmin.model.Tier;
import com.google.api.services.sqladmin.model.TiersListResponse;
import com.google.api.services.sqladmin.model.User;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.DayOfWeek;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.TimeWindow;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.GoogleMethod;
import org.dasein.cloud.google.capabilities.GCERelationalDatabaseCapabilities;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.AbstractRelationalDatabaseSupport;
import org.dasein.cloud.platform.ConfigurationParameter;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseBackup;
import org.dasein.cloud.platform.DatabaseBackupState;
import org.dasein.cloud.platform.DatabaseConfiguration;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseLicenseModel;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.DatabaseSnapshot;
import org.dasein.cloud.platform.DatabaseState;
import org.dasein.cloud.platform.RelationalDatabaseCapabilities;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class RDS
extends AbstractRelationalDatabaseSupport<Google> {
    private static final Logger logger = Logger.getLogger(RDS.class);
    private Cache<JSONObject> jsonPriceList = null;
    private Cache<DatabaseInstance> listDatabasesInstanceCache = null;
    private Cache<Database> listDatabasesCache = null;
    private Cache<DatabaseEngine> databaseEngines = null;
    private Cache<Tier> tiersList = null;
    private static final String jsonPriceUrl = "http://cloudpricingcalculator.appspot.com/static/data/pricelist.json";
    private static Long gigabyte = 0x40000000L;
    private static Long megabyte = 0x100000L;
    private Google provider;

    RDS(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
        this.jsonPriceList = Cache.getInstance((CloudProvider)provider, (String)"jsonPriceList", JSONObject.class, (CacheLevel)CacheLevel.CLOUD, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR));
        this.databaseEngines = Cache.getInstance((CloudProvider)provider, (String)"databaseEngineList", DatabaseEngine.class, (CacheLevel)CacheLevel.CLOUD, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        this.tiersList = Cache.getInstance((CloudProvider)provider, (String)"tierList", Tier.class, (CacheLevel)CacheLevel.CLOUD, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        this.listDatabasesInstanceCache = Cache.getInstance((CloudProvider)provider, (String)"listDatabasesInstanceCache", DatabaseInstance.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)60, (TimePeriodUnit)TimePeriod.SECOND));
        this.listDatabasesCache = Cache.getInstance((CloudProvider)provider, (String)"listDatabasesCache", Database.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)30, (TimePeriodUnit)TimePeriod.SECOND));
    }

    public void handleGoogleException(Exception e) throws CloudException, InternalException {
        if (e.getClass() == GoogleJsonResponseException.class) {
            GoogleJsonResponseException gjre = (GoogleJsonResponseException)e;
            throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
        }
        throw new CloudException((Throwable)e);
    }

    public String[] mapServiceAction(ServiceAction action) {
        return new String[0];
    }

    public void addAccess(String providerDatabaseId, String sourceCidr) throws CloudException, InternalException {
        if (sourceCidr.matches("[0-9][0-9./]*[0-9]")) {
            this.addAccessAuthorizedNetworks(providerDatabaseId, sourceCidr);
        } else {
            this.addAccessAuthorizedGaeApplications(providerDatabaseId, sourceCidr);
        }
    }

    private void addAccessAuthorizedNetworks(String providerDatabaseId, String sourceCidr) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            DatabaseInstance instance = (DatabaseInstance)sqlAdmin.instances().get(ctx.getAccountNumber(), providerDatabaseId).execute();
            Settings settings = instance.getSettings();
            ArrayList<AclEntry> authorizedNetworks = settings.getIpConfiguration().getAuthorizedNetworks();
            if (authorizedNetworks == null) {
                authorizedNetworks = new ArrayList<AclEntry>();
            }
            AclEntry acl = new AclEntry();
            acl.setValue(sourceCidr);
            authorizedNetworks.add(acl);
            settings.getIpConfiguration().setAuthorizedNetworks(authorizedNetworks);
            instance.setSettings(settings);
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation response = (Operation)sqlAdmin.instances().update(ctx.getAccountNumber(), providerDatabaseId, instance).execute();
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
    }

    public void addAccessAuthorizedGaeApplications(String providerDatabaseId, String authorizedApplication) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            DatabaseInstance instance = (DatabaseInstance)sqlAdmin.instances().get(ctx.getAccountNumber(), providerDatabaseId).execute();
            if (instance != null) {
                Settings settings = instance.getSettings();
                ArrayList<String> authorizedApplications = settings.getAuthorizedGaeApplications();
                if (authorizedApplications == null) {
                    authorizedApplications = new ArrayList<String>();
                }
                authorizedApplications.add(authorizedApplication);
                settings.setAuthorizedGaeApplications(authorizedApplications);
                instance.setSettings(settings);
                GoogleMethod method = new GoogleMethod(this.provider);
                Operation response = (Operation)sqlAdmin.instances().patch(ctx.getAccountNumber(), providerDatabaseId, instance).execute();
                method.getRDSOperationComplete(ctx, response.getName());
            }
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
    }

    public void revokeAccess(String providerDatabaseId, String deauthedCidr) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            DatabaseInstance instance = (DatabaseInstance)sqlAdmin.instances().get(ctx.getAccountNumber(), providerDatabaseId).execute();
            Settings settings = instance.getSettings();
            ArrayList authorizedNetworks = settings.getIpConfiguration().getAuthorizedNetworks();
            if (authorizedNetworks == null) {
                authorizedNetworks = new ArrayList();
            } else {
                for (AclEntry net : authorizedNetworks) {
                    if (!deauthedCidr.equals(net.getValue())) continue;
                    authorizedNetworks.remove(net);
                    break;
                }
            }
            settings.getIpConfiguration().setAuthorizedNetworks(authorizedNetworks);
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation response = (Operation)sqlAdmin.instances().update(ctx.getAccountNumber(), providerDatabaseId, instance).execute();
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
    }

    private void addAdminUser(@Nonnull String providerDatabaseId, @Nonnull String userName, @Nonnull String newAdminPassword) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            User content = new User();
            content.setName(userName);
            content.setPassword(newAdminPassword);
            content.setHost("%");
            Operation response = (Operation)sqlAdmin.users().insert(ctx.getAccountNumber(), providerDatabaseId, content).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
    }

    public void alterDatabase(String providerDatabaseId, boolean applyImmediately, String productSize, int storageInGigabytes, String configurationId, String newAdminUser, String newAdminPassword, int newPort, int snapshotRetentionInDays, TimeWindow preferredMaintenanceWindow, TimeWindow preferredBackupWindow) throws CloudException, InternalException {
        Operation response;
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        DatabaseInstance databaseInstance = null;
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            databaseInstance = (DatabaseInstance)sqlAdmin.instances().get(ctx.getAccountNumber(), providerDatabaseId).execute();
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
        if (null == databaseInstance) {
            throw new CloudException("Database instance " + providerDatabaseId + " does not exist.");
        }
        databaseInstance.setMaxDiskSize(Long.valueOf((long)storageInGigabytes * gigabyte));
        try {
            User content = new User();
            content.setName(newAdminUser);
            content.setPassword(newAdminPassword);
            String host = "%";
            response = (Operation)sqlAdmin.users().update(ctx.getAccountNumber(), providerDatabaseId, host, newAdminUser, content).execute();
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
        Settings settings = databaseInstance.getSettings();
        BackupConfiguration updatedBackupConfiguration = null;
        if (null != settings.getBackupConfiguration()) {
            updatedBackupConfiguration = settings.getBackupConfiguration();
        } else {
            updatedBackupConfiguration = new BackupConfiguration();
            updatedBackupConfiguration.setKind("sql#backupConfiguration");
            updatedBackupConfiguration.setBinaryLogEnabled(Boolean.valueOf(true));
            updatedBackupConfiguration.setEnabled(Boolean.valueOf(true));
        }
        if (null != preferredBackupWindow) {
            String startTime = String.format("%02d", preferredBackupWindow.getStartHour()) + ":" + String.format("%02d", preferredBackupWindow.getStartMinute());
            updatedBackupConfiguration.setStartTime(startTime);
        }
        settings.setBackupConfiguration(updatedBackupConfiguration);
        if (null != productSize) {
            settings.setTier(productSize.toUpperCase());
        }
        databaseInstance.setSettings(settings);
        try {
            response = (Operation)sqlAdmin.instances().update(ctx.getAccountNumber(), providerDatabaseId, databaseInstance).execute();
            if (applyImmediately) {
                method.getRDSOperationComplete(ctx, response.getName());
            }
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromScratch(String dataSourceName, DatabaseProduct product, String databaseVersion, String withAdminUser, String withAdminPassword, int hostPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromScratch");
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            DatabaseInstance content = new DatabaseInstance();
            if (databaseVersion == null) {
                String newDatabaseVersion = this.getDefaultVersion(product.getEngine()).replaceAll("\\.", "_");
                content.setDatabaseVersion(product.getEngine().name() + "_" + newDatabaseVersion);
            } else {
                content.setDatabaseVersion(product.getEngine().name() + "_" + databaseVersion.replaceAll("\\.", "_"));
            }
            dataSourceName = this.getCapabilities().getRelationalDatabaseNamingConstraints().convertToValidName(dataSourceName, Locale.US);
            content.setName(dataSourceName);
            content.setProject(ctx.getAccountNumber());
            try {
                String regionId = ctx.getRegionId();
                if (regionId.equals("us-central1")) {
                    regionId = "us-central";
                }
                content.setRegion(regionId);
            }
            catch (NullPointerException npe) {
                logger.error((Object)("setRegion failed: " + npe));
            }
            try {
                if (null != product) {
                    content.setMaxDiskSize(Long.valueOf((long)product.getStorageInGigabytes() * gigabyte));
                }
            }
            catch (NullPointerException npe) {
                logger.error((Object)("setMaxDiskSize failed: " + npe));
            }
            Settings settings = new Settings();
            try {
                if (product.isHighAvailability()) {
                    settings.setActivationPolicy("ALWAYS");
                } else {
                    settings.setActivationPolicy("ON_DEMAND");
                }
            }
            catch (NullPointerException npe) {
                logger.error((Object)("setActivationPolicy failed: " + npe));
            }
            try {
                if (product.getName().contains("Daily")) {
                    settings.setPricingPlan("PACKAGE");
                } else if (product.getName().contains("Hourly")) {
                    settings.setPricingPlan("PER_USE");
                }
            }
            catch (NullPointerException npe) {
                logger.error((Object)("setPricingPlan failed: " + npe));
            }
            settings.setReplicationType("SYNCHRONOUS");
            try {
                settings.setTier(product.getProductSize());
            }
            catch (NullPointerException npe) {
                logger.error((Object)("setTier failed: " + npe));
            }
            BackupConfiguration element = settings.getBackupConfiguration();
            if (element == null) {
                element = new BackupConfiguration();
            }
            element.setBinaryLogEnabled(Boolean.valueOf(true));
            element.setEnabled(Boolean.valueOf(true));
            settings.setBackupConfiguration(element);
            IpConfiguration ipConfiguration = settings.getIpConfiguration();
            if (null == ipConfiguration) {
                ipConfiguration = new IpConfiguration();
            }
            ipConfiguration.setIpv4Enabled(Boolean.valueOf(true));
            settings.setIpConfiguration(ipConfiguration);
            if (null != product.getProviderDataCenterId()) {
                LocationPreference locationPreference = settings.getLocationPreference();
                if (locationPreference == null) {
                    locationPreference = new LocationPreference();
                }
                locationPreference.setZone(product.getProviderDataCenterId());
                settings.setLocationPreference(locationPreference);
            }
            content.setSettings(settings);
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation response = null;
            try {
                response = (Operation)sqlAdmin.instances().insert(ctx.getAccountNumber(), content).execute();
            }
            catch (GoogleJsonResponseException ge) {
                if (ge.getStatusMessage().equals("Conflict") && ge.getStatusCode() == 409) {
                    throw new CloudException("The name " + dataSourceName + " has been used in the past 2 months. Once used, DB names are reserved for 2 months after their decomission.");
                }
                throw new Exception(ge);
            }
            try {
                method.getRDSOperationCompleteLong(ctx, response.getName());
            }
            catch (NullPointerException npe) {
                logger.error((Object)("getRDSOperationCompleteLong failed: " + npe));
                throw new CloudException("getRDSOperationCompleteLong failed: " + npe);
            }
            try {
                User userContent = new User();
                userContent.setName(withAdminUser);
                userContent.setPassword(withAdminPassword);
                userContent.setHost("%");
                response = (Operation)sqlAdmin.users().insert(ctx.getAccountNumber(), dataSourceName, userContent).execute();
                method.getRDSOperationComplete(ctx, response.getName());
            }
            catch (Exception e) {
                this.handleGoogleException(e);
            }
        }
        catch (Exception e) {
            this.handleGoogleException(e);
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
        return dataSourceName;
    }

    public void updateProductSize(@Nonnull String providerDatabaseId, @Nonnull String newProductSize) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            DatabaseInstance databaseInstance = (DatabaseInstance)sqlAdmin.instances().get(ctx.getAccountNumber(), providerDatabaseId).execute();
            if (null == databaseInstance) {
                throw new CloudException("Database instance " + providerDatabaseId + " does not exist.");
            }
            Settings settings = databaseInstance.getSettings();
            settings.setTier(newProductSize.toUpperCase());
            databaseInstance.setSettings(settings);
            Operation response = (Operation)sqlAdmin.instances().update(ctx.getAccountNumber(), providerDatabaseId, databaseInstance).execute();
            GoogleMethod method = new GoogleMethod(this.provider);
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (IOException e) {
            this.handleGoogleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromLatest(String dataSourceName, String providerDatabaseId, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromLatest");
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            InstancesCloneRequest content = new InstancesCloneRequest();
            CloneContext cloneContext = new CloneContext();
            cloneContext.setDestinationInstanceName(providerDatabaseId);
            content.setCloneContext(cloneContext);
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation cloneResponse = (Operation)sqlAdmin.instances().clone(ctx.getAccountNumber(), dataSourceName, content).execute();
            method.getRDSOperationCompleteLong(ctx, cloneResponse.getName());
            this.updateProductSize(providerDatabaseId, productSize);
        }
        catch (Exception e) {
            System.out.println("createFromLatest cleanup 1");
            try {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                this.removeDatabase(providerDatabaseId);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.handleGoogleException(e);
        }
        finally {
            APITrace.end();
        }
        return providerDatabaseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabase(String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getDatabase");
        try {
            if (providerDatabaseId == null) {
                Database database = null;
                return database;
            }
            Iterable<Database> dbs = this.listDatabases();
            if (dbs != null) {
                for (Database database : dbs) {
                    if (database == null || !database.getProviderDatabaseId().equals(providerDatabaseId)) continue;
                    Database database2 = database;
                    return database2;
                }
            }
            Database database = null;
            return database;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DatabaseEngine> getDatabaseEngines() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getSupportedVersions");
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        ProviderContext ctx = this.provider.getContext();
        ArrayList cachedDatabaseEngines = (ArrayList)this.databaseEngines.get(ctx);
        if (cachedDatabaseEngines == null) {
            HashMap<DatabaseEngine, Boolean> engines = new HashMap<DatabaseEngine, Boolean>();
            try {
                FlagsListResponse flags = (FlagsListResponse)sqlAdmin.flags().list().execute();
                for (Flag flag : flags.getItems()) {
                    List appliesTo = flag.getAppliesTo();
                    for (String dbNameVersion : appliesTo) {
                        String dbBaseName = dbNameVersion.replaceFirst("_.*", "");
                        engines.put(DatabaseEngine.valueOf((String)dbBaseName), true);
                    }
                }
                cachedDatabaseEngines = new ArrayList();
                cachedDatabaseEngines.addAll(engines.keySet());
                this.databaseEngines.put(ctx, cachedDatabaseEngines);
            }
            catch (Exception e) {
                this.handleGoogleException(e);
            }
            finally {
                APITrace.end();
            }
        }
        return cachedDatabaseEngines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultVersion(@Nonnull DatabaseEngine forEngine) throws CloudException, InternalException {
        if (forEngine == null) {
            return null;
        }
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getDefaultVersion");
        try {
            Iterable<String> versions = this.getSupportedVersions(forEngine);
            Iterator<String> i$ = versions.iterator();
            if (i$.hasNext()) {
                String version;
                String string = version = i$.next();
                return string;
            }
        }
        finally {
            APITrace.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> getSupportedVersions(@Nonnull DatabaseEngine forEngine) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getSupportedVersions");
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        HashMap<String, Boolean> versions = new HashMap<String, Boolean>();
        try {
            FlagsListResponse flags = (FlagsListResponse)sqlAdmin.flags().list().execute();
            for (Flag flag : flags.getItems()) {
                List appliesTo = flag.getAppliesTo();
                for (String dbNameVersion : appliesTo) {
                    versions.put(dbNameVersion.toLowerCase().replaceFirst(forEngine.toString().toLowerCase() + "_", "").replaceAll("_", "."), true);
                }
            }
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
        finally {
            APITrace.end();
        }
        return versions.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(String urlString) throws Exception {
        BufferedReader reader = null;
        try {
            int read;
            URL url = new URL(urlString);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer buffer = new StringBuffer();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<DatabaseProduct> listDatabaseProducts(@Nonnull DatabaseEngine forEngine) throws CloudException, InternalException {
        ArrayList<DatabaseProduct> products = new ArrayList<DatabaseProduct>();
        Iterable<DatabaseEngine> supportedEngines = this.getDatabaseEngines();
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.listDatabaseProducts");
        boolean found = false;
        for (DatabaseEngine engine : supportedEngines) {
            if (!forEngine.equals((Object)engine)) continue;
            found = true;
            break;
        }
        if (!found) {
            return products;
        }
        ProviderContext ctx = this.provider.getContext();
        Collection cachedJsonPriceList = (Collection)this.jsonPriceList.get(ctx);
        JSONObject json = null;
        if (cachedJsonPriceList != null) {
            json = (JSONObject)cachedJsonPriceList.iterator().next();
        } else {
            String jsonString = null;
            try {
                jsonString = RDS.readUrl(jsonPriceUrl);
                jsonString = jsonString.replaceFirst("CP-APP-ENGINE-CLOUD-STORAGE", "CP-APP-ENGINE-CLOUD-STORAGE-DUP");
                jsonString = jsonString.replaceFirst("CP-APP-ENGINE-MEMCACHE", "CP-APP-ENGINE-MEMCACHE-DUP");
                json = new JSONObject(jsonString);
            }
            catch (JSONException e) {
                throw new InternalException("Problem obtaining pricing from http://cloudpricingcalculator.appspot.com/static/data/pricelist.json : " + (Object)((Object)e));
            }
            catch (Exception e) {
                throw new InternalException("Problem obtaining pricing from http://cloudpricingcalculator.appspot.com/static/data/pricelist.json : " + e);
            }
            ArrayList<JSONObject> jsonCachList = new ArrayList<JSONObject>();
            jsonCachList.add(json);
            this.jsonPriceList.put(ctx, jsonCachList);
        }
        HashMap<String, Float> hourly = new HashMap<String, Float>();
        HashMap<String, Float> daily = new HashMap<String, Float>();
        Float ioRate = null;
        Float storageRate = null;
        try {
            JSONObject gcp_price_list = (JSONObject)json.get("gcp_price_list");
            Iterator keys = gcp_price_list.keys();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                if (!k.contains("CLOUDSQL")) continue;
                String[] components = k.split("-");
                JSONObject val = (JSONObject)gcp_price_list.get(k);
                Float price = null;
                String regionId = ctx.getRegionId();
                price = new Float((Double)val.get("us"));
                try {
                    if (regionId.startsWith("europe")) {
                        price = new Float((Double)val.get("eu"));
                    } else if (regionId.startsWith("asia")) {
                        price = new Float((Double)val.get("apac"));
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
                if (components[2].equals("PERUSE")) {
                    hourly.put(components[3], price);
                    continue;
                }
                if (components[2].equals("PACKAGE")) {
                    daily.put(components[3], price);
                    continue;
                }
                if (components[2].equals("IO")) {
                    ioRate = price;
                    continue;
                }
                if (!components[2].equals("STORAGE")) continue;
                storageRate = price;
            }
        }
        catch (Exception e) {
            throw new InternalException("Problem obtaining pricing from http://cloudpricingcalculator.appspot.com/static/data/pricelist.json");
        }
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        Map hourlyRate = Collections.unmodifiableMap(hourly);
        Map dailyRate = Collections.unmodifiableMap(daily);
        Collection tierList = (Collection)this.tiersList.get(ctx);
        List tiers = null;
        if (tierList != null) {
            tiers = (List)tierList;
        } else {
            try {
                TiersListResponse tierListResponse = (TiersListResponse)sqlAdmin.tiers().list(ctx.getAccountNumber()).execute();
                tiers = tierListResponse.getItems();
                this.tiersList.put(ctx, (Iterable)tiers);
            }
            catch (Exception e) {
                this.handleGoogleException(e);
            }
        }
        try {
            DatabaseProduct product = null;
            for (Tier t : tiers) {
                int sizeInGB = (int)(t.getDiskQuota() / gigabyte);
                int ramInMB = (int)(t.getRAM() / megabyte);
                product = new DatabaseProduct(t.getTier(), "PERUSE " + t.getTier() + " - " + ramInMB + "MB RAM Hourly");
                product.setLicenseModel(DatabaseLicenseModel.GENERAL_PUBLIC_LICENSE);
                product.setEngine(forEngine);
                product.setStorageInGigabytes(sizeInGB);
                product.setCurrency("USD");
                product.setStandardHourlyRate(((Float)hourlyRate.get(t.getTier())).floatValue());
                product.setStandardIoRate(ioRate.floatValue());
                product.setStandardStorageRate(storageRate.floatValue());
                products.add(product);
                product = new DatabaseProduct(t.getTier(), "PACKAGE " + t.getTier() + " - " + ramInMB + "MB RAM Daily");
                product.setEngine(forEngine);
                product.setStorageInGigabytes(sizeInGB);
                product.setCurrency("USD");
                product.setStandardHourlyRate(((Float)dailyRate.get(t.getTier())).floatValue() / 24.0f);
                product.setStandardIoRate(ioRate.floatValue());
                product.setStandardStorageRate(storageRate.floatValue());
                product.setHighAvailability(true);
                products.add(product);
            }
        }
        finally {
            APITrace.end();
        }
        return products;
    }

    public DatabaseSnapshot getSnapshot(String providerDbSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database snapshots.");
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        try {
            this.getSupportedVersions(DatabaseEngine.MYSQL);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Iterable<String> listAccess(@Nonnull String toProviderDatabaseId) throws CloudException, InternalException {
        ArrayList<String> dbAccess = new ArrayList<String>();
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        Collection databaseInstances = null;
        try {
            InstancesListResponse databases = (InstancesListResponse)sqlAdmin.instances().list(ctx.getAccountNumber()).execute();
            databaseInstances = databases.getItems();
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
        for (DatabaseInstance db : databaseInstances) {
            List networks = db.getSettings().getIpConfiguration().getAuthorizedNetworks();
            if (networks == null) continue;
            for (AclEntry network : networks) {
                dbAccess.add(network.getValue());
            }
        }
        return dbAccess;
    }

    public Iterable<DatabaseConfiguration> listConfigurations() throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database backup configurations.");
    }

    public DatabaseConfiguration getConfiguration(String providerConfigurationId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database backup configurations.");
    }

    public Iterable<ResourceStatus> listDatabaseStatus() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        Collection databaseInstances = (Collection)this.listDatabasesInstanceCache.get(ctx);
        if (null == databaseInstances) {
            try {
                InstancesListResponse databases = (InstancesListResponse)sqlAdmin.instances().list(ctx.getAccountNumber()).execute();
                databaseInstances = databases.getItems();
                this.listDatabasesInstanceCache.put(ctx, (Iterable)databaseInstances);
            }
            catch (Exception e) {
                this.handleGoogleException(e);
            }
        }
        for (DatabaseInstance instance : databaseInstances) {
            ResourceStatus status = new ResourceStatus(instance.getName(), (Object)instance.getState());
            list.add(status);
        }
        return list;
    }

    public Iterable<Database> listDatabases() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        ArrayList<Database> list = (ArrayList<Database>)this.listDatabasesCache.get(ctx);
        if (null == list) {
            Collection databaseInstances = (Collection)this.listDatabasesInstanceCache.get(ctx);
            if (null == databaseInstances) {
                try {
                    InstancesListResponse databases = (InstancesListResponse)sqlAdmin.instances().list(ctx.getAccountNumber()).execute();
                    if (null != databases) {
                        databaseInstances = databases.getItems();
                    }
                    this.listDatabasesInstanceCache.put(ctx, (Iterable)databaseInstances);
                }
                catch (Exception e) {
                    this.handleGoogleException(e);
                }
            }
            try {
                list = new ArrayList<Database>();
                if (null != databaseInstances) {
                    for (DatabaseInstance d : databaseInstances) {
                        String[] backupWindowStartTimeComponents;
                        Settings s = d.getSettings();
                        if (null == s) {
                            throw new CloudException("getSettings() returned null!");
                        }
                        BackupConfiguration backupConfig = s.getBackupConfiguration();
                        Database database = new Database();
                        database.setAdminUser("root");
                        database.setAllocatedStorageInGb((int)(d.getMaxDiskSize() / gigabyte));
                        if (null == backupConfig) {
                            backupConfig = new BackupConfiguration();
                        }
                        database.setConfiguration("unknown-1");
                        OperationsListResponse operations = (OperationsListResponse)sqlAdmin.operations().list(d.getProject(), d.getName()).execute();
                        for (Operation operation : operations.getItems()) {
                            if (!operation.getOperationType().equals("CREATE") || operation.getEndTime() == null) continue;
                            database.setCreationTimestamp(operation.getEndTime().getValue());
                        }
                        String googleDBState = d.getState();
                        if (googleDBState.equals("RUNNABLE")) {
                            database.setCurrentState(DatabaseState.AVAILABLE);
                        } else if (googleDBState.equals("SUSPENDED")) {
                            database.setCurrentState(DatabaseState.SUSPENDED);
                        } else if (googleDBState.equals("PENDING_CREATE")) {
                            database.setCurrentState(DatabaseState.PENDING);
                        } else if (googleDBState.equals("MAINTENANCE")) {
                            database.setCurrentState(DatabaseState.MAINTENANCE);
                        } else if (googleDBState.equals("UNKNOWN_STATE")) {
                            database.setCurrentState(DatabaseState.UNKNOWN);
                        }
                        if (d.getDatabaseVersion().equals("MYSQL_5_5") || d.getDatabaseVersion().equals("MYSQL_5_6")) {
                            database.setEngine(DatabaseEngine.MYSQL);
                        }
                        database.setHighAvailability(true);
                        database.setHostPort(3306);
                        if (null != d && null != d.getIpAddresses() && null != d.getIpAddresses().get(0)) {
                            database.setHostName(((IpMapping)d.getIpAddresses().get(0)).getIpAddress());
                        }
                        if (null != backupConfig && backupConfig.getStartTime() != null && null != (backupWindowStartTimeComponents = backupConfig.getStartTime().split(":")) && null != backupWindowStartTimeComponents[0] && null != backupWindowStartTimeComponents[1]) {
                            int startHour = Integer.parseInt(backupWindowStartTimeComponents[0]);
                            TimeWindow backupTimeWindow = new TimeWindow();
                            backupTimeWindow.setStartHour(startHour);
                            backupTimeWindow.setStartMinute(Integer.parseInt(backupWindowStartTimeComponents[1]));
                            backupTimeWindow.setEndHour((startHour + 4) % 24);
                            backupTimeWindow.setEndMinute(Integer.parseInt(backupWindowStartTimeComponents[1]));
                            backupTimeWindow.setStartDayOfWeek(DayOfWeek.MONDAY);
                            backupTimeWindow.setEndDayOfWeek(DayOfWeek.SUNDAY);
                            database.setBackupWindow(backupTimeWindow);
                            database.setMaintenanceWindow(backupTimeWindow);
                        }
                        database.setName(d.getName());
                        database.setProductSize(s.getTier());
                        database.setProviderDatabaseId(d.getName());
                        database.setProviderOwnerId(d.getProject());
                        String regionId = d.getRegion();
                        if (regionId.equals("us-central")) {
                            regionId = "us-central1";
                        }
                        database.setProviderRegionId(regionId);
                        if (null != d && null != d.getSettings() && null != d.getSettings().getLocationPreference()) {
                            database.setProviderDataCenterId(d.getSettings().getLocationPreference().getZone());
                        }
                        if (d.getDatabaseVersion().startsWith("MYSQL_")) {
                            database.setEngineVersion(d.getDatabaseVersion().replace("MYSQL_", "").replace("_", "."));
                        }
                        if (d.getDatabaseVersion() != null) {
                            database.setEngineVersion(d.getDatabaseVersion().trim().toLowerCase());
                        }
                        list.add(database);
                    }
                    this.listDatabasesCache.put(ctx, list);
                }
            }
            catch (Exception e) {
                this.handleGoogleException(e);
            }
        }
        return list;
    }

    public Collection<ConfigurationParameter> listParameters(String forProviderConfigurationId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database backup configurations.");
    }

    public void removeConfiguration(String providerConfigurationId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database backup configurations.");
    }

    public void removeDatabase(String providerDatabaseId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            Operation response = (Operation)sqlAdmin.instances().delete(ctx.getAccountNumber(), providerDatabaseId).execute();
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)e);
                if (gjre.getStatusMessage().equals("Conflict") && gjre.getStatusCode() == 409) {
                    throw new CloudException("Database already deleted.");
                }
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
        Collection list = (Collection)this.listDatabasesCache.get(ctx);
        if (null != list) {
            for (Database db : list) {
                if (!db.getName().equals(providerDatabaseId)) continue;
                list.remove(db);
                this.listDatabasesCache.put(ctx, (Iterable)list);
                break;
            }
        }
    }

    public void resetConfiguration(String providerConfigurationId, String ... parameters) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database backup configurations.");
    }

    public void restart(String providerDatabaseId, boolean blockUntilDone) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        try {
            GoogleMethod method = new GoogleMethod(this.provider);
            Operation response = (Operation)sqlAdmin.instances().restart(ctx.getAccountNumber(), providerDatabaseId).execute();
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (IOException e) {
            if (e.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)e);
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException((Throwable)e);
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
    }

    public void updateConfiguration(String providerConfigurationId, ConfigurationParameter ... parameters) throws CloudException, InternalException {
        throw new OperationNotSupportedException("GCE Cloud SQL does not support database backup configurations.");
    }

    public DatabaseSnapshot snapshot(String providerDatabaseId, String name) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Take snapshot not supported");
    }

    public void removeSnapshot(String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Remove snapshot not supported");
    }

    public Iterable<DatabaseSnapshot> listSnapshots(String forOptionalProviderDatabaseId) throws CloudException, InternalException {
        ArrayList<DatabaseSnapshot> snapshots = new ArrayList<DatabaseSnapshot>();
        return snapshots;
    }

    public String createFromSnapshot(String dataSourceName, String providerDatabaseId, String providerDbSnapshotId, String productSize, String providerDataCenterId, int hostPort) throws CloudException, InternalException {
        return null;
    }

    public DatabaseBackup getUsableBackup(String providerDbId, String beforeTimestamp) throws CloudException, InternalException {
        Date testStartTime = null;
        Date beforeStartTime = null;
        Date bestCandidateStartTime = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        DatabaseBackup bestCandidateBackup = null;
        try {
            beforeStartTime = formatter.parse(beforeTimestamp);
        }
        catch (ParseException e) {
            throw new InternalException("Invalid beforeTimestamp passed to getUsableBackup");
        }
        Iterable<DatabaseBackup> backupList = this.listBackups(providerDbId);
        for (DatabaseBackup backup : backupList) {
            if (DatabaseBackupState.AVAILABLE != backup.getCurrentState()) continue;
            try {
                testStartTime = formatter.parse(backup.getStartTime());
                if (!testStartTime.before(beforeStartTime) || bestCandidateStartTime != null && !testStartTime.after(bestCandidateStartTime)) continue;
                bestCandidateBackup = backup;
                bestCandidateStartTime = testStartTime;
            }
            catch (ParseException e) {}
        }
        if (bestCandidateBackup != null) {
            return bestCandidateBackup;
        }
        throw new CloudException("No available backups meet requirements.");
    }

    public Iterable<DatabaseBackup> listBackups(String forOptionalProviderDatabaseId) throws CloudException, InternalException {
        ArrayList<DatabaseBackup> backups = new ArrayList();
        if (forOptionalProviderDatabaseId == null) {
            Iterable<Database> dataBases = this.listDatabases();
            for (Database db : dataBases) {
                backups.addAll(this.getBackupForDatabase(db.getProviderDatabaseId()));
            }
        } else {
            backups = this.getBackupForDatabase(forOptionalProviderDatabaseId);
        }
        return backups;
    }

    public RelationalDatabaseCapabilities getCapabilities() throws InternalException, CloudException {
        return new GCERelationalDatabaseCapabilities(this.provider);
    }

    public void removeBackup(DatabaseBackup backup) throws CloudException, InternalException {
        throw new CloudException("GCE Cloud SQL does not support deleting specific database backups.");
    }

    public ArrayList<DatabaseBackup> getBackupForDatabase(String forDatabaseId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        ArrayList<DatabaseBackup> backups = new ArrayList<DatabaseBackup>();
        Database db = this.getDatabase(forDatabaseId);
        BackupRunsListResponse backupRuns = null;
        try {
            backupRuns = (BackupRunsListResponse)sqlAdmin.backupRuns().list(ctx.getAccountNumber(), forDatabaseId).execute();
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
        try {
            if (null != backupRuns.getItems()) {
                for (BackupRun backupItem : backupRuns.getItems()) {
                    DatabaseBackup backup = new DatabaseBackup();
                    String instance = backupItem.getInstance();
                    backup.setProviderDatabaseId(instance);
                    backup.setAdminUser(db.getAdminUser());
                    backup.setProviderOwnerId(db.getProviderOwnerId());
                    String regionId = db.getProviderRegionId();
                    if (regionId.equals("us-central")) {
                        regionId = "us-central1";
                    }
                    backup.setProviderRegionId(regionId);
                    backup.setBackupConfiguration(backupItem.getInstance());
                    backup.setEnqueuedTime(backupItem.getEnqueuedTime().toString());
                    String status = backupItem.getStatus();
                    if (status.equals("SUCCESSFUL")) {
                        backup.setCurrentState(DatabaseBackupState.AVAILABLE);
                        backup.setStartTime(backupItem.getStartTime().toString());
                        backup.setEndTime(backupItem.getEndTime().toString());
                    } else {
                        backup.setCurrentState(DatabaseBackupState.valueOf((String)status));
                    }
                    backup.setProviderBackupId(backupItem.getId().toString());
                    OperationError error = backupItem.getError();
                    if (error != null) {
                        backup.setCurrentState(DatabaseBackupState.ERROR);
                    }
                    backups.add(backup);
                }
            }
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
        return backups;
    }

    public void restoreBackup(DatabaseBackup backup) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        SQLAdmin sqlAdmin = this.provider.getGoogleSQLAdmin();
        GoogleMethod method = new GoogleMethod(this.provider);
        try {
            String acct = ctx.getAccountNumber();
            InstancesRestoreBackupRequest request = new InstancesRestoreBackupRequest();
            RestoreBackupContext restoreBackupContext = new RestoreBackupContext();
            restoreBackupContext.setBackupRunId(new Long(backup.getProviderBackupId()));
            request.setRestoreBackupContext(restoreBackupContext);
            Operation response = (Operation)sqlAdmin.instances().restoreBackup(acct, backup.getProviderDatabaseId(), request).execute();
            method.getRDSOperationComplete(ctx, response.getName());
        }
        catch (Exception e) {
            this.handleGoogleException(e);
        }
    }

    @Deprecated
    public Iterable<DatabaseProduct> getDatabaseProducts(DatabaseEngine forEngine) throws CloudException, InternalException {
        return this.listDatabaseProducts(forEngine);
    }

    @Deprecated
    public boolean isSupportsFirewallRules() {
        boolean supportsFirewallRules = false;
        try {
            supportsFirewallRules = this.getCapabilities().supportsFirewallRules();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportsFirewallRules;
    }

    @Deprecated
    public boolean isSupportsHighAvailability() throws CloudException, InternalException {
        return true;
    }

    @Deprecated
    public boolean isSupportsLowAvailability() throws CloudException, InternalException {
        boolean supportsLowAvailability = false;
        try {
            supportsLowAvailability = this.getCapabilities().supportsLowAvailability();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportsLowAvailability;
    }

    @Deprecated
    public boolean isSupportsMaintenanceWindows() {
        boolean supportsMaintenanceWindows = false;
        try {
            supportsMaintenanceWindows = this.getCapabilities().supportsMaintenanceWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportsMaintenanceWindows;
    }

    @Deprecated
    public boolean isSupportsSnapshots() {
        boolean supportsSnapshots = false;
        try {
            supportsSnapshots = this.getCapabilities().supportsSnapshots();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportsSnapshots;
    }

    @Deprecated
    public String getProviderTermForDatabase(Locale locale) {
        String providerTermForDatabase = null;
        try {
            providerTermForDatabase = this.getCapabilities().getProviderTermForDatabase(locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return providerTermForDatabase;
    }

    @Deprecated
    public String getProviderTermForSnapshot(Locale locale) {
        String providerTermForSnapshot = null;
        try {
            providerTermForSnapshot = this.getCapabilities().getProviderTermForSnapshot(locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return providerTermForSnapshot;
    }
}

