/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.google.storage;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.BucketAccessControls;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.ObjectAccessControls;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.google.Google;
import org.dasein.cloud.google.GoogleException;
import org.dasein.cloud.google.capabilities.GCEBlobStoreCapabilities;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.storage.AbstractBlobStoreSupport;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreCapabilities;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class DriveSupport
extends AbstractBlobStoreSupport<Google> {
    private Google provider;
    private static final Logger logger = Google.getLogger(DriveSupport.class);

    public DriveSupport(Google provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void get(@Nullable String bucket, @Nonnull String object, @Nonnull File toFile, @Nullable FileTransfer transfer) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.get");
        try {
            try {
                if (bucket == null) {
                    logger.error((Object)"No bucket was specified for download file request");
                    throw new OperationNotSupportedException("No bucket was specified for download file request");
                }
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                Storage.Objects.Get getObject = storage.objects().get(bucket, object);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                getObject.getMediaHttpDownloader().setDirectDownloadEnabled(true);
                getObject.executeMediaAndDownloadTo((OutputStream)out);
                ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
                try {
                    this.copy(input, new FileOutputStream(toFile), transfer);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)("Could not find target file to fetch to " + toFile + ": " + e.getMessage()));
                    throw new InternalException((Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)("Could not fetch file to " + toFile + ": " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(@Nullable String bucket, @Nonnull String objectName, @Nonnull File file) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.put(bucket, object, file)");
        try {
            try {
                if (bucket == null) {
                    logger.error((Object)"No bucket was specified for upload file request");
                    throw new OperationNotSupportedException("No bucket was specified for upload file request");
                }
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                FileInputStream inputStream = new FileInputStream(file);
                long byteCount = file.length();
                InputStreamContent mediaContent = new InputStreamContent("application/octet-stream", (InputStream)inputStream);
                mediaContent.setLength(byteCount);
                StorageObject objectMetadata = null;
                Storage.Objects.Insert insertObject = storage.objects().insert(bucket, objectMetadata, (AbstractInputStreamContent)mediaContent);
                insertObject.setName(objectName);
                if (mediaContent.getLength() > 0L && mediaContent.getLength() <= 2000000L) {
                    insertObject.getMediaHttpUploader().setDirectUploadEnabled(true);
                }
                insertObject.execute();
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(@Nullable String bucketName, @Nonnull String objectName, @Nonnull String content) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.put(bucket, object, content)");
        try {
            if (bucketName == null) {
                logger.error((Object)"No bucket was specified for upload file request");
                throw new OperationNotSupportedException("No bucket was specified for upload file request");
            }
            try {
                File tmp = File.createTempFile(objectName, ".txt");
                try {
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(tmp)));
                    writer.print(content);
                    writer.flush();
                    writer.close();
                    this.put(bucketName, objectName, tmp);
                }
                finally {
                    if (!tmp.delete()) {
                        logger.warn((Object)("Unable to delete temp file: " + tmp));
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to write file: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Blob createBucket(@Nonnull String bucket, boolean findFreeName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.createBucket");
        try {
            if (bucket.contains("/")) {
                throw new OperationNotSupportedException("Child buckets not supported in Google Storage");
            }
            try {
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new InternalException("Context is null");
                }
                String projectId = ctx.getAccountNumber();
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                Bucket newBucket = (Bucket)storage.buckets().insert(projectId, new Bucket().setName(bucket)).execute();
                Blob blob = this.toBucket(newBucket);
                return blob;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(@Nonnull String bucket) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.exists");
        try {
            com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
            Bucket myBucket = (Bucket)storage.buckets().get(bucket).execute();
            if (myBucket != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable ignore) {
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public Blob getBucket(@Nonnull String bucketName) throws InternalException, CloudException {
        Bucket myBucket;
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getBucket");
        try {
            com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
            myBucket = (Bucket)storage.buckets().get(bucketName).execute();
            if (myBucket != null) {
                Blob blob;
                Blob blob2 = blob = this.toBucket(myBucket);
                return blob2;
            }
            Blob blob = null;
            return blob;
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("404 Not Found")) {
                myBucket = null;
                return myBucket;
            }
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                if (gjre.getStatusCode() == 400 && gjre.getMessage().contains("Invalid bucket name")) {
                    Blob blob = null;
                    return blob;
                }
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new CloudException("An error occurred when getting bucket: " + bucketName + ": " + ex.getMessage());
        }
        finally {
            APITrace.end();
        }
    }

    public Blob getObject(@Nullable String bucketName, @Nonnull String objectName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getObject");
        try {
            if (bucketName == null) {
                logger.error((Object)"No bucket was specified for get object request");
                throw new OperationNotSupportedException("No bucket was specified for get object request");
            }
            try {
                Blob blob;
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                StorageObject myObject = (StorageObject)storage.objects().get(bucketName, objectName).execute();
                Blob blob2 = blob = this.toObject(myObject);
                return blob2;
            }
            catch (IOException ex) {
                block9: {
                    if (!ex.getMessage().contains("404 Not Found")) break block9;
                    Blob myObject = null;
                    APITrace.end();
                    return myObject;
                }
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new CloudException("An error occurred when getting bucket: " + bucketName + ": " + ex.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getSignedObjectUrl(@Nonnull String bucket, @Nonnull String object, @Nonnull String expiresEpochInSeconds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Signed object URLs are not currently supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Storage<Byte> getObjectSize(@Nullable String bucketName, @Nullable String objectName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"blob.getObjectSize");
        try {
            if (bucketName == null) {
                logger.error((Object)"No bucket was specified for get object size request");
                throw new OperationNotSupportedException("No bucket was specified for get object request");
            }
            if (objectName == null) {
                logger.error((Object)"No object was specified for get object size request");
                throw new OperationNotSupportedException("No object was specified for get object request");
            }
            Blob blob = this.getObject(bucketName, objectName);
            if (blob != null) {
                Storage storage = blob.getSize();
                return storage;
            }
            Storage<Byte> storage = null;
            return storage;
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return -1;
    }

    public Storage<Byte> getMaxObjectSize() throws InternalException, CloudException {
        return new Storage((Number)-2, (StorageUnit)Storage.BYTE);
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return -1;
    }

    @Nonnull
    public NamingConstraints getBucketNameRules() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)3, (int)222).withNoSpaces().withRegularExpression("(?:[a-z](?:[-a-z0-9.]{0,61}[a-z0-9])?)").lowerCaseOnly().constrainedBy(new char[]{'-', '_', '.'});
    }

    @Nonnull
    public NamingConstraints getObjectNameRules() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).withNoSpaces().withRegularExpression("(?:[a-z](?:[-a-z0-9.]{0,61}[a-z0-9])?)").lowerCaseOnly().constrainedBy(new char[]{'-', '_', '.'});
    }

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale locale) {
        return "bucket";
    }

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale locale) {
        return "object";
    }

    public boolean isPublic(@Nullable String bucket, @Nullable String object) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.isPublic");
        try {
            BucketAccessControls acls;
            com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
            if (object == null) {
                acls = (BucketAccessControls)storage.bucketAccessControls().list(bucket).execute();
                for (int i = 0; i < acls.size(); ++i) {
                    BucketAccessControl acl = (BucketAccessControl)acls.getItems().get(i);
                    if (!acl.getEntity().equalsIgnoreCase("allusers")) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                acls = (ObjectAccessControls)storage.objectAccessControls().list(bucket, object).execute();
                for (int i = 0; i < acls.size(); ++i) {
                    ObjectAccessControl acl = (ObjectAccessControl)acls.getItems().get(i);
                    if (!acl.getEntity().equalsIgnoreCase("allusers")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean acls2 = false;
            return acls2;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            if (ex.getClass() == GoogleJsonResponseException.class) {
                GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
            }
            throw new InternalException((Throwable)ex);
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<Blob> list(@Nullable String bucket) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.list");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("Context is null");
            }
            try {
                ArrayList<Blob> list = new ArrayList<Blob>();
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                if (bucket == null) {
                    Buckets buckets = (Buckets)storage.buckets().list(ctx.getAccountNumber()).execute();
                    if (buckets != null && buckets.getItems() != null) {
                        for (int i = 0; i < buckets.getItems().size(); ++i) {
                            Blob blob = this.toBucket((Bucket)buckets.getItems().get(i));
                            if (blob == null) continue;
                            list.add(blob);
                        }
                    }
                } else {
                    Objects objects = (Objects)storage.objects().list(bucket).execute();
                    if (objects.getItems() != null) {
                        for (int i = 0; i < objects.getItems().size(); ++i) {
                            Blob blob = this.toObject((StorageObject)objects.getItems().get(i));
                            if (blob == null) continue;
                            list.add(blob);
                        }
                    }
                }
                ArrayList<Blob> arrayList = list;
                return arrayList;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePublic(@Nonnull String bucket) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.makePublic(bucket)");
        try {
            try {
                if (bucket == null) {
                    throw new InternalException("Bucket not specified for makePublic request");
                }
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                storage.bucketAccessControls().insert(bucket, new BucketAccessControl().setRole("WRITER").setEntity("allUsers"));
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePublic(@Nullable String bucket, @Nonnull String object) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.makePublic(bucket, object)");
        try {
            try {
                if (bucket == null) {
                    throw new InternalException("Bucket not specified for makePublic request");
                }
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                storage.objectAccessControls().insert(bucket, object, new ObjectAccessControl().setEntity("allUsers").setRole("READER"));
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(@Nullable String fromBucket, @Nullable String objectName, @Nullable String toBucket) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.move");
        try {
            if (fromBucket == null || toBucket == null) {
                throw new InternalException("One or both buckets not specified");
            }
            if (objectName == null) {
                throw new InternalException("Object name is not specified");
            }
            this.copyFile(fromBucket, objectName, toBucket, objectName);
            this.removeObject(fromBucket, objectName);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBucket(@Nonnull String bucket) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"blob.removeBucket");
        try {
            for (Blob blob : this.list(bucket)) {
                this.removeObject(bucket, blob.getObjectName());
            }
            try {
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                storage.buckets().delete(bucket).execute();
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(@Nullable String bucket, @Nonnull String object) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.removeObject");
        try {
            if (bucket == null) {
                throw new InternalException("Bucket is null for remove object request");
            }
            try {
                com.google.api.services.storage.Storage storage = this.provider.getGoogleStorage();
                storage.objects().delete(bucket, object).execute();
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage());
                if (ex.getClass() == GoogleJsonResponseException.class) {
                    GoogleJsonResponseException gjre = (GoogleJsonResponseException)((Object)ex);
                    throw new GoogleException(CloudErrorType.GENERAL, gjre.getStatusCode(), gjre.getContent(), gjre.getDetails().getMessage());
                }
                throw new InternalException((Throwable)ex);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String renameBucket(@Nonnull String oldName, @Nonnull String newName, boolean findFreeName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.renameBucket");
        try {
            this.copy(oldName, null, newName, null);
            this.removeBucket(oldName);
            String string = newName;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameObject(@Nullable String bucket, @Nonnull String oldName, @Nonnull String newName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.renameObject");
        try {
            if (bucket == null) {
                throw new CloudException("No bucket was specified");
            }
            this.copy(bucket, oldName, bucket, newName);
            this.removeObject(bucket, oldName);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob upload(@Nonnull File sourceFile, @Nullable String bucket, @Nonnull String objectName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.upload");
        try {
            if (bucket == null) {
                logger.error((Object)"No bucket was specified for this request");
                throw new OperationNotSupportedException("No bucket was specified for this request");
            }
            if (!this.exists(bucket)) {
                this.createBucket(bucket, false);
            }
            this.put(bucket, objectName, sourceFile);
            Blob blob = this.getObject(bucket, objectName);
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    private Blob toBucket(Bucket bucket) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("Context is null");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new InternalException("Regiond cannot be null");
        }
        String name = bucket.getName();
        long creationDate = bucket.getTimeCreated().getValue();
        String location = bucket.getLocation();
        return Blob.getInstance((String)regionId, (String)location, (String)name, (long)creationDate);
    }

    private Blob toObject(StorageObject object) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("Context is null");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new InternalException("Regiond cannot be null");
        }
        String name = object.getName();
        String bucket = object.getBucket();
        long creationDate = object.getUpdated().getValue();
        String location = object.getSelfLink();
        long size = object.getSize().longValue();
        return Blob.getInstance((String)regionId, (String)location, (String)bucket, (String)name, (long)creationDate, (Storage)new Storage((Number)size, (StorageUnit)Storage.BYTE));
    }

    public BlobStoreCapabilities getCapabilities() throws CloudException, InternalException {
        return new GCEBlobStoreCapabilities(this.provider);
    }
}

