/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Folder;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.dc.ResourcePool;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.joyent.JoyentDataCenterCapabilities;
import org.dasein.cloud.joyent.JoyentMethod;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JoyentDataCenter
implements DataCenterServices {
    private SmartDataCenter provider;
    private volatile transient JoyentDataCenterCapabilities capabilities;

    public JoyentDataCenter(@Nonnull SmartDataCenter sdc) {
        this.provider = sdc;
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new JoyentDataCenterCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String providerDataCenterId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context exists for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No data center is established for this request");
        }
        for (DataCenter dc : this.listDataCenters(regionId)) {
            if (!dc.getProviderDataCenterId().equals(providerDataCenterId)) continue;
            return dc;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "dc zone";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "data center";
    }

    @Nullable
    public Region getRegion(@Nonnull String providerRegionId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            if (!region.getProviderRegionId().equals(providerRegionId)) continue;
            return region;
        }
        return null;
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String providerRegionId) throws InternalException, CloudException {
        Region r = this.getRegion(providerRegionId);
        if (r == null) {
            throw new CloudException("No such region: " + providerRegionId);
        }
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setAvailable(true);
        dc.setName(r.getName() + "a");
        dc.setProviderDataCenterId(r.getProviderRegionId() + "a");
        dc.setRegionId(r.getProviderRegionId());
        return Collections.singletonList(dc);
    }

    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        String json = method.doGetJson(this.provider.getEndpoint(), "datacenters");
        try {
            ArrayList<Region> regions = new ArrayList<Region>();
            JSONObject ob = new JSONObject(json);
            JSONArray ids = ob.names();
            for (int i = 0; i < ids.length(); ++i) {
                String regionId = ids.getString(i);
                Region r = new Region();
                r.setActive(true);
                r.setAvailable(true);
                r.setJurisdiction("US");
                r.setName(regionId);
                r.setProviderRegionId(regionId);
                regions.add(r);
            }
            return regions;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Collection<ResourcePool> listResourcePools(String providerDataCenterId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    public ResourcePool getResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Collection<StoragePool> listStoragePools() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public StoragePool getStoragePool(String providerStoragePoolId) throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Collection<Folder> listVMFolders() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Folder getVMFolder(String providerVMFolderId) throws InternalException, CloudException {
        return null;
    }
}

