/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent;

import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.json.JSONException;
import org.json.JSONObject;

public class JoyentException
extends CloudException {
    private static final long serialVersionUID = 1144131377092530264L;

    public static ExceptionItems parseException(int code, String json) {
        ExceptionItems items = new ExceptionItems();
        items.code = code;
        items.type = CloudErrorType.GENERAL;
        items.message = "unknown";
        items.details = "The cloud provided an error code without explanation";
        if (json != null) {
            try {
                JSONObject ob = new JSONObject(json);
                items.details = ob.has("message") ? ob.getString("message") : "[" + code + "] " + items.message;
                if (ob.has("code")) {
                    items.message = ob.getString("code");
                    items.message = items.message == null ? "unknown" : items.message.trim();
                } else {
                    items.message = "unknown";
                }
                String t = items.message.toLowerCase().trim();
                if (t.equals("notauthorized") || t.equals("invalidcredentials")) {
                    items.type = CloudErrorType.AUTHENTICATION;
                } else if (t.equals("requestthrottled")) {
                    items.type = CloudErrorType.CAPACITY;
                } else if (t.equals("requesttoolarge") || t.equals("badrequest") || t.equals("invalidargument") || t.equals("invalidheader") || t.equals("invalidversion") || t.equals("missingparameter")) {
                    items.type = CloudErrorType.COMMUNICATION;
                } else if (t.equals("resourcenotfound")) {
                    return null;
                }
            }
            catch (JSONException e) {
                SmartDataCenter.getLogger(JoyentException.class, "std").warn((Object)("parseException(): Invalid JSON in cloud response: " + json));
                items.details = json;
            }
        }
        return items;
    }

    public JoyentException(ExceptionItems items) {
        super(items.type, items.code, items.message, items.details);
    }

    public static class ExceptionItems {
        public CloudErrorType type;
        public int code;
        public String message;
        public String details;
    }
}

