/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.RequestTrackingStrategy;
import org.dasein.cloud.joyent.JoyentException;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.dasein.security.joyent.DefaultClientFactory;
import org.dasein.security.joyent.JoyentClientFactory;
import org.dasein.security.joyent.JoyentHttpAuth;
import org.dasein.security.joyent.SignatureHttpAuth;

public class JoyentMethod {
    private static final Logger logger = SmartDataCenter.getLogger(JoyentMethod.class, "std");
    private static final Logger wire = SmartDataCenter.getLogger(JoyentMethod.class, "wire");
    private static final ContentType APPLICATION_FORM_URLENCODED_UTF8 = ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8");
    private static final ContentType APPLICATION_JSON_UTF8 = ContentType.create((String)"application/json", (String)"UTF-8");
    public static final String VERSION = "~7.1";
    private JoyentClientFactory clientFactory;
    private JoyentHttpAuth httpAuth;
    private RequestTrackingStrategy strategy;

    public JoyentMethod(@Nonnull SmartDataCenter provider) {
        this.clientFactory = new DefaultClientFactory(provider.getContext());
        this.httpAuth = new SignatureHttpAuth(provider);
        this.strategy = provider.getContext().getRequestTrackingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(@Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doDelete(" + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [DELETE (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpDelete delete = new HttpDelete(endpoint + "/my/" + resource);
            this.httpAuth.addPreemptiveAuth((HttpRequest)delete);
            delete.addHeader("Accept", "application/json");
            delete.addHeader("X-Api-Version", VERSION);
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                delete.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)delete.getRequestLine().toString());
                for (Header header : delete.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)delete);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            if (code != 204 && code != 202 && code != 201) {
                logger.error((Object)("Expected NO CONTENT for DELETE request, got " + code));
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            wire.debug((Object)"");
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doDelete()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [DELETE (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String doGetJson(@Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doGetJson(" + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpGet get = new HttpGet(endpoint + "/my/" + resource);
            this.httpAuth.addPreemptiveAuth((HttpRequest)get);
            get.addHeader("Accept", "application/json");
            get.addHeader("X-Api-Version", VERSION);
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                get.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)get.getRequestLine().toString());
                for (Header header : get.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)get);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            if (code == 404 || code == 410) {
                String len$ = null;
                return len$;
            }
            if (code != 204 && code != 200 && code != 203) {
                logger.error((Object)("Expected OK for GET request, got " + code));
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    String string = null;
                    return string;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            String json = null;
            try {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    json = EntityUtils.toString((HttpEntity)entity);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)json);
                        wire.debug((Object)"");
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
            String string = json;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doGetJson()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputStream doGetStream(@Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doGetStream(" + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpEntity entity;
            block28: {
                InputStream inputStream;
                HttpResponse response;
                HttpClient client = this.clientFactory.getClient(endpoint);
                HttpGet get = new HttpGet(endpoint + "/my/" + resource);
                this.httpAuth.addPreemptiveAuth((HttpRequest)get);
                get.addHeader("Accept", "application/json");
                get.addHeader("X-Api-Version", VERSION);
                if (this.strategy != null && this.strategy.getSendAsHeader()) {
                    get.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)get.getRequestLine().toString());
                    for (Header header : get.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)get);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code == 404) {
                    InputStream len$ = null;
                    return len$;
                }
                if (code != 200 && code != 203) {
                    logger.error((Object)("Expected OK for GET request, got " + code));
                    String json = null;
                    try {
                        HttpEntity entity2 = response.getEntity();
                        if (entity2 != null) {
                            json = EntityUtils.toString((HttpEntity)entity2);
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)json);
                                wire.debug((Object)"");
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        throw new CloudException((Throwable)e);
                    }
                    JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                    if (items == null) {
                        inputStream = null;
                        return inputStream;
                    }
                    logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                    throw new JoyentException(items);
                }
                try {
                    entity = response.getEntity();
                    if (entity != null) break block28;
                    inputStream = null;
                    return inputStream;
                }
                catch (IOException e) {
                    logger.error((Object)("doGetStream(): Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
            }
            InputStream input = entity.getContent();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"---> Binary Data <---");
                wire.debug((Object)"");
            }
            InputStream inputStream = input;
            return inputStream;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doGetStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String doPostHeaders(@Nonnull String endpoint, @Nonnull String resource, @Nullable Map<String, String> customHeaders) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doPostHeaders(" + endpoint + "," + resource + "," + customHeaders + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpPost post = new HttpPost(endpoint + "/my/" + resource);
            this.httpAuth.addPreemptiveAuth((HttpRequest)post);
            post.addHeader("Accept", "application/json");
            post.addHeader("X-Api-Version", VERSION);
            if (customHeaders != null) {
                for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                    String val = entry.getValue() == null ? "" : entry.getValue();
                    post.addHeader(entry.getKey(), val);
                }
            }
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                post.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)post.getRequestLine().toString());
                for (Header header : post.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                try {
                    wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)post);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            if (code != 202 && code != 204 && code != 201) {
                logger.error((Object)("Expected ACCEPTED for POST request, got " + code));
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            if (code == 202 || code == 201) {
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                if (json != null && !json.trim().equals("")) {
                    String string = json;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doPostHeaders()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String doPostString(@Nonnull String endpoint, @Nonnull String resource, @Nullable String payload) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doPostString(" + endpoint + "," + resource + ",PAYLOAD)"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpPost post = new HttpPost(endpoint + "/my/" + resource);
            this.httpAuth.addPreemptiveAuth((HttpRequest)post);
            if (payload != null && payload.startsWith("action")) {
                post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                post.addHeader("Content-Type", "application/json");
            }
            post.addHeader("Accept", "application/json");
            post.addHeader("X-Api-Version", VERSION);
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                post.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            if (payload != null && payload.startsWith("action")) {
                post.setEntity((HttpEntity)new StringEntity(payload, APPLICATION_FORM_URLENCODED_UTF8));
            } else {
                post.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, APPLICATION_JSON_UTF8));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)post.getRequestLine().toString());
                for (Header header : post.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                try {
                    wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)post);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            if (code != 202 && code != 204 && code != 201 && code != 200) {
                logger.error((Object)("Expected ACCEPTED for POST request, got " + code));
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            if (code == 202 || code == 201 || code == 200) {
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                if (json != null && !json.trim().equals("")) {
                    String string = json;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doPostString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + endpoint + "/my/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String doPostStream(@Nonnull String endpoint, @Nonnull String resource, @Nullable String md5Hash, @Nullable InputStream stream) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doPostStream(" + endpoint + "," + resource + "," + md5Hash + ",PAYLOAD)"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + endpoint + "/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            String json;
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpPost post = new HttpPost(endpoint + resource);
            this.httpAuth.addPreemptiveAuth((HttpRequest)post);
            post.addHeader("Content-Type", "application/octet-stream");
            post.addHeader("Accept", "application/json");
            post.addHeader("X-Api-Version", VERSION);
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                post.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            post.setEntity((HttpEntity)new InputStreamEntity(stream, -1L, ContentType.APPLICATION_OCTET_STREAM));
            if (wire.isDebugEnabled()) {
                wire.debug((Object)post.getRequestLine().toString());
                for (Header header : post.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                wire.debug((Object)"--> BINARY DATA <--");
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)post);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            String responseHash = null;
            for (Header h : response.getAllHeaders()) {
                if (!h.getName().equals("ETag")) continue;
                responseHash = h.getValue();
            }
            if (responseHash != null && md5Hash != null && !responseHash.equals(md5Hash)) {
                throw new CloudException("MD5 hash values do not match, probably data corruption");
            }
            if (code != 202 && code != 204 && code != 201) {
                logger.error((Object)("Expected ACCEPTED or NO CONTENT for POST request, got " + code));
                json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            wire.debug((Object)"");
            if (code == 202 || code == 201) {
                json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                if (json != null && !json.trim().equals("")) {
                    String string = json;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doPostStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + endpoint + "/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String putHeaders(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nullable Map<String, String> customHeaders) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doPutHeaders(" + endpoint + "," + resource + "," + customHeaders + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [PUT (" + new Date() + ")] -> " + endpoint + "/" + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpPut put = new HttpPut(endpoint + resource);
            put.addHeader("Content-Type", "application/json");
            put.addHeader("Accept", "application/json");
            put.addHeader("X-Auth-Token", authToken);
            if (customHeaders != null) {
                for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                    String val = entry.getValue() == null ? "" : entry.getValue();
                    put.addHeader(entry.getKey(), val);
                }
            }
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                put.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)put.getRequestLine().toString());
                for (Header header : put.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                try {
                    wire.debug((Object)EntityUtils.toString((HttpEntity)put.getEntity()));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)put);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            if (code != 201 && code != 202 && code != 204) {
                logger.error((Object)("Expected CREATED, ACCEPTED, or NO CONTENT for put request, got " + code));
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            if (code == 202 || code == 201) {
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                if (json != null && !json.trim().equals("")) {
                    String string = json;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doPutHeaders()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [PUT (" + new Date() + ")] -> " + endpoint + "/" + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String putString(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nullable String payload) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doPutString(" + endpoint + "," + resource + ",PAYLOAD)"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [PUT (" + new Date() + ")] -> " + endpoint + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpPut put = new HttpPut(endpoint + resource);
            put.addHeader("Content-Type", "application/json");
            put.addHeader("Accept", "application/json");
            put.addHeader("X-Auth-Token", authToken);
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                put.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            put.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, APPLICATION_JSON_UTF8));
            if (wire.isDebugEnabled()) {
                wire.debug((Object)put.getRequestLine().toString());
                for (Header header : put.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                try {
                    wire.debug((Object)EntityUtils.toString((HttpEntity)put.getEntity()));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)put);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            if (code != 201 && code != 202 && code != 204) {
                logger.error((Object)("Expected CREATED, ACCEPTED, or NO CONTENT for put request, got " + code));
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            if (code == 202 || code == 201) {
                String json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                if (json != null && !json.trim().equals("")) {
                    String string = json;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doPutString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [PUT (" + new Date() + ")] -> " + endpoint + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String putStream(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nullable String md5Hash, @Nullable InputStream stream) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + JoyentMethod.class.getName() + ".doPutStream(" + endpoint + "," + resource + "," + md5Hash + ",PAYLOAD)"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [PUT (" + new Date() + ")] -> " + endpoint + resource + " >--------------------------------------------------------------------------------------"));
        }
        try {
            String json;
            HttpResponse response;
            HttpClient client = this.clientFactory.getClient(endpoint);
            HttpPut put = new HttpPut(endpoint + resource);
            put.addHeader("Content-Type", "application/octet-stream");
            put.addHeader("Accept", "application/json");
            put.addHeader("X-Auth-Token", authToken);
            if (md5Hash != null) {
                put.addHeader("ETag", md5Hash);
            }
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                put.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            put.setEntity((HttpEntity)new InputStreamEntity(stream, -1L, ContentType.APPLICATION_OCTET_STREAM));
            if (wire.isDebugEnabled()) {
                wire.debug((Object)put.getRequestLine().toString());
                for (Header header : put.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                wire.debug((Object)"--> BINARY DATA <--");
                wire.debug((Object)"");
            }
            try {
                response = client.execute((HttpUriRequest)put);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            logger.debug((Object)("HTTP STATUS: " + code));
            String responseHash = null;
            for (Header h : response.getAllHeaders()) {
                if (!h.getName().equals("ETag")) continue;
                responseHash = h.getValue();
            }
            if (responseHash != null && md5Hash != null && !responseHash.equals(md5Hash)) {
                throw new CloudException("MD5 hash values do not match, probably data corruption");
            }
            if (code != 201 && code != 202 && code != 204) {
                logger.error((Object)("Expected CREATED, ACCEPTED, or NO CONTENT for PUT request, got " + code));
                json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                JoyentException.ExceptionItems items = JoyentException.parseException(code, json);
                if (items == null) {
                    items = new JoyentException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                logger.error((Object)("[" + code + " : " + items.message + "] " + items.details));
                throw new JoyentException(items);
            }
            if (code == 202) {
                json = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        json = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)json);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
                if (json != null && !json.trim().equals("")) {
                    String string = json;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + JoyentMethod.class.getName() + ".doPutStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [PUT (" + new Date() + ")] -> " + endpoint + resource + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }
}

