/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.joyent.JoyentDataCenter;
import org.dasein.cloud.joyent.JoyentMethod;
import org.dasein.cloud.joyent.compute.JoyentComputeServices;
import org.dasein.cloud.joyent.storage.MantaStorageServices;
import org.dasein.cloud.storage.StorageServices;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SmartDataCenter
extends AbstractCloud {
    public static final String DSN_SSH_KEY = "sshKey";
    public static final String DSN_SSH_KEY_PASSWORD = "sshKeyPassword";
    private static final HashMap<String, Map<String, String>> endpointCache = new HashMap();

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls, @Nonnull String type) {
        String pkg = SmartDataCenter.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("joyent") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.joyent." + type + "." + pkg + SmartDataCenter.getLastItem(cls.getName())));
    }

    @Nonnull
    public synchronized StorageServices getStorageServices() {
        return new MantaStorageServices(this);
    }

    @Nonnull
    public JoyentComputeServices getComputeServices() {
        return new JoyentComputeServices(this);
    }

    @Nonnull
    public ContextRequirements getContextRequirements() {
        return new ContextRequirements(new ContextRequirements.Field[]{new ContextRequirements.Field(DSN_SSH_KEY, "Private SSH Key stored in Joyent", ContextRequirements.FieldType.KEYPAIR, "accessKeys", true), new ContextRequirements.Field(DSN_SSH_KEY_PASSWORD, "Password of ssh key uploaded to Joyent", ContextRequirements.FieldType.PASSWORD, "accessKeys", false), new ContextRequirements.Field("storageUrl", "Manta Storage URL", ContextRequirements.FieldType.TEXT, false), new ContextRequirements.Field("proxyHost", "Proxy host", ContextRequirements.FieldType.TEXT, false), new ContextRequirements.Field("proxyPort", "Proxy port", ContextRequirements.FieldType.TEXT, false)});
    }

    @Nonnull
    public String getCloudName() {
        return "Joyent Cloud";
    }

    @Nonnull
    public JoyentDataCenter getDataCenterServices() {
        return new JoyentDataCenter(this);
    }

    @Nonnull
    public String getEndpoint() throws CloudException, InternalException {
        String endpoint;
        Map<String, String> cache;
        String r;
        String[] parts;
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new CloudException("No context has been established for this request");
        }
        String e = ctx.getCloud().getEndpoint();
        if (e == null) {
            e = "https://us-west-1.api.joyentcloud.com";
        }
        if ((parts = e.split(",")) == null || parts.length < 1) {
            parts = new String[]{e};
        }
        if ((r = ctx.getRegionId()) == null) {
            return parts[0];
        }
        if (endpointCache.containsKey(e) && (cache = endpointCache.get(e)) != null && cache.containsKey(r) && (endpoint = cache.get(r)) != null) {
            return endpoint;
        }
        JoyentMethod method = new JoyentMethod(this);
        String json = method.doGetJson(parts[0], "datacenters");
        try {
            JSONObject ob = new JSONObject(json);
            JSONArray ids = ob.names();
            for (int i = 0; i < ids.length(); ++i) {
                Map<Object, Object> cache2;
                String regionId = ids.getString(i);
                if (!regionId.equals(r) || !ob.has(regionId)) continue;
                String endpoint2 = ob.getString(regionId);
                if (endpointCache.containsKey(e)) {
                    cache2 = endpointCache.get(e);
                } else {
                    cache2 = new HashMap();
                    endpointCache.put(e, cache2);
                }
                cache2.put(r, endpoint2);
                return endpoint2;
            }
            throw new CloudException("No endpoint exists for " + r);
        }
        catch (JSONException ex) {
            throw new CloudException((Throwable)ex);
        }
    }

    @Nonnull
    public String getProviderName() {
        return "Joyent";
    }

    @Nonnegative
    public long parseTimestamp(String time) throws CloudException {
        if (time == null) {
            return 0L;
        }
        int idx = time.lastIndexOf(43);
        if (idx < 0) {
            idx = time.lastIndexOf(90);
            if (idx < 0) {
                throw new CloudException("Could not parse timestamp: " + time);
            }
            time = time.substring(0, idx);
        } else {
            time = time.substring(0, idx);
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (time.length() > 0) {
            try {
                return fmt.parse(time).getTime();
            }
            catch (ParseException e) {
                fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                try {
                    return fmt.parse(time).getTime();
                }
                catch (ParseException e2) {
                    throw new CloudException("Could not parse timestamp: " + time, (Throwable)e2);
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        Logger logger = SmartDataCenter.getLogger(SmartDataCenter.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + SmartDataCenter.class.getName() + ".textContext()"));
        }
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                String string = null;
                return string;
            }
            String pk = ctx.getAccountNumber();
            JoyentMethod method = new JoyentMethod(this);
            try {
                method.doGetJson(this.getEndpoint(), "datacenters");
                String string = pk;
                return string;
            }
            catch (CloudException e) {
                String string;
                block15: {
                    if (!e.getErrorType().equals((Object)CloudErrorType.AUTHENTICATION)) break block15;
                    String string2 = null;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("exit - " + SmartDataCenter.class.getName() + ".testContext()"));
                    }
                    return string2;
                }
                try {
                    logger.warn((Object)("Cloud error testing Joyent context: " + e.getMessage()), (Throwable)e);
                    string = null;
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to test Joyent connection context: " + t.getMessage()), t);
                    String string3 = null;
                    return string3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + SmartDataCenter.class.getName() + ".testContext()"));
                }
                return string;
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + SmartDataCenter.class.getName() + ".testContext()"));
            }
        }
    }
}

