/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.joyent.JoyentException;
import org.dasein.cloud.joyent.JoyentMethod;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.dasein.cloud.joyent.compute.DatasetCapabilities;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Dataset
extends AbstractImageSupport<SmartDataCenter> {
    private static final String[] VALID_CAPTURE_OS = new String[]{"base", "base64", "centos-6", "debian-7", "ubuntu-certified-14.04", "ubuntu-certified-13.10", "ubuntu-certified-12.04"};
    private static final String OWNER_JOYENT = "--joyent--";
    private volatile transient DatasetCapabilities capabilities;

    Dataset(@Nonnull SmartDataCenter sdc) {
        super((CloudProvider)sdc);
    }

    public ImageCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new DatasetCapabilities((SmartDataCenter)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.capture");
        try {
            VirtualMachine vm = ((SmartDataCenter)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(options.getVirtualMachineId());
            if (vm == null) {
                throw new CloudException("Virtual machine not found: " + options.getVirtualMachineId());
            }
            String originalImageId = vm.getProviderMachineImageId();
            if (originalImageId == null) {
                throw new CloudException("Image capture is not supported for this VM, original image is unknown.");
            }
            MachineImage originalImage = this.getImage(originalImageId);
            if (!OWNER_JOYENT.equalsIgnoreCase(originalImage.getProviderOwnerId())) {
                throw new CloudException("Image capture is not supported for VMs launched from custom images.");
            }
            boolean validOs = false;
            for (String os : VALID_CAPTURE_OS) {
                if (!originalImage.getName().startsWith(os)) continue;
                validOs = true;
                break;
            }
            if (!validOs) {
                throw new CloudException("Image capture is not supported for this VM, the OS of the original image is not supported.");
            }
            if (task != null) {
                task.setStartTime(System.currentTimeMillis());
            }
            String vmID = options.getVirtualMachineId();
            String imageName = options.getName();
            String version = "1.0.0";
            if (!this.getCapabilities().canImage(vm.getCurrentState())) {
                throw new CloudException("Server must be stopped before making an image - current state: " + vm.getCurrentState());
            }
            JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
            HashMap<String, String> post = new HashMap<String, String>();
            post.put("machine", vmID);
            post.put("name", imageName);
            post.put("version", version);
            String json = method.doPostString(((SmartDataCenter)this.getProvider()).getEndpoint(), "images", new JSONObject(post).toString());
            if (json == null) {
                throw new CloudException("No image was created");
            }
            MachineImage img = null;
            try {
                JSONObject jsonObject = new JSONObject(json);
                if (jsonObject.has("id")) {
                    img = this.getImage(jsonObject.getString("id"));
                }
            }
            catch (JSONException e) {
                throw new CloudException((Throwable)e);
            }
            if (img == null) {
                throw new CloudException("No image was created");
            }
            if (task != null) {
                task.completeWithResult((Object)img);
            }
            MachineImage machineImage = img;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
        try {
            String json = method.doGetJson(((SmartDataCenter)this.getProvider()).getEndpoint(), "images/" + providerImageId);
            if (json == null) {
                return null;
            }
            return this.toMachineImage(new JSONObject(json));
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
        try {
            JSONObject jsonObject;
            String json = method.doGetJson(((SmartDataCenter)this.getProvider()).getEndpoint(), "images/" + machineImageId);
            if (json != null && (jsonObject = new JSONObject(json)).has("public")) {
                return jsonObject.getBoolean("public");
            }
            return false;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        Boolean isSubscribed;
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"Image.isSubscribed", Boolean.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
        Iterable cachedIsSubscribed = cache.get(this.getContext());
        if (cachedIsSubscribed != null && cachedIsSubscribed.iterator().hasNext() && (isSubscribed = (Boolean)cachedIsSubscribed.iterator().next()) != null) {
            return isSubscribed;
        }
        JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
        try {
            method.doGetJson(((SmartDataCenter)this.getProvider()).getEndpoint(), "images");
        }
        catch (JoyentException e) {
            if (e.getErrorType().equals((Object)CloudErrorType.AUTHENTICATION)) {
                cache.put(this.getContext(), Collections.singleton(false));
                return false;
            }
            throw e;
        }
        cache.put(this.getContext(), Collections.singleton(true));
        return true;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImages");
        try {
            JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
            try {
                JSONArray arr = new JSONArray(method.doGetJson(((SmartDataCenter)this.getProvider()).getEndpoint(), "images?public=false"));
                ArrayList<MachineImage> images = new ArrayList<MachineImage>();
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject ob = arr.getJSONObject(i);
                    MachineImage image = this.toMachineImage(ob);
                    if (image == null || !options.matches(image)) continue;
                    images.add(image);
                }
                ArrayList<MachineImage> arrayList = images;
                return arrayList;
            }
            catch (JSONException e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String forMachineImageId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.remove");
        try {
            JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
            method.doDelete(((SmartDataCenter)this.getProvider()).getEndpoint(), "images/" + providerImageId);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nonnull ImageFilterOptions options) throws CloudException, InternalException {
        JoyentMethod method = new JoyentMethod((SmartDataCenter)this.getProvider());
        try {
            JSONArray arr = new JSONArray(method.doGetJson(((SmartDataCenter)this.getProvider()).getEndpoint(), "images?public=true"));
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            for (int i = 0; i < arr.length(); ++i) {
                MachineImage image = this.toMachineImage(arr.getJSONObject(i));
                if (image == null || !options.matches(image)) continue;
                image.sharedWithPublic();
                images.add(image);
            }
            return images;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private MachineImage toMachineImage(@Nullable JSONObject json) throws CloudException, InternalException {
        String description;
        String name;
        String imageId;
        if (json == null) {
            return null;
        }
        String regionId = this.getContext().getRegionId();
        if (regionId == null) {
            throw new InternalException("No region ID was specified for this request");
        }
        String owner = OWNER_JOYENT;
        Architecture architecture = Architecture.I64;
        Platform platform = Platform.UNKNOWN;
        long created = 0L;
        Boolean isPublic = null;
        long minRamSize = 0L;
        MachineImageState state = MachineImageState.PENDING;
        try {
            if (!json.has("id")) {
                return null;
            }
            imageId = json.getString("id");
            name = json.has("name") ? json.getString("name") : imageId;
            description = json.has("description") ? json.getString("description") : name + " (" + platform + ") [#" + imageId + "]";
            if (json.has("os")) {
                String os = name == null ? json.getString("os") : name + " " + json.getString("os");
                platform = Platform.guess((String)os);
                architecture = Dataset.guessArch(os);
            }
            if (json.has("created")) {
                created = ((SmartDataCenter)this.getProvider()).parseTimestamp(json.getString("created"));
            }
            if (json.has("version")) {
                String version = json.getString("version");
                name = name + ":" + version;
            }
            if (json.has("public")) {
                isPublic = json.getBoolean("public");
                String string = owner = isPublic != false ? OWNER_JOYENT : this.getContext().getAccountNumber();
            }
            if (json.has("requirements")) {
                JSONObject requirements = json.getJSONObject("requirements");
                if (requirements.has("min_ram")) {
                    minRamSize = requirements.getLong("min_ram");
                } else if (requirements.has("min_memory")) {
                    minRamSize = requirements.getLong("min_memory");
                }
            }
            if (json.has("state") && "active".equalsIgnoreCase(json.getString("state"))) {
                state = MachineImageState.ACTIVE;
            }
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
        MachineImage machineImage = MachineImage.getInstance((String)owner, (String)regionId, (String)imageId, (ImageClass)ImageClass.MACHINE, (MachineImageState)state, (String)name, (String)description, (Architecture)architecture, (Platform)platform).createdAt(created);
        if (isPublic != null) {
            machineImage.setTag("public", String.valueOf(isPublic));
            if (isPublic.booleanValue()) {
                machineImage.sharedWithPublic();
            }
        }
        if (minRamSize > 0L) {
            machineImage.getProviderMetadata().put("min_ram", String.valueOf(minRamSize));
        }
        return machineImage;
    }

    private static boolean surroundedByDigits(String hay, String needle) throws Exception {
        hay = " " + hay + " ";
        int index = hay.indexOf(needle);
        if (index > 0) {
            return Character.isDigit(hay.charAt(index - 1)) && Character.isDigit(hay.charAt(index + needle.length()));
        }
        throw new Exception();
    }

    private static Architecture guessArch(String testString) {
        String[] needles;
        for (String needle : needles = new String[]{"32", "386"}) {
            try {
                if (Dataset.surroundedByDigits(testString, needle)) continue;
                return Architecture.I32;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Architecture.I64;
    }
}

